/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteDescription;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.site.SitePage;
import org.eclipse.pde.internal.ui.parts.FolderSelectionDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class DescriptionSection
extends PDEFormSection {
    private FormEntry url;
    private FormEntry text;
    private boolean updateNeeded;
    private FormEntry featureDest;
    private FormEntry pluginDest;

    public DescriptionSection(SitePage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString("SiteEditor.DescriptionSection.header"));
        this.setDescription(PDEPlugin.getResourceString("SiteEditor.DescriptionSection.desc"));
    }

    public void commitChanges(boolean onSave) {
        this.url.commit();
        this.text.commit();
        this.pluginDest.commit();
        this.featureDest.commit();
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (onSave && buildModel instanceof WorkspaceSiteBuildModel && ((WorkspaceSiteBuildModel)buildModel).isDirty()) {
            ((WorkspaceSiteBuildModel)buildModel).save();
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        this.createLeftContainer(container, factory);
        this.createRightContainer(container, factory);
        factory.paintBordersFor(container);
        return container;
    }

    private void createRightContainer(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1810));
        Text area = this.createText(container, PDEPlugin.getResourceString("SiteEditor.DescriptionSection.descLabel"), factory, 1, 66);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        area.setLayoutData((Object)gd);
        this.text = new FormEntry(area);
        this.text.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                DescriptionSection.this.setDescriptionText(text.getValue());
            }

            public void textDirty(FormEntry text) {
                DescriptionSection.this.forceDirty();
            }
        });
        factory.paintBordersFor(container);
    }

    private void createLeftContainer(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.url = new FormEntry(this.createText(container, PDEPlugin.getResourceString("SiteEditor.DescriptionSection.urlLabel"), factory, 2));
        this.url.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                DescriptionSection.this.setDescriptionURL(text.getValue());
            }

            public void textDirty(FormEntry text) {
                DescriptionSection.this.forceDirty();
            }
        });
        this.pluginDest = new FormEntry(this.createText(container, PDEPlugin.getResourceString(PDEPlugin.getResourceString("SiteEditor.DescriptionSection.pluginLocation")), factory, 1));
        this.pluginDest.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                DescriptionSection.this.setPluginDestination(text.getValue());
            }

            public void textDirty(FormEntry text) {
                DescriptionSection.this.forceDirty();
            }
        });
        Button browse = factory.createButton(container, PDEPlugin.getResourceString("SiteEditor.DescriptionSection.browse"), 8);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFolder folder = DescriptionSection.this.handleFindContainer();
                if (folder != null) {
                    DescriptionSection.this.pluginDest.setValue(folder.getProjectRelativePath().addTrailingSeparator().toString());
                }
            }
        });
        this.featureDest = new FormEntry(this.createText(container, PDEPlugin.getResourceString(PDEPlugin.getResourceString("SiteEditor.DescriptionSection.featureLocation")), factory, 1));
        this.featureDest.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                DescriptionSection.this.setFeatureDestination(text.getValue());
            }

            public void textDirty(FormEntry text) {
                DescriptionSection.this.forceDirty();
            }
        });
        browse = factory.createButton(container, PDEPlugin.getResourceString("SiteEditor.DescriptionSection.browse"), 8);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFolder folder = DescriptionSection.this.handleFindContainer();
                if (folder != null) {
                    DescriptionSection.this.featureDest.setValue(folder.getProjectRelativePath().addTrailingSeparator().toString());
                }
            }
        });
        factory.paintBordersFor(container);
    }

    private IFolder handleFindContainer() {
        FolderSelectionDialog dialog = new FolderSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ContentProvider(){});
        dialog.setInput(PDEPlugin.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IResource resource;
                if (element instanceof IProject && (resource = ((ISiteModel)DescriptionSection.this.getFormPage().getModel()).getUnderlyingResource()) != null) {
                    return ((IProject)element).equals((Object)resource.getProject());
                }
                return element instanceof IFolder;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString("SiteEditor.DescriptionSection.folderSelection"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFolder) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private void setPluginDestination(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setPluginLocation((IPath)new Path(text));
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setFeatureDestination(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel == null) {
            return;
        }
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        try {
            siteBuild.setFeatureLocation((IPath)new Path(text));
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setDescriptionURL(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISite site = model.getSite();
        ISiteDescription description = site.getDescription();
        boolean defined = false;
        if (description == null) {
            description = model.getFactory().createDescription(null);
            defined = true;
        }
        try {
            description.setURL(text);
            if (defined) {
                site.setDescription(description);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setDescriptionText(String text) {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        ISite site = model.getSite();
        ISiteDescription description = site.getDescription();
        boolean defined = false;
        if (description == null) {
            description = model.getFactory().createDescription(null);
            defined = true;
        }
        try {
            description.setText(text);
            if (defined) {
                site.setDescription(description);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void forceDirty() {
        this.setDirty(true);
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            ((IEditable)model).setDirty(true);
        }
        this.getFormPage().getEditor().fireSaveNeeded();
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        model.getBuildModel().removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        ISiteBuildModel buildModel;
        ISiteModel model = (ISiteModel)input;
        this.update(input);
        if (!model.isEditable()) {
            this.url.getControl().setEditable(false);
            this.text.getControl().setEditable(false);
        }
        if (!(buildModel = model.getBuildModel()).isEditable()) {
            this.featureDest.getControl().setEditable(false);
            this.pluginDest.getControl().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
        buildModel.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        this.updateNeeded = true;
        this.update();
    }

    public void setFocus() {
        if (this.url != null) {
            this.url.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        ISiteModel model = (ISiteModel)input;
        ISite site = model.getSite();
        this.setIfDefined(this.url, site.getDescription() != null ? site.getDescription().getURL() : null);
        this.setIfDefined(this.text, site.getDescription() != null ? site.getDescription().getText() : null);
        ISiteBuildModel buildModel = model.getBuildModel();
        if (buildModel != null) {
            ISiteBuild siteBuild = buildModel.getSiteBuild();
            this.setIfDefined(this.featureDest, siteBuild.getFeatureLocation() != null ? siteBuild.getFeatureLocation().toString() : null);
            this.setIfDefined(this.pluginDest, siteBuild.getPluginLocation() != null ? siteBuild.getPluginLocation().toString() : null);
        }
        this.updateNeeded = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    class ContentProvider
    extends WorkbenchContentProvider {
        ContentProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFolder) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

