/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.site.NewArchiveDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class ArchiveSection
extends PDEFormSection {
    private Table fTable;
    private TableViewer fViewer;
    private boolean fUpdateNeeded;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;

    public ArchiveSection(PDEFormPage formPage) {
        super(formPage);
        this.setHeaderText(PDEPlugin.getResourceString("SiteEditor.ArchiveSection.header"));
        this.setDescription(PDEPlugin.getResourceString("SiteEditor.ArchiveSection.title"));
        this.setCollapsable(true);
        this.setCollapsed(((ISiteModel)this.getFormPage().getModel()).getSite().getArchives().length == 0);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 25;
        container.setLayout((Layout)layout);
        this.createTable(container, factory);
        this.createTableViewer();
        this.createButtons(container, factory);
        factory.paintBordersFor(container);
        return container;
    }

    private void createButtons(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(2));
        this.fAddButton = factory.createButton(container, PDEPlugin.getResourceString("SiteEditor.add"), 8);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveSection.this.showDialog(null);
            }
        });
        this.fEditButton = factory.createButton(container, PDEPlugin.getResourceString("SiteEditor.edit"), 8);
        this.fEditButton.setLayoutData((Object)new GridData(768));
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)ArchiveSection.this.fViewer.getSelection();
                if (ssel != null && ssel.size() == 1) {
                    ArchiveSection.this.showDialog((ISiteArchive)ssel.getFirstElement());
                }
            }
        });
        this.fRemoveButton = factory.createButton(container, PDEPlugin.getResourceString("SiteEditor.remove"), 8);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveSection.this.handleDelete();
            }
        });
        this.fRemoveButton.setEnabled(false);
        this.fEditButton.setEnabled(false);
        factory.paintBordersFor(container);
    }

    private void createTable(Composite container, FormWidgetFactory factory) {
        this.fTable = factory.createTable(container, 67584);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        this.fTable.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(this.fTable, 0);
        col1.setText(PDEPlugin.getResourceString("SiteEditor.ArchiveSection.col1"));
        TableColumn col2 = new TableColumn(this.fTable, 0);
        col2.setText(PDEPlugin.getResourceString("SiteEditor.ArchiveSection.col2"));
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 200));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 200));
        this.fTable.setLayout((Layout)tlayout);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.createContextMenu((Control)this.fTable);
    }

    private void createTableViewer() {
        this.fViewer = new TableViewer(this.fTable);
        this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ArchiveLabelProvider());
        this.fViewer.setInput(this.getFormPage().getModel());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArchiveSection.this.handleSelectionChanged();
            }
        });
    }

    private void handleSelectionChanged() {
        ISelection selection = this.fViewer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.fRemoveButton.setEnabled(ssel.size() > 0);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    private void showDialog(final ISiteArchive archive) {
        final ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        BusyIndicator.showWhile((Display)this.fTable.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewArchiveDialog dialog = new NewArchiveDialog(ArchiveSection.this.fTable.getShell(), model, archive);
                dialog.create();
                SWTUtil.setDialogSize(dialog, 400, -1);
                if (dialog.open() == 0) {
                    ArchiveSection.this.fViewer.refresh();
                }
            }
        });
    }

    private void handleDelete() {
        try {
            IStructuredSelection ssel;
            ISelection selection = this.fViewer.getSelection();
            if (selection != null && selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() > 0) {
                ISiteArchive[] array = ssel.toList().toArray(new ISiteArchive[ssel.size()]);
                ISite site = ((ISiteModel)this.getFormPage().getModel()).getSite();
                site.removeArchives(array);
                this.forceDirty();
                this.fViewer.refresh();
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fTable.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ArchiveSection.this.handleDelete();
                }
            });
            return true;
        }
        return false;
    }

    public void update() {
        if (this.fUpdateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        this.fViewer.setInput(input);
        this.fViewer.refresh();
        this.fUpdateNeeded = false;
    }

    public void initialize(Object input) {
        this.update(input);
        ISiteModel model = (ISiteModel)input;
        if (!model.isEditable()) {
            this.fAddButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        this.fUpdateNeeded = true;
        this.update();
    }

    private void forceDirty() {
        this.setDirty(true);
        ISiteModel model = (ISiteModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            ((IEditable)model).setDirty(true);
        }
        this.getFormPage().getEditor().fireSaveNeeded();
    }

    private void createContextMenu(Control control) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                mng.add((IAction)new Action(this, PDEPlugin.getResourceString("SiteEditor.remove")){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        7.access$0(this.this$1).doGlobalAction(ActionFactory.DELETE.getId());
                    }
                });
                mng.add((IContributionItem)new Separator());
                PDEEditorContributor contributor = ArchiveSection.this.getFormPage().getEditor().getContributor();
                contributor.contextMenuAboutToShow(mng);
            }

            static /* synthetic */ ArchiveSection access$0(7 var0) {
                return var0.ArchiveSection.this;
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        control.setMenu(popupMenuManager.createContextMenu(control));
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            ISiteModel model = (ISiteModel)parent;
            return model.getSite().getArchives();
        }
    }

    class ArchiveLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArchiveLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ISiteArchive archive = (ISiteArchive)obj;
            switch (index) {
                case 0: {
                    return archive.getPath();
                }
                case 1: {
                    return archive.getURL();
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

