/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Hashtable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.schema.EnumerationRestrictionPage;
import org.eclipse.pde.internal.ui.editor.schema.IRestrictionPage;
import org.eclipse.pde.internal.ui.editor.schema.NoRestrictionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

public class TypeRestrictionDialog
extends Dialog {
    public static final String KEY_RESTRICTION_TYPE = "SchemaEditor.RestrictionDialog.type";
    private static final String T_ENUMERATION = "enumeration";
    private static final String T_NONE = "none";
    private String[] typeChoices = new String[]{"none", "enumeration"};
    private Combo typeCombo;
    private Hashtable pages = new Hashtable();
    private ISchemaRestriction restriction;
    private PageBook pageBook;

    public TypeRestrictionDialog(Shell shell, ISchemaRestriction restriction) {
        super(shell);
        if (restriction != null && restriction.getChildren().length > 0) {
            this.restriction = restriction;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_RESTRICTION_TYPE));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.typeCombo = new Combo(container, 12);
        this.initializeTypeCombo();
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeRestrictionDialog.this.handleTypeSelection();
            }
        });
        gd = new GridData(768);
        this.typeCombo.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label = new Label(container, 266);
        label.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.pageBook = new PageBook(container, 0);
        this.pageBook.setLayoutData((Object)gd);
        this.initializePages();
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.schema_type_restriction");
        return container;
    }

    public Object getValue() {
        return this.restriction;
    }

    private void handleTypeSelection() {
        String selection = this.typeCombo.getItem(this.typeCombo.getSelectionIndex());
        IRestrictionPage page = (IRestrictionPage)this.pages.get(selection);
        this.pageBook.showPage(page.getControl());
    }

    protected void initializePages() {
        IRestrictionPage pageToShow = null;
        String typeToShow = null;
        IRestrictionPage page = new NoRestrictionPage();
        page.createControl((Composite)this.pageBook);
        this.pages.put(T_NONE, page);
        if (this.restriction == null) {
            pageToShow = page;
            typeToShow = T_NONE;
        }
        page = new EnumerationRestrictionPage();
        page.createControl((Composite)this.pageBook);
        this.pages.put(T_ENUMERATION, page);
        if (this.restriction != null && page.getCompatibleRestrictionClass().isInstance(this.restriction)) {
            pageToShow = page;
            typeToShow = T_ENUMERATION;
        }
        pageToShow.initialize(this.restriction);
        this.typeCombo.setText(typeToShow);
        this.pageBook.showPage(pageToShow.getControl());
    }

    protected void initializeTypeCombo() {
        this.typeCombo.setItems(this.typeChoices);
    }

    protected void okPressed() {
        String selectedRestriction = this.typeChoices[this.typeCombo.getSelectionIndex()];
        IRestrictionPage page = (IRestrictionPage)this.pages.get(selectedRestriction);
        this.restriction = page.getRestriction();
        super.okPressed();
    }
}

