/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class SchemaSpecSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "SchemaEditor.SpecSection.title";
    public static final String SECTION_DESC = "SchemaEditor.SpecSection.desc";
    public static final String SECTION_PLUGIN = "SchemaEditor.SpecSection.plugin";
    public static final String SECTION_POINT = "SchemaEditor.SpecSection.point";
    public static final String SECTION_NAME = "SchemaEditor.SpecSection.name";
    private FormEntry pluginText;
    private FormEntry pointText;
    private FormEntry nameText;
    private boolean updateNeeded;

    public SchemaSpecSection(SchemaFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.setCollapsable(true);
        this.setCollapsed(true);
    }

    public void commitChanges(boolean onSave) {
        this.pluginText.commit();
        this.pointText.commit();
        this.nameText.commit();
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        final Schema schema = (Schema)this.getFormPage().getModel();
        this.pluginText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_PLUGIN), factory));
        this.pluginText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                schema.setPluginId(text.getValue());
            }

            public void textDirty(FormEntry text) {
                SchemaSpecSection.this.forceDirty();
            }
        });
        this.pointText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_POINT), factory));
        this.pointText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                schema.setPointId(text.getValue());
            }

            public void textDirty(FormEntry text) {
                SchemaSpecSection.this.forceDirty();
            }
        });
        this.nameText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_NAME), factory));
        this.nameText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                schema.setName(text.getValue());
                SchemaSpecSection.this.getFormPage().getForm().setHeadingText(schema.getName());
            }

            public void textDirty(FormEntry text) {
                SchemaSpecSection.this.forceDirty();
            }
        });
        GridData gd = (GridData)this.pointText.getControl().getLayoutData();
        gd.widthHint = 150;
        factory.paintBordersFor(container);
        return container;
    }

    private void forceDirty() {
        this.setDirty(true);
        ISchema schema = (ISchema)this.getFormPage().getModel();
        if (schema instanceof IEditable) {
            IEditable editable = (IEditable)schema;
            editable.setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    public void dispose() {
        ISchema schema = (ISchema)this.getFormPage().getModel();
        schema.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        ISchema schema = (ISchema)input;
        this.update(input);
        if (!(schema instanceof IEditable)) {
            this.pluginText.getControl().setEnabled(false);
            this.pointText.getControl().setEnabled(false);
            this.nameText.getControl().setEnabled(false);
        }
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        return this.pluginText.isDirty() || this.pointText.isDirty() || this.nameText.isDirty();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        }
    }

    public void setFocus() {
        if (this.pointText != null) {
            this.pointText.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        ISchema schema = (ISchema)input;
        this.setIfDefined(this.pluginText, schema.getPluginId());
        this.setIfDefined(this.pointText, schema.getPointId());
        this.setIfDefined(this.nameText, schema.getName());
        this.getFormPage().getForm().setHeadingText(schema.getName());
        this.updateNeeded = false;
    }
}

