/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.ui.editor.schema.DescriptionSection;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.GrammarSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaSpecSection;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;
import org.eclipse.update.ui.forms.internal.SectionChangeManager;

public class SchemaForm
extends ScrollableSectionForm
implements IModelChangedListener {
    private SchemaSpecSection schemaSpecSection;
    private ElementSection elementSection;
    private DescriptionSection descriptionSection;
    private GrammarSection grammarSection;
    private SchemaFormPage page;
    private IColorManager colorManager = new ColorManager();

    public SchemaForm(SchemaFormPage page) {
        this.page = page;
        this.colorManager = new ColorManager();
        this.setVerticalFit(true);
    }

    protected void createFormClient(Composite parent) {
        FormWidgetFactory factory = this.getFactory();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.schemaSpecSection = new SchemaSpecSection(this.page);
        Control control = this.schemaSpecSection.createControl(parent, factory);
        GridData gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.grammarSection = new GrammarSection(this.page);
        control = this.grammarSection.createControl(parent, factory);
        gd = new GridData(784);
        gd.verticalSpan = 2;
        control.setLayoutData((Object)gd);
        this.elementSection = new ElementSection(this.page);
        control = this.elementSection.createControl(parent, factory);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.descriptionSection = new DescriptionSection(this.page, this.colorManager);
        control = this.descriptionSection.createControl(parent, factory);
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        control.setLayoutData((Object)gd);
        SectionChangeManager manager = new SectionChangeManager();
        manager.linkSections((FormSection)this.elementSection, (FormSection)this.grammarSection);
        manager.linkSections((FormSection)this.elementSection, (FormSection)this.descriptionSection);
        this.registerSection(this.schemaSpecSection);
        this.registerSection(this.elementSection);
        this.registerSection(this.grammarSection);
        this.registerSection(this.descriptionSection);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.schema_editor_main");
    }

    public void dispose() {
        ISchema schema = (ISchema)this.page.getModel();
        this.colorManager.dispose();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void expandTo(Object object) {
        this.elementSection.expandTo(object);
    }

    public void initialize(Object model) {
        ISchema schema = (ISchema)model;
        super.initialize(model);
        this.setHeadingText(schema.getName());
        ((Composite)this.getControl()).layout(true);
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            ISchema schema = (ISchema)this.page.getModel();
            this.setHeadingText(schema.getName());
        }
    }
}

