/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.schema.ElementSectionDragAdapter;
import org.eclipse.pde.internal.ui.editor.schema.ElementSectionDropAdapter;
import org.eclipse.pde.internal.ui.editor.schema.NewAttributeAction;
import org.eclipse.pde.internal.ui.editor.schema.NewElementAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class ElementSection
extends TreeSection {
    private TreeViewer treeViewer;
    private Schema schema;
    private NewElementAction newElementAction = new NewElementAction();
    private NewAttributeAction newAttributeAction = new NewAttributeAction();
    private Clipboard clipboard;
    public static final String SECTION_TITLE = "SchemaEditor.ElementSection.title";
    public static final String SECTION_DESC = "SchemaEditor.ElementSection.desc";
    public static final String SECTION_NEW_ELEMENT = "SchemaEditor.ElementSection.newElement";
    public static final String SECTION_NEW_ATTRIBUTE = "SchemaEditor.ElementSection.newAttribute";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private PropertiesAction propertiesAction;

    public ElementSection(PDEFormPage page) {
        super(page, new String[]{PDEPlugin.getResourceString(SECTION_NEW_ELEMENT), PDEPlugin.getResourceString(SECTION_NEW_ATTRIBUTE)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        this.createTree(container, factory);
        factory.paintBordersFor(container);
        this.propertiesAction = new PropertiesAction(this.getFormPage().getEditor());
        return container;
    }

    private void createTree(Composite container, FormWidgetFactory factory) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, factory);
        this.treeViewer = treePart.getTreeViewer();
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.initDragAndDrop();
    }

    private void initDragAndDrop() {
        this.clipboard = new Clipboard(this.treeViewer.getControl().getDisplay());
        int ops = 3;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new ElementSectionDragAdapter((ISelectionProvider)this.treeViewer, this));
        this.treeViewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ElementSectionDropAdapter(this));
    }

    TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNewElement();
        } else if (index == 1) {
            this.handleNewAttribute();
        }
    }

    public void dispose() {
        this.schema.removeModelChangedListener((IModelChangedListener)this);
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            ISelection sel = this.treeViewer.getSelection();
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj != null) {
                this.handleDelete(obj);
            }
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            ISelection sel = this.treeViewer.getSelection();
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj != null) {
                this.handleDelete(obj);
            }
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        if (object instanceof ISchemaElement || object instanceof ISchemaAttribute) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        SchemaElement element;
        final ISelection selection = this.treeViewer.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        MenuManager submenu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
        if (object == null || object instanceof SchemaElement) {
            this.newElementAction.setSchema(this.schema);
            this.newElementAction.setEnabled(this.schema.isEditable());
            submenu.add((IAction)this.newElementAction);
        }
        if (object != null && !(element = object instanceof SchemaElement ? (SchemaElement)object : (SchemaElement)((SchemaAttribute)object).getParent()).getName().equals("extension")) {
            this.newAttributeAction.setElement(element);
            this.newAttributeAction.setEnabled(this.schema.isEditable());
            submenu.add((IAction)this.newAttributeAction);
        }
        manager.add((IContributionItem)submenu);
        if (!(selection.isEmpty() || object instanceof SchemaElement && ((SchemaElement)object).getName().equals("extension"))) {
            manager.add((IContributionItem)new Separator());
            Action deleteAction = new Action(){

                public void run() {
                    ElementSection.this.handleDelete((IStructuredSelection)selection);
                }
            };
            deleteAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
            deleteAction.setEnabled(this.schema.isEditable());
            manager.add((IAction)deleteAction);
        }
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    private void handleDelete(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.handleDelete(iter.next());
        }
    }

    void handleDelete(Object object) {
        ISchemaObject sobject = (ISchemaObject)object;
        ISchemaObject parent = sobject.getParent();
        if (sobject instanceof ISchemaElement) {
            Schema schema = (Schema)parent;
            schema.removeElement((ISchemaElement)sobject);
            schema.updateReferencesFor((ISchemaElement)sobject, 2);
        } else if (sobject instanceof ISchemaAttribute) {
            SchemaElement element = (SchemaElement)parent;
            SchemaComplexType type = (SchemaComplexType)element.getType();
            type.removeAttribute((ISchemaAttribute)sobject);
        }
    }

    private void handleNewAttribute() {
        SchemaElement element;
        Object object = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (object != null && !(element = object instanceof SchemaElement ? (SchemaElement)object : (SchemaElement)((SchemaAttribute)object).getParent()).getName().equals("extension")) {
            this.newAttributeAction.setElement(element);
            this.newAttributeAction.run();
        }
    }

    private void handleNewElement() {
        this.newElementAction.setSchema(this.schema);
        this.newElementAction.run();
    }

    public void initialize(Object input) {
        this.schema = (Schema)input;
        this.treeViewer.setInput(input);
        this.schema.addModelChangedListener((IModelChangedListener)this);
        this.getTreePart().setButtonEnabled(0, this.schema.isEditable());
        this.getTreePart().setButtonEnabled(1, false);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.treeViewer.refresh();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof ISchemaObjectReference) {
            return;
        }
        if (obj instanceof ISchemaElement || obj instanceof ISchemaAttribute) {
            if (e.getChangeType() == 3) {
                this.treeViewer.update(obj, null);
            } else if (e.getChangeType() == 1) {
                ISchemaObject sobj = (ISchemaObject)obj;
                ISchemaObject parent = sobj.getParent();
                this.treeViewer.add((Object)parent, (Object)sobj);
                this.treeViewer.setSelection((ISelection)new StructuredSelection(obj), true);
            } else if (e.getChangeType() == 2) {
                ISchemaObject sobj = (ISchemaObject)obj;
                ISchemaObject parent = sobj.getParent();
                this.treeViewer.remove(obj);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)parent), true);
            }
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        this.fireSelectionNotification(object);
        this.getFormPage().setSelection((ISelection)selection);
        this.updateButtons();
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
        this.getFormPage().setSelection(this.treeViewer.getSelection());
    }

    private void updateButtons() {
        if (!this.schema.isEditable()) {
            return;
        }
        Object object = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        ISchemaObject sobject = (ISchemaObject)object;
        boolean canAddAttribute = false;
        if (sobject != null) {
            ISchemaElement element;
            String name = sobject.getName();
            if (sobject instanceof ISchemaElement) {
                if (!name.equals("extension")) {
                    canAddAttribute = true;
                }
            } else if (sobject instanceof ISchemaAttribute && !(element = (ISchemaElement)sobject.getParent()).getName().equals("extension")) {
                canAddAttribute = true;
            }
        }
        this.getTreePart().setButtonEnabled(1, canAddAttribute);
    }

    public void doPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            Object realTarget = this.getRealTarget(target, object);
            Object sibling = this.getSibling(target, object);
            if (realTarget != null) {
                this.doPaste(realTarget, sibling, object);
            }
            ++i;
        }
    }

    private Object getSibling(Object target, Object object) {
        if (target instanceof ISchemaElement && object instanceof ISchemaElement) {
            return target;
        }
        if (target instanceof ISchemaAttribute && object instanceof ISchemaAttribute) {
            return target;
        }
        return null;
    }

    private Object getRealTarget(Object target, Object object) {
        if (object instanceof ISchemaElement) {
            return this.schema;
        }
        if (object instanceof ISchemaAttribute) {
            if (target instanceof ISchemaAttribute) {
                return ((ISchemaAttribute)target).getParent();
            }
            if (target instanceof ISchemaElement) {
                return target;
            }
        }
        return null;
    }

    private void doPaste(Object realTarget, Object sibling, Object object) {
        if (object instanceof ISchemaElement) {
            SchemaElement element = (SchemaElement)object;
            element.setParent((ISchemaObject)this.schema);
            this.schema.addElement((ISchemaElement)element, (ISchemaElement)sibling);
            this.schema.updateReferencesFor((ISchemaElement)element, 1);
        } else if (object instanceof ISchemaAttribute) {
            SchemaElement element = (SchemaElement)realTarget;
            SchemaAttribute attribute = (SchemaAttribute)object;
            attribute.setParent((ISchemaObject)element);
            ISchemaType type = element.getType();
            SchemaComplexType complexType = null;
            if (!(type instanceof ISchemaComplexType)) {
                complexType = new SchemaComplexType(element.getSchema());
                element.setType((ISchemaType)complexType);
            } else {
                complexType = (SchemaComplexType)type;
            }
            complexType.addAttribute((ISchemaAttribute)attribute, (ISchemaAttribute)sibling);
        }
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            if (!(obj instanceof ISchemaAttribute ? target instanceof ISchemaAttribute || target instanceof ISchemaElement : obj instanceof ISchemaElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.propertiesAction.run();
    }

    class ContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object object) {
            Schema schema = (Schema)object;
            return schema.getElements();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ISchemaElement) {
                return ((ISchemaElement)parent).getAttributes();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof ISchemaObject) {
                return ((ISchemaObject)child).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }
    }
}

