/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.PDEPartitionScanner;
import org.eclipse.pde.internal.ui.editor.text.TextUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class DocSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "SchemaEditor.DocSection.title";
    public static final String KEY_APPLY = "Actions.apply.flabel";
    public static final String KEY_RESET = "Actions.reset.flabel";
    public static final String SECTION_DESC = "SchemaEditor.DocSection.desc";
    public static final String KEY_TOPIC_OVERVIEW = "SchemaEditor.topic.overview";
    public static final String KEY_TOPIC_SINCE = "SchemaEditor.topic.since";
    public static final String KEY_TOPIC_EXAMPLES = "SchemaEditor.topic.examples";
    public static final String KEY_TOPIC_IMPLEMENTATION = "SchemaEditor.topic.implementation";
    public static final String KEY_TOPIC_API = "SchemaEditor.topic.api";
    public static final String KEY_TOPIC_COPYRIGHT = "SchemaEditor.topic.copyright";
    private IDocument document;
    private IDocumentPartitioner partitioner;
    private SourceViewerConfiguration sourceConfiguration;
    private SourceViewer sourceViewer;
    private CCombo sectionCombo;
    private ISchema schema;
    private Button applyButton;
    private Button resetButton;
    private Object element;
    private boolean ignoreChange;

    public DocSection(PDEFormPage page, IColorManager colorManager) {
        super(page);
        this.setHeaderPainted(false);
        this.setAddSeparator(false);
        String description = PDEPlugin.getResourceString(SECTION_DESC);
        this.setDescription(TextUtil.createMultiLine(description, 80));
        this.sourceConfiguration = new XMLConfiguration(colorManager);
        this.document = new Document();
        this.partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PDEPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        this.partitioner.connect(this.document);
        this.document.setDocumentPartitioner(this.partitioner);
    }

    public void commitChanges(boolean onSave) {
        this.handleApply();
        if (onSave) {
            this.setDirty(false);
            this.resetButton.setEnabled(false);
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.verticalSpacing = 6;
        container.setLayout((Layout)layout);
        this.schema = (ISchema)this.getFormPage().getModel();
        Label label = factory.createLabel(container, null);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        int comboStyle = 8;
        comboStyle = !SWT.getPlatform().equals("motif") ? (comboStyle |= 0x800000) : (comboStyle |= 0x800);
        this.sectionCombo = new CCombo(container, comboStyle);
        this.sectionCombo.setBackground(factory.getBackgroundColor());
        gd = new GridData(768);
        this.sectionCombo.setLayoutData((Object)gd);
        factory.createLabel(container, null);
        int styles = 834;
        this.sourceViewer = new SourceViewer(container, null, styles);
        this.sourceViewer.configure(this.sourceConfiguration);
        this.sourceViewer.setDocument(this.document);
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DocSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getFormPage().getEditor().getContextMenu());
        if (!SWT.getPlatform().equals("motif")) {
            factory.paintBordersFor(container);
        }
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        Composite buttonContainer = factory.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        this.applyButton.setEnabled(false);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocSection.this.handleApply();
            }
        });
        this.resetButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        this.resetButton.setEnabled(false);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocSection.this.handleReset();
            }
        });
        this.initializeSectionCombo();
        return container;
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.sourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.sourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.sourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.sourceViewer.doOperation(7);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.sourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.sourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.sourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public void expandTo(Object input) {
        int index = -1;
        if (input instanceof ISchema) {
            index = 0;
        } else if (input instanceof IDocumentSection) {
            IDocumentSection[] sections = this.schema.getDocumentSections();
            int i = 0;
            while (i < sections.length) {
                IDocumentSection section = sections[i];
                if (section.equals(input)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
        }
        if (index != -1) {
            this.sectionCombo.select(index);
        }
        this.updateEditorInput(input);
    }

    private String getTopicName(Object object) {
        if (object instanceof ISchema) {
            return PDEPlugin.getResourceString(KEY_TOPIC_OVERVIEW);
        }
        if (object instanceof IDocumentSection) {
            IDocumentSection section = (IDocumentSection)object;
            String sectionId = section.getSectionId();
            if (sectionId.equals("examples")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_EXAMPLES);
            }
            if (sectionId.equals("since")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_SINCE);
            }
            if (sectionId.equals("implementation")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_IMPLEMENTATION);
            }
            if (sectionId.equals("apiInfo")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_API);
            }
            if (sectionId.equals("copyright")) {
                return PDEPlugin.getResourceString(KEY_TOPIC_COPYRIGHT);
            }
        }
        return "?";
    }

    private void handleApply() {
        if (this.element != null) {
            if (this.element instanceof ISchema) {
                ((Schema)this.element).setDescription(this.document.get());
            } else {
                ((SchemaObject)this.element).setDescription(this.document.get());
            }
        }
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    private void handleReset() {
        this.updateEditorInput(this.element);
    }

    public void initialize(Object model) {
        this.sourceViewer.setEditable(this.schema.isEditable());
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!DocSection.this.ignoreChange && DocSection.this.schema.isEditable()) {
                    DocSection.this.setDirty(true);
                    ((IEditable)DocSection.this.schema).setDirty(true);
                    DocSection.this.getFormPage().getEditor().fireSaveNeeded();
                }
                DocSection.this.applyButton.setEnabled(true);
                DocSection.this.resetButton.setEnabled(true);
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
        this.updateEditorInput(this.schema);
        this.schema.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        this.schema.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void initializeSectionCombo() {
        IDocumentSection[] sections = this.schema.getDocumentSections();
        this.loadSectionCombo(sections);
        this.sectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = DocSection.this.sectionCombo.getSelectionIndex();
                if (DocSection.this.schema.isEditable() && DocSection.this.isDirty()) {
                    DocSection.this.handleApply();
                }
                if (index == 0) {
                    DocSection.this.updateEditorInput(DocSection.this.schema);
                } else {
                    IDocumentSection[] sections = DocSection.this.schema.getDocumentSections();
                    DocSection.this.updateEditorInput(sections[index - 1]);
                }
            }
        });
    }

    private void loadSectionCombo(IDocumentSection[] sections) {
        this.sectionCombo.add(this.getTopicName(this.schema));
        int i = 0;
        while (i < sections.length) {
            IDocumentSection section = sections[i];
            this.sectionCombo.add(this.getTopicName(section));
            ++i;
        }
        this.sectionCombo.pack();
        this.sectionCombo.select(0);
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
        this.updateSelection(this.sourceViewer.getSelection());
    }

    private void updateSelection(ISelection selection) {
        this.getFormPage().getEditor().setSelection(selection);
    }

    public void updateEditorInput(Object input) {
        this.ignoreChange = true;
        String text = "";
        if (input instanceof ISchemaObject) {
            text = ((ISchemaObject)input).getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.document.set(text);
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.element = input;
        this.ignoreChange = false;
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99 && this.getFormPage().isVisible()) {
            this.update();
        }
    }

    public void update() {
        IDocumentSection[] sections;
        int itemCount = this.sectionCombo.getItemCount();
        if (itemCount != (sections = this.schema.getDocumentSections()).length + 1) {
            this.sectionCombo.removeAll();
            this.loadSectionCombo(sections);
            this.sectionCombo.getParent().layout();
            this.updateEditorInput(this.schema);
            return;
        }
        int index = this.sectionCombo.getSelectionIndex();
        if (index == 0) {
            this.updateEditorInput(this.schema);
        } else {
            this.updateEditorInput(sections[index - 1]);
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.sourceViewer.canDoOperation(5);
    }
}

