/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Vector;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.schema.ICloneablePropertySource;
import org.eclipse.pde.internal.ui.editor.schema.SchemaObjectPropertySource;
import org.eclipse.pde.internal.ui.editor.schema.TypeRestrictionDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AttributePropertySource
extends SchemaObjectPropertySource
implements ICloneablePropertySource {
    public static final String P_USE = "use";
    public static final String P_KIND = "kind";
    public static final String P_VALUE = "value";
    public static final String P_BASED_ON = "basedOn";
    public static final String P_TYPE = "type";
    public static final String KEY_COPY_OF = "SchemaEditor.AttributePR.attributeCopy";
    public static final String KEY_USE = "SchemaEditor.AttributePR.use";
    public static final String KEY_KIND = "SchemaEditor.AttributePR.kind";
    public static final String KEY_TYPE = "SchemaEditor.AttributePR.type";
    public static final String KEY_RESTRICTION = "SchemaEditor.AttributePR.restriction";
    public static final String KEY_VALUE = "SchemaEditor.AttributePR.value";
    public static final String KEY_BASED_ON = "SchemaEditor.AttributePR.basedOn";
    public static final String KEY_NAME = "SchemaEditor.AttributePR.name";
    public static final String P_RESTRICTION = "restriction";
    public static final String P_NAME = "name";
    private Vector descriptors;
    private static final String[] typeTable = new String[]{"string", "boolean"};

    public AttributePropertySource(ISchemaAttribute att) {
        super(att);
    }

    public Object doClone() {
        ISchemaAttribute att = (ISchemaAttribute)this.getSourceObject();
        SchemaElement element = (SchemaElement)att.getParent();
        String value = PDEPlugin.getFormattedMessage(KEY_COPY_OF, att.getName());
        SchemaAttribute att2 = new SchemaAttribute(att, value);
        ((SchemaComplexType)element.getType()).addAttribute((ISchemaAttribute)att2);
        return att2;
    }

    public Object getEditableValue() {
        return null;
    }

    private int getIndexOf(String value, String[] table) {
        int i = 0;
        while (i < table.length) {
            if (value.equals(table[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new Vector();
            PropertyDescriptor cdesc = this.createComboBoxPropertyDescriptor(P_USE, PDEPlugin.getResourceString(KEY_USE), ISchemaAttribute.useTable);
            if (cdesc instanceof ComboBoxPropertyDescriptor) {
                ((ComboBoxPropertyDescriptor)cdesc).setLabelProvider((ILabelProvider)new SchemaObjectPropertySource.ComboProvider(this, P_USE, ISchemaAttribute.useTable));
            }
            this.descriptors.addElement(cdesc);
            cdesc = this.createComboBoxPropertyDescriptor(P_KIND, PDEPlugin.getResourceString(KEY_KIND), ISchemaAttribute.kindTable);
            if (cdesc instanceof ComboBoxPropertyDescriptor) {
                ((ComboBoxPropertyDescriptor)cdesc).setLabelProvider((ILabelProvider)new SchemaObjectPropertySource.ComboProvider(this, P_KIND, ISchemaAttribute.kindTable));
            }
            this.descriptors.addElement(cdesc);
            cdesc = this.createComboBoxPropertyDescriptor(P_TYPE, PDEPlugin.getResourceString(KEY_TYPE), typeTable);
            if (cdesc instanceof ComboBoxPropertyDescriptor) {
                ((ComboBoxPropertyDescriptor)cdesc).setLabelProvider((ILabelProvider)new SchemaObjectPropertySource.ComboProvider(this, P_TYPE, typeTable));
            }
            this.descriptors.addElement(cdesc);
            cdesc = new TypeRestrictionDescriptor(P_RESTRICTION, PDEPlugin.getResourceString(KEY_RESTRICTION), !this.isEditable());
            this.descriptors.addElement(cdesc);
            cdesc = this.createTextPropertyDescriptor(P_VALUE, PDEPlugin.getResourceString(KEY_VALUE));
            cdesc.setValidator((ICellEditorValidator)new ValueValidator());
            this.descriptors.addElement(cdesc);
            PropertyDescriptor desc = this.createTextPropertyDescriptor(P_BASED_ON, PDEPlugin.getResourceString(KEY_BASED_ON));
            this.descriptors.addElement(desc);
            desc = this.createTextPropertyDescriptor(P_NAME, PDEPlugin.getResourceString(KEY_NAME));
            this.descriptors.addElement(desc);
        }
        return this.toDescriptorArray(this.descriptors);
    }

    public Object getPropertyValue(Object name) {
        ISchemaAttribute att = (ISchemaAttribute)this.getSourceObject();
        if (name.equals(P_RESTRICTION)) {
            return att.getType().getRestriction();
        }
        if (name.equals(P_VALUE)) {
            return this.getNonzeroValue(att.getValue());
        }
        if (name.equals(P_BASED_ON)) {
            return this.getNonzeroValue(att.getBasedOn());
        }
        if (name.equals(P_NAME)) {
            return this.getNonzeroValue(att.getName());
        }
        if (this.isEditable()) {
            if (name.equals(P_USE)) {
                return new Integer(att.getUse());
            }
            if (name.equals(P_KIND)) {
                return new Integer(att.getKind());
            }
            if (name.equals(P_TYPE)) {
                return new Integer(this.getIndexOf(att.getType().getName(), typeTable));
            }
        } else {
            if (name.equals(P_USE)) {
                return ISchemaAttribute.useTable[att.getUse()];
            }
            if (name.equals(P_KIND)) {
                return ISchemaAttribute.kindTable[att.getKind()];
            }
            if (name.equals(P_TYPE)) {
                return att.getType().getName();
            }
        }
        return "";
    }

    public boolean isCloneable() {
        ISchemaAttribute att = (ISchemaAttribute)this.getSourceObject();
        return !att.getParent().getName().equals("extension");
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPropertyValue(Object name, Object value) {
        SchemaAttribute att = (SchemaAttribute)this.getSourceObject();
        if (value instanceof Integer) {
            int index = (Integer)value;
            if (name.equals(P_USE)) {
                att.setUse(index);
            } else if (name.equals(P_KIND)) {
                att.setKind(index);
            } else if (name.equals(P_TYPE)) {
                att.setType((ISchemaSimpleType)new SchemaSimpleType(att.getSchema(), typeTable[index]));
                if (att.getValue() != null) {
                    att.setValue(null);
                }
            }
        } else if (name.equals(P_RESTRICTION)) {
            ISchemaRestriction restriction = (ISchemaRestriction)value;
            if (restriction != null && restriction.getChildren().length == 0) {
                restriction = null;
            }
            if (att.getType() instanceof SchemaSimpleType) {
                SchemaSimpleType type = (SchemaSimpleType)att.getType();
                type.setRestriction(restriction);
                att.setType((ISchemaSimpleType)type);
            }
        } else if (value instanceof String) {
            String svalue = (String)value;
            if (name.equals(P_VALUE)) {
                att.setValue(svalue);
            } else if (name.equals(P_BASED_ON)) {
                att.setBasedOn(svalue);
            } else if (name.equals(P_NAME)) {
                att.setName(svalue);
            }
        }
    }

    class ValueValidator
    implements ICellEditorValidator {
        ValueValidator() {
        }

        public String isValid(Object value) {
            ISchemaRestriction restriction;
            String svalue = value.toString();
            ISchemaAttribute att = (ISchemaAttribute)AttributePropertySource.this.getSourceObject();
            ISchemaSimpleType type = att.getType();
            if (type.getName().equals("boolean")) {
                if (!svalue.equals("true") && !svalue.equals("false")) {
                    return "Boolean value must either be \"true\" or \"false\"";
                }
            } else if (type.getName().equals("string") && type.getRestriction() != null && !(restriction = type.getRestriction()).isValueValid((Object)svalue)) {
                return "Value \"" + svalue + "\" is not valid for the specified restriction";
            }
            return null;
        }
    }
}

