/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class UnknownElementPropertySource
extends ManifestPropertySource {
    private Vector descriptors;
    private String TAG_NAME = PDEPlugin.getResourceString("ManifestEditor.PropertyPage.tagName");

    public UnknownElementPropertySource(IPluginElement element) {
        super((IPluginObject)element);
    }

    public void addAttribute(String name, String initialValue) {
        IPluginElement element = (IPluginElement)this.object;
        try {
            element.setAttribute(name, initialValue);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void createPropertyDescriptors() {
        this.descriptors = new Vector();
        IPluginElement element = (IPluginElement)this.object;
        PropertyDescriptor nameDesc = this.createTextPropertyDescriptor(this.TAG_NAME, this.TAG_NAME);
        this.descriptors.addElement(nameDesc);
        IPluginAttribute[] attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            IPluginAttribute att = attributes[i];
            PropertyDescriptor desc = this.createTextPropertyDescriptor(att.getName(), att.getName());
            this.descriptors.addElement(desc);
            ++i;
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPluginElement getElement() {
        return (IPluginElement)this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.createPropertyDescriptors();
        }
        return this.toDescriptorArray(this.descriptors);
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(this.TAG_NAME)) {
            return this.getElement().getName();
        }
        IPluginAttribute att = this.getElement().getAttribute(name.toString());
        if (att != null) {
            return att.getValue();
        }
        return null;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void removeAttribute(String name) {
        IPluginElement element = (IPluginElement)this.object;
        try {
            element.setAttribute(name, null);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.descriptors = null;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setElement(IPluginElement newElement) {
        this.object = newElement;
        this.descriptors = null;
    }

    public void setPropertyValue(Object name, Object value) {
        IPluginElement ee = (IPluginElement)this.object;
        String valueString = value.toString();
        try {
            if (name.equals(this.TAG_NAME)) {
                ee.setName(valueString);
            } else {
                ee.setAttribute(name.toString(), valueString == null | valueString.length() == 0 ? null : valueString);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

