/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.manifest.ResourceAttributeValue;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceAttributeCellEditor
extends DialogCellEditor {
    public static final String TITLE = "ManifestEditor.ResourceAttributeCellEditor.title";
    private Label label;

    protected ResourceAttributeCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createContents(Composite cell) {
        this.label = new Label(cell, 16384);
        this.label.setFont(cell.getFont());
        this.label.setBackground(cell.getBackground());
        return this.label;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ResourceAttributeValue value = (ResourceAttributeValue)this.getValue();
        final IProject project = value.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString(TITLE));
        dialog.setMessage(PDEPlugin.getResourceString("ManifestEditor.ResourceAttributeCellEditor.message"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            return new ResourceAttributeValue(project, file.getProjectRelativePath().toString());
        }
        return value;
    }

    protected void updateContents(Object value) {
        this.label.setText(value == null ? "" : value.toString());
    }
}

