/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionPointPage;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class PointUsageSection
extends TableSection {
    public static final String SECTION_TITLE = "ManifestEditor.PointUsageSection.title";
    public static final String SECTION_DESC = "ManifestEditor.PointUsageSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.PointUsageSection.fdesc";
    public static final String POPUP_OPEN = "Actions.open.label";
    private TableViewer tableViewer;

    public PointUsageSection(ManifestExtensionPointPage page) {
        super(page, null);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
        this.getTablePart().setEditable(false);
    }

    private void addReferencingPlugins(String pluginId, String fullPointId, IPluginModelBase[] models, Vector result) {
        int i = 0;
        while (i < models.length) {
            IPluginBase pluginBase;
            IPluginModelBase model = models[i];
            if (model.isEnabled() && !(pluginBase = model.getPluginBase()).getId().equals(pluginId) && this.testUsage(pluginBase, fullPointId)) {
                result.addElement(pluginBase);
            }
            ++i;
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        EditableTablePart part = this.getTablePart();
        this.createViewerPartControl(container, 4, 2, factory);
        this.tableViewer = part.getTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new UsageContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.tableViewer.setSorter(ListUtil.NAME_SORTER);
        factory.paintBordersFor(container);
        return container;
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    private Object[] getReferencedPlugins(IPluginExtensionPoint currentPoint) {
        Vector<IPluginBase> result = new Vector<IPluginBase>();
        if (currentPoint == null) {
            return new Object[0];
        }
        String fullPointId = currentPoint.getFullId();
        Object model = this.getFormPage().getModel();
        IPluginBase thisPluginBase = ((IPluginModelBase)model).getPluginBase();
        if (this.testUsage(thisPluginBase, fullPointId)) {
            result.add(thisPluginBase);
        }
        IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        this.addReferencingPlugins(thisPluginBase.getId(), fullPointId, (IPluginModelBase[])manager.getPluginModels(), result);
        IExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
        this.addReferencingPlugins(thisPluginBase.getId(), fullPointId, (IPluginModelBase[])registry.getPluginModels(), result);
        return result.toArray();
    }

    protected void fillContextMenu(IMenuManager manager) {
        final IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        if (!sel.isEmpty()) {
            manager.add((IAction)new Action(PDEPlugin.getResourceString(POPUP_OPEN)){

                public void run() {
                    PointUsageSection.this.handleOpen(sel);
                }
            });
            manager.add((IContributionItem)new Separator());
        }
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager, false);
        if (!sel.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
            actionGroup.setContext(new ActionContext((ISelection)sel));
            actionGroup.fillContextMenu(manager);
        }
    }

    private void handleOpen(IStructuredSelection selection) {
        IPluginBase pluginToOpen = (IPluginBase)selection.getFirstElement();
        if (pluginToOpen != null) {
            ManifestEditor.openPluginEditor(pluginToOpen);
        } else {
            Display.getCurrent().beep();
        }
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        this.inputChanged((IPluginExtensionPoint)changeObject);
    }

    private boolean testUsage(IPluginBase pluginBase, String pointId) {
        IPluginExtension[] extensions = pluginBase.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginExtension extension = extensions[i];
            if (extension.getPoint().equals(pointId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void inputChanged(IPluginExtensionPoint extensionPoint) {
        this.tableViewer.setInput((Object)extensionPoint);
    }

    public void modelChanged(IModelChangedEvent event) {
    }

    public void update() {
        this.tableViewer.refresh();
    }

    class UsageContentProvider
    extends DefaultTableProvider {
        UsageContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginExtensionPoint) {
                return PointUsageSection.this.getReferencedPlugins((IPluginExtensionPoint)parent);
            }
            return new Object[0];
        }
    }
}

