/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestRuntimePage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class PackagePrefixesSection
extends TableSection {
    private IPluginLibrary currentLibrary;
    private TableViewer nameTableViewer;
    public static final String SECTION_TITLE = "ManifestEditor.PackagePrefixesSection.title";
    public static final String SECTION_DESC = "ManifestEditor.PackagePrefixesSection.desc";
    public static final String KEY_ADD = "ManifestEditor.PackagePrefixesSection.add";
    public static final String KEY_REMOVE = "ManifestEditor.PackagePrefixesSection.remove";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private Vector packages;
    private Action addAction;
    private Action deleteAction;
    private boolean ignoreModelEvents;

    public PackagePrefixesSection(ManifestRuntimePage formPage) {
        super(formPage, new String[]{PDEPlugin.getResourceString(KEY_ADD), PDEPlugin.getResourceString(KEY_REMOVE)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.getTablePart().setEditable(false);
        this.handleDefaultButton = false;
    }

    public void commitChanges(boolean onSave) {
        if (!this.isDirty()) {
            return;
        }
        this.ignoreModelEvents = true;
        if (this.packages != null && this.currentLibrary != null) {
            try {
                if (this.packages.size() == 0) {
                    this.currentLibrary.setPackages(null);
                } else {
                    String[] result = new String[this.packages.size()];
                    int i = 0;
                    while (i < this.packages.size()) {
                        result[i] = this.packages.get(i).toString();
                        ++i;
                    }
                    this.currentLibrary.setPackages(result);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        this.setDirty(false);
        this.ignoreModelEvents = false;
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        this.createViewerPartControl(container, 65536, 2, factory);
        EditableTablePart part = this.getTablePart();
        this.nameTableViewer = part.getTableViewer();
        this.nameTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.nameTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        factory.paintBordersFor(container);
        return container;
    }

    private Object[] createPrefixes(String[] names) {
        if (this.packages == null) {
            this.packages = new Vector();
            if (names != null) {
                int i = 0;
                while (i < names.length) {
                    this.packages.add(new PackagePrefix(names[i]));
                    ++i;
                }
            }
        }
        Object[] result = new Object[this.packages.size()];
        this.packages.copyInto(result);
        return result;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.getFormPage().setSelection((ISelection)selection);
        this.getTablePart().setButtonEnabled(1, item != null);
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleAdd();
        } else if (index == 1) {
            this.handleDelete();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addAction);
        this.deleteAction.setEnabled(!this.isReadOnly() && !this.nameTableViewer.getSelection().isEmpty());
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void makeActions() {
        this.addAction = new Action(){

            public void run() {
                PackagePrefixesSection.this.handleAdd();
            }
        };
        this.addAction.setText(POPUP_NEW);
        this.addAction.setEnabled(this.isReadOnly());
        this.deleteAction = new Action(){

            public void run() {
                PackagePrefixesSection.this.handleDelete();
            }
        };
        this.deleteAction.setText(POPUP_DELETE);
    }

    private void handleAdd() {
        try {
            IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
            IProject project = model.getUnderlyingResource().getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot fragmentRoot = this.getPackageFragmentRoot(javaProject, this.currentLibrary);
            SelectionDialog dialog = fragmentRoot != null ? JavaUI.createPackageDialog((Shell)this.nameTableViewer.getControl().getShell(), (IPackageFragmentRoot)fragmentRoot) : JavaUI.createPackageDialog((Shell)this.nameTableViewer.getControl().getShell(), (IJavaProject)JavaCore.create((IProject)project), (int)0);
            dialog.setTitle(PDEPlugin.getResourceString("Java Packages"));
            dialog.setMessage("");
            int status = dialog.open();
            if (status == 0) {
                Object[] result = dialog.getResult();
                int i = 0;
                while (i < result.length) {
                    IPackageFragment packageFragment = (IPackageFragment)result[i];
                    PackagePrefix prefix = new PackagePrefix(packageFragment.getElementName());
                    if (this.packages == null) {
                        this.packages = new Vector();
                    }
                    this.packages.add(prefix);
                    this.nameTableViewer.add((Object)prefix);
                    ++i;
                }
                this.setDirty(true);
                this.commitChanges(false);
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaProject javaProject, IPluginLibrary library) throws JavaModelException {
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            String name = root.getElementName();
            if (name.equals(library.getName())) {
                return root;
            }
            ++i;
        }
        return null;
    }

    private void handleDelete() {
        ISelection selection = this.nameTableViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            PackagePrefix prefix = (PackagePrefix)iter.next();
            this.packages.remove(prefix);
            this.nameTableViewer.remove((Object)prefix);
        }
        this.getTablePart().setButtonEnabled(1, false);
        this.setDirty(true);
        this.commitChanges(false);
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.setReadOnly(!model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        if (this.isReadOnly()) {
            this.getTablePart().setButtonEnabled(0, false);
            this.getTablePart().setButtonEnabled(1, false);
        }
        this.makeActions();
        this.update(null);
    }

    public void modelChanged(IModelChangedEvent e) {
        Object object;
        if (this.ignoreModelEvents) {
            return;
        }
        if (e.getChangeType() == 3 && (object = e.getChangedObjects()[0]).equals(this.currentLibrary)) {
            this.update(this.currentLibrary);
        }
        if (e.getChangeType() == 99) {
            this.update(null);
        }
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        this.update((IPluginLibrary)changeObject);
    }

    private void update(IPluginLibrary library) {
        if (library == null) {
            this.getTablePart().setButtonEnabled(0, false);
            this.getTablePart().setButtonEnabled(1, false);
            this.currentLibrary = null;
            return;
        }
        if (this.currentLibrary == null && !this.isReadOnly()) {
            this.getTablePart().setButtonEnabled(0, true);
        }
        this.currentLibrary = library;
        this.packages = null;
        this.nameTableViewer.setInput((Object)library);
    }

    class PackagePrefix {
        private String name;

        public PackagePrefix(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginLibrary) {
                return PackagePrefixesSection.this.createPrefixes(((IPluginLibrary)parent).getPackages());
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
    }
}

