/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class MatchSection
extends PDEFormSection {
    private FormEntry versionText;
    private Button reexportButton;
    private Button optionalButton;
    private CCombo matchCombo;
    protected IPluginReference currentImport;
    protected IStructuredSelection multiSelection;
    private boolean blockChanges = false;
    private boolean ignoreModelEvents = false;
    private boolean addReexport = true;
    public static final String SECTION_TITLE = "ManifestEditor.MatchSection.title";
    public static final String SECTION_DESC = "ManifestEditor.MatchSection.desc";
    public static final String KEY_OPTIONAL = "ManifestEditor.MatchSection.optional";
    public static final String KEY_REEXPORT = "ManifestEditor.MatchSection.reexport";
    public static final String KEY_VERSION = "ManifestEditor.MatchSection.version";
    public static final String KEY_RULE = "ManifestEditor.MatchSection.rule";
    public static final String KEY_NONE = "ManifestEditor.MatchSection.none";
    public static final String KEY_PERFECT = "ManifestEditor.MatchSection.perfect";
    public static final String KEY_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    public static final String KEY_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    public static final String KEY_GREATER = "ManifestEditor.MatchSection.greater";
    public static final String KEY_VERSION_FORMAT = "ManifestEditor.PluginSpecSection.versionFormat";
    public static final String KEY_VERSION_TITLE = "ManifestEditor.PluginSpecSection.versionTitle";

    public MatchSection(PDEFormPage formPage, boolean addReexport) {
        super(formPage);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.addReexport = addReexport;
    }

    public MatchSection(PDEFormPage formPage) {
        this(formPage, true);
    }

    public void commitChanges(boolean onSave) {
        if (!this.isDirty()) {
            return;
        }
        this.ignoreModelEvents = true;
        if ((this.currentImport != null || this.multiSelection != null) && this.versionText.getControl().isEnabled()) {
            this.versionText.commit();
            String value = this.versionText.getValue();
            int match = 0;
            if (value != null && value.length() > 0) {
                this.applyVersion(value);
                match = this.getMatch();
            }
            this.applyMatch(match);
        }
        this.setDirty(false);
        this.ignoreModelEvents = false;
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        container.setLayout((Layout)layout);
        if (this.addReexport) {
            this.createOptionalButton(factory, container);
            this.createReexportButton(factory, container);
        }
        this.versionText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(KEY_VERSION), factory));
        this.versionText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    String value = text.getValue();
                    MatchSection.this.ignoreModelEvents = true;
                    if (value != null && value.length() > 0) {
                        PluginVersionIdentifier pvi = new PluginVersionIdentifier(text.getValue());
                        String formatted = pvi.toString();
                        text.setValue(formatted, true);
                        MatchSection.this.applyVersion(formatted);
                    } else {
                        MatchSection.this.applyVersion(null);
                    }
                    MatchSection.this.ignoreModelEvents = false;
                }
                catch (Throwable throwable) {
                    text.setValue(MatchSection.this.currentImport.getVersion(), true);
                    String message = PDEPlugin.getResourceString(MatchSection.KEY_VERSION_FORMAT);
                    MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(MatchSection.KEY_VERSION_TITLE), (String)message);
                }
            }

            public void textDirty(FormEntry text) {
                if (MatchSection.this.blockChanges) {
                    return;
                }
                MatchSection.this.forceDirty();
                MatchSection.this.blockChanges = true;
                MatchSection.this.resetMatchCombo(MatchSection.this.currentImport);
                MatchSection.this.blockChanges = false;
            }
        });
        factory.createLabel(container, PDEPlugin.getResourceString(KEY_RULE));
        this.matchCombo = new CCombo(container, 0x800008);
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_NONE));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_EQUIVALENT));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_COMPATIBLE));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_PERFECT));
        this.matchCombo.add(PDEPlugin.getResourceString(KEY_GREATER));
        this.matchCombo.pack();
        this.matchCombo.setBackground(factory.getBackgroundColor());
        this.matchCombo.setForeground(factory.getForegroundColor());
        this.matchCombo.setLayoutData((Object)new GridData(768));
        this.matchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MatchSection.this.blockChanges) {
                    MatchSection.this.applyMatch(MatchSection.this.matchCombo.getSelectionIndex());
                }
            }
        });
        factory.paintBordersFor(container);
        this.update((IPluginReference)null);
        return container;
    }

    private void createReexportButton(FormWidgetFactory factory, Composite container) {
        this.reexportButton = factory.createButton(container, PDEPlugin.getResourceString(KEY_REEXPORT), 32);
        this.reexportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MatchSection.this.blockChanges) {
                    return;
                }
                if (!(MatchSection.this.currentImport instanceof IPluginImport)) {
                    return;
                }
                if (MatchSection.this.currentImport != null) {
                    try {
                        IPluginImport iimport = (IPluginImport)MatchSection.this.currentImport;
                        MatchSection.this.ignoreModelEvents = true;
                        iimport.setReexported(MatchSection.this.reexportButton.getSelection());
                        MatchSection.this.ignoreModelEvents = false;
                    }
                    catch (CoreException ex) {
                        PDEPlugin.logException(ex);
                    }
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.reexportButton.setLayoutData((Object)gd);
    }

    private void createOptionalButton(FormWidgetFactory factory, Composite container) {
        this.optionalButton = factory.createButton(container, PDEPlugin.getResourceString(KEY_OPTIONAL), 32);
        this.optionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MatchSection.this.blockChanges) {
                    return;
                }
                if (!(MatchSection.this.currentImport instanceof IPluginImport)) {
                    return;
                }
                if (MatchSection.this.currentImport != null) {
                    try {
                        IPluginImport iimport = (IPluginImport)MatchSection.this.currentImport;
                        iimport.setOptional(MatchSection.this.optionalButton.getSelection());
                    }
                    catch (CoreException ex) {
                        PDEPlugin.logException(ex);
                    }
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.optionalButton.setLayoutData((Object)gd);
    }

    private void applyVersion(String version) {
        try {
            if (this.currentImport != null) {
                this.currentImport.setVersion(version);
            } else if (this.multiSelection != null) {
                Iterator iter = this.multiSelection.iterator();
                while (iter.hasNext()) {
                    IPluginReference reference = (IPluginReference)iter.next();
                    reference.setVersion(version);
                }
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private void applyMatch(int match) {
        try {
            if (this.currentImport != null) {
                this.currentImport.setMatch(match);
            } else if (this.multiSelection != null) {
                Iterator iter = this.multiSelection.iterator();
                while (iter.hasNext()) {
                    IPluginReference reference = (IPluginReference)iter.next();
                    reference.setMatch(match);
                }
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private void forceDirty() {
        this.setDirty(true);
        IModel model = (IModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            IEditable editable = (IEditable)model;
            editable.setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    private int getMatch() {
        return this.matchCombo.getSelectionIndex();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        IModel model = (IModel)this.getFormPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(Object input) {
        IModel model = (IModel)input;
        this.setReadOnly(!model.isEditable());
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
    }

    public void modelChanged(IModelChangedEvent e) {
        Object object;
        if (this.ignoreModelEvents) {
            return;
        }
        if (e.getChangeType() == 2) {
            Object obj = e.getChangedObjects()[0];
            if (obj.equals(this.currentImport)) {
                this.update((IPluginReference)null);
            }
        } else if (e.getChangeType() == 3 && (object = e.getChangedObjects()[0]).equals(this.currentImport)) {
            this.update(this.currentImport);
        }
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        IPluginImport input = null;
        if (changeObject instanceof ImportObject) {
            input = ((ImportObject)changeObject).getImport();
        } else if (changeObject instanceof IPluginReference) {
            input = (IPluginReference)changeObject;
        } else if (changeObject instanceof IStructuredSelection) {
            this.update((IStructuredSelection)changeObject);
            return;
        }
        this.update((IPluginReference)input);
    }

    private void resetMatchCombo(IPluginReference iimport) {
        String text = this.versionText.getControl().getText();
        boolean enable = !this.isReadOnly() && text.length() > 0;
        this.matchCombo.setEnabled(enable);
        this.setMatchCombo(iimport);
    }

    private void setMatchCombo(IPluginReference iimport) {
        int match = iimport != null ? iimport.getMatch() : 0;
        this.matchCombo.select(match);
    }

    protected void update(IStructuredSelection selection) {
        this.blockChanges = true;
        this.currentImport = null;
        int size = selection.size();
        if (size == 0) {
            this.versionText.setValue(null, true);
            boolean enableState = false;
            this.versionText.getControl().setEditable(enableState);
            this.matchCombo.setEnabled(enableState);
            this.matchCombo.setText("");
            this.blockChanges = false;
            return;
        }
        if (this.multiSelection != null && !this.multiSelection.equals(selection) && !this.isReadOnly()) {
            this.commitChanges(false);
        }
        this.multiSelection = selection;
        this.versionText.getControl().setEditable(!this.isReadOnly());
        if (size == 1) {
            IPluginReference ref = (IPluginReference)selection.getFirstElement();
            this.versionText.setValue(ref.getVersion());
            this.resetMatchCombo(ref);
        } else {
            this.versionText.setValue("");
            this.matchCombo.setEnabled(true);
            this.setMatchCombo(null);
        }
        this.blockChanges = false;
    }

    protected void update(IPluginReference iimport) {
        this.blockChanges = true;
        if (iimport == null) {
            if (this.addReexport) {
                this.optionalButton.setSelection(false);
                this.optionalButton.setEnabled(false);
                this.reexportButton.setSelection(false);
                this.reexportButton.setEnabled(false);
            }
            this.versionText.setValue(null, true);
            boolean enableState = false;
            this.versionText.getControl().setEditable(enableState);
            this.matchCombo.setEnabled(enableState);
            this.matchCombo.setText("");
            this.currentImport = null;
            this.blockChanges = false;
            return;
        }
        if (this.currentImport != null && !iimport.equals(this.currentImport) && !this.isReadOnly()) {
            this.commitChanges(false);
        }
        this.currentImport = iimport;
        if (this.currentImport instanceof IPluginImport) {
            IPluginImport pimport = (IPluginImport)this.currentImport;
            this.optionalButton.setEnabled(!this.isReadOnly());
            this.optionalButton.setSelection(pimport.isOptional());
            this.reexportButton.setEnabled(!this.isReadOnly());
            this.reexportButton.setSelection(pimport.isReexported());
        }
        this.versionText.getControl().setEditable(!this.isReadOnly());
        this.versionText.setValue(this.currentImport.getVersion());
        this.resetMatchCombo(this.currentImport);
        this.blockChanges = false;
    }
}

