/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.IDocumentNode;
import org.eclipse.pde.internal.core.plugin.ISourceRange;
import org.eclipse.pde.internal.core.plugin.PluginDocumentNode;
import org.eclipse.pde.internal.core.plugin.TicketManager;
import org.eclipse.pde.internal.core.plugin.XMLCore;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestSourceOutlinePageLabelProvider;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestSourcePage;
import org.eclipse.pde.internal.ui.editor.manifest.XMLOutlinePage;
import org.eclipse.pde.internal.ui.editor.manifest.XMLOutlinePageContentProvider;
import org.eclipse.pde.internal.ui.editor.manifest.XMLViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IPDEColorConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.update.ui.forms.internal.IFormPage;

public class ManifestSourcePageNew
extends ManifestSourcePage
implements IPDEColorConstants {
    private Object modelNeedsUpdatingLock;
    private Object dynamicReconcilingLock;
    private boolean dynamicReconciling;
    private SelectionChangedListener selectionChangedListener = new SelectionChangedListener();

    public ManifestSourcePageNew(ManifestEditor editor) {
        super(editor);
        this.dynamicReconcilingLock = new Object();
        this.modelNeedsUpdatingLock = new Object();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    public IContentOutlinePage createContentOutlinePage() {
        XMLOutlinePage outlinePage = new XMLOutlinePage(XMLCore.getDefault());
        outlinePage.setContentProvider((IContentProvider)new XMLOutlinePageContentProvider());
        outlinePage.setLabelProvider((IBaseLabelProvider)new ManifestSourceOutlinePageLabelProvider());
        outlinePage.addSelectionChangedListener(this.selectionChangedListener);
        outlinePage.setPageInput((IDocumentNode)((AbstractPluginModelBase)this.getEditor().getModel()).getDocumentModel());
        return outlinePage;
    }

    public boolean becomesInvisible(IFormPage newPage) {
        this.setDynamicReconciling(false);
        ((ManifestEditor)this.getEditor()).updateModel();
        this.ensureModelFinishedUpdating();
        if (this.containsError()) {
            this.warnErrorsInSource();
            return false;
        }
        this.unregisterGlobalActions();
        return true;
    }

    public void becomesVisible(IFormPage oldPage) {
        ((ManifestEditor)this.getEditor()).updateModel();
        this.setDynamicReconciling(true);
        if (oldPage instanceof PDEFormPage) {
            this.selectObjectRange(((PDEFormPage)oldPage).getSelection());
        }
        this.registerGlobalActions();
    }

    protected void setModelNeedsUpdating(boolean modelNeedsUpdating) {
        Object object = this.modelNeedsUpdatingLock;
        synchronized (object) {
            super.setModelNeedsUpdating(modelNeedsUpdating);
        }
    }

    protected boolean isModelNeedsUpdating() {
        Object object = this.modelNeedsUpdatingLock;
        synchronized (object) {
            return super.isModelNeedsUpdating();
        }
    }

    boolean tryGetModelUpdatingTicket() {
        Object object = this.modelNeedsUpdatingLock;
        synchronized (object) {
            boolean result = this.isModelNeedsUpdating();
            if (result) {
                this.setModelNeedsUpdating(false);
                ((AbstractPluginModelBase)this.getEditor().getModel()).getDocumentModel().getTicketManager().buyTicket();
            }
            return result;
        }
    }

    private void ensureModelFinishedUpdating() {
        TicketManager ticketManager = ((AbstractPluginModelBase)this.getEditor().getModel()).getDocumentModel().getTicketManager();
        if (!ticketManager.isAllTicketsUsed()) {
            ticketManager.buyTicket();
            ((ManifestEditor)this.getEditor()).updateModel();
        }
    }

    protected void initializeDocumentListener() {
        this.setDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                ManifestSourcePageNew.this.setModelNeedsUpdating(true);
            }

            public void documentChanged(DocumentEvent event) {
            }
        });
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        IDocumentNode node;
        ISourceRange sourceRange;
        IStructuredSelection structuredSelection;
        Object first;
        if (this.isActivePart()) {
            return;
        }
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (first = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IDocumentNode && (sourceRange = (node = (IDocumentNode)first).getSourceRange()) != null) {
            this.setHighlightRange(sourceRange, ((PluginDocumentNode)node).getDOMNode().getNodeName(), true);
        }
    }

    public void setHighlightRange(ISourceRange sourceRange, String nodeName, boolean moveCursor) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int offset = sourceRange.getOffset();
        this.setHighlightRange(offset, sourceRange.getLength(), moveCursor);
        sourceViewer.setSelectedRange(offset + 1, nodeName.length());
    }

    protected boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals((Object)this.getEditor());
    }

    private void setDynamicReconciling(boolean enabled) {
        Object object = this.dynamicReconcilingLock;
        synchronized (object) {
            this.dynamicReconciling = enabled;
        }
    }

    boolean isDynamicReconciling() {
        Object object = this.dynamicReconcilingLock;
        synchronized (object) {
            return this.dynamicReconciling;
        }
    }

    public void createPartControl(Composite parent) {
        this.setModelNeedsUpdating(true);
        super.createPartControl(parent);
    }

    public boolean containsError() {
        return this.getEditor().containsError();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.isColorProperty(event.getProperty())) {
            this.colorManager.dispose();
            this.colorManager = new ColorManager();
            this.setSourceViewerConfiguration(new XMLViewerConfiguration(this, this.colorManager));
            if (this.getSourceViewer() != null) {
                this.getSourceViewer().configure(this.getSourceViewerConfiguration());
            }
            try {
                this.doSetInput(this.getEditorInput());
            }
            catch (CoreException coreException) {}
        }
        super.handlePreferenceStoreChanged(event);
    }

    private boolean isColorProperty(String property) {
        return property.equals("editor.color.default") || property.equals("editor.color.instr") || property.equals("editor.color.string") || property.equals("editor.color.tag") || property.equals(IPDEColorConstants.XML_COMMENT);
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ManifestSourcePageNew.this.doSelectionChanged(event);
        }
    }
}

