/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IOpenablePropertySource;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ExtensionPropertySource;
import org.eclipse.pde.internal.ui.editor.manifest.UnknownElementPropertySource;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ManifestPropertySheet
extends PropertySheetPage {
    public static final String GOTO_ACTION_LABEL = "ManifestEditor.ManifestPropertySheet.gotoAction.label";
    public static final String GOTO_ACTION_TOOLTIP = "ManifestEditor.ManifestPropertySheet.gotoAction.tooltip";
    protected Action gotoAction;
    protected PDEMultiPageEditor editor;
    protected IPropertySource source;
    protected ISelection currentSelection;
    protected Object currentInput;
    protected IWorkbenchPart currentPart;
    private TableTree tableTree;
    static /* synthetic */ Class class$0;

    public ManifestPropertySheet(PDEMultiPageEditor editor) {
        this.editor = editor;
        this.makeActions();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.tableTree = (TableTree)super.getControl();
        this.tableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableTreeItem[] items = ManifestPropertySheet.this.tableTree.getSelection();
                IPropertySheetEntry entry = null;
                if (items.length > 0) {
                    entry = (IPropertySheetEntry)items[0].getData();
                }
                ManifestPropertySheet.this.updateActions(entry);
            }
        });
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                ManifestPropertySheet.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)this.tableTree.getTable());
        this.tableTree.getTable().setMenu(menu);
    }

    public void disableActions() {
        this.gotoAction.setEnabled(false);
    }

    protected void doFillLocalMenuBar(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.gotoAction);
    }

    protected void doFillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.gotoAction);
    }

    public void fillContextMenu(IMenuManager manager) {
        if (this.gotoAction.isEnabled()) {
            manager.add((IAction)this.gotoAction);
        }
    }

    public void fillLocalMenuBar(IMenuManager menuManager) {
        this.doFillLocalMenuBar(menuManager);
    }

    public void fillLocalToolBar(IToolBarManager toolBarManager) {
        this.doFillLocalToolBar(toolBarManager);
    }

    public Control getControl() {
        return this.tableTree;
    }

    public IPropertySheetEntry getSelectedEntry() {
        TableTreeItem[] items = this.tableTree.getSelection();
        IPropertySheetEntry entry = null;
        if (items.length > 0) {
            entry = (IPropertySheetEntry)items[0].getData();
        }
        return entry;
    }

    protected void handleOpen() {
        IPropertySheetEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return;
        }
        Object input = null;
        if (this.currentSelection instanceof IStructuredSelection) {
            input = ((IStructuredSelection)this.currentSelection).getFirstElement();
        }
        IPropertySource source = null;
        if (input instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)input;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            source = (IPropertySource)iAdaptable.getAdapter((Class)clazz);
        }
        if (source instanceof IOpenablePropertySource) {
            ((IOpenablePropertySource)source).openInEditor(entry);
        }
    }

    protected boolean isCompatible(IPropertySource s1, IPropertySource s2) {
        if (s1 instanceof UnknownElementPropertySource && !(s2 instanceof UnknownElementPropertySource)) {
            return false;
        }
        if (s2 instanceof UnknownElementPropertySource && !(s1 instanceof UnknownElementPropertySource)) {
            return false;
        }
        if (s1 instanceof ExtensionPropertySource) {
            return false;
        }
        return !(s2 instanceof ExtensionPropertySource);
    }

    protected boolean isEditable() {
        return ((IModel)this.editor.getModel()).isEditable();
    }

    protected void makeActions() {
        this.gotoAction = new Action("goto"){

            public void run() {
                ManifestPropertySheet.this.handleOpen();
            }
        };
        this.gotoAction.setImageDescriptor(PDEPluginImages.DESC_GOTOOBJ);
        this.gotoAction.setHoverImageDescriptor(PDEPluginImages.DESC_GOTOOBJ_HOVER);
        this.gotoAction.setDisabledImageDescriptor(PDEPluginImages.DESC_GOTOOBJ_DISABLED);
        this.gotoAction.setText(PDEPlugin.getResourceString(GOTO_ACTION_LABEL));
        this.gotoAction.setToolTipText(PDEPlugin.getResourceString(GOTO_ACTION_TOOLTIP));
        this.gotoAction.setEnabled(false);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        this.fillLocalToolBar(toolBarManager);
        this.fillLocalMenuBar(menuManager);
        super.makeContributions((IMenuManager)new MenuManager(), (IToolBarManager)new ToolBarManager(), statusLineManager);
    }

    protected void refreshInput() {
        super.selectionChanged(this.currentPart, this.currentSelection);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        super.selectionChanged(part, sel);
        this.currentPart = part;
        this.currentSelection = sel;
        this.currentInput = null;
        if (this.currentSelection instanceof IStructuredSelection) {
            this.currentInput = ((IStructuredSelection)this.currentSelection).getFirstElement();
        }
        IPropertySource oldSource = this.source;
        this.source = null;
        if (this.currentInput instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)this.currentInput;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.source = (IPropertySource)iAdaptable.getAdapter((Class)clazz);
        }
        if (!this.isCompatible(oldSource, this.source)) {
            this.switchBars();
        }
        this.disableActions();
    }

    public void superMakeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
    }

    protected void switchBars() {
    }

    protected void updateActions(IPropertySheetEntry entry) {
        if (this.source instanceof IOpenablePropertySource) {
            this.gotoAction.setEnabled(entry != null && ((IOpenablePropertySource)this.source).isOpenable(entry));
        }
    }
}

