/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.manifest.AlertSection;
import org.eclipse.pde.internal.ui.editor.manifest.ExtensionPointSection;
import org.eclipse.pde.internal.ui.editor.manifest.ExtensionSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.pde.internal.ui.editor.manifest.PluginSpecSection;
import org.eclipse.pde.internal.ui.editor.manifest.RequiresSection;
import org.eclipse.pde.internal.ui.editor.manifest.RuntimeSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public class ManifestForm
extends ScrollableSectionForm {
    private PluginSpecSection pluginSection;
    private ExtensionSection extensionSection;
    private RuntimeSection runtimeSection;
    private AlertSection alertSection;
    private ExtensionPointSection extensionPointSection;
    private RequiresSection requiresSection;
    private ManifestFormPage page;

    public ManifestForm(ManifestFormPage page) {
        this.page = page;
        this.setVerticalFit(true);
    }

    protected void createFormClient(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        parent.setLayout((Layout)layout);
        FormWidgetFactory factory = this.getFactory();
        this.alertSection = new AlertSection(this.page);
        this.alertSection.setCollapsable(true);
        Control control = this.alertSection.createControl(parent, factory);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        control.setLayoutData((Object)gd);
        Composite leftColumn = this.getFactory().createComposite(parent);
        gd = new GridData(1808);
        leftColumn.setLayoutData((Object)gd);
        GridLayout leftLayout = new GridLayout();
        leftLayout.verticalSpacing = 10;
        leftLayout.marginWidth = 0;
        leftColumn.setLayout((Layout)leftLayout);
        Composite rightColumn = this.getFactory().createComposite(parent);
        gd = new GridData(1808);
        rightColumn.setLayoutData((Object)gd);
        GridLayout rightLayout = new GridLayout();
        rightLayout.verticalSpacing = 10;
        rightLayout.marginWidth = 0;
        rightColumn.setLayout((Layout)rightLayout);
        this.pluginSection = new PluginSpecSection(this.page);
        this.pluginSection.setCollapsable(true);
        control = this.pluginSection.createControl(leftColumn, factory);
        gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.extensionSection = new ExtensionSection(this.page);
        this.extensionSection.setCollapsable(true);
        control = this.extensionSection.createControl(leftColumn, factory);
        gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.runtimeSection = new RuntimeSection(this.page);
        this.runtimeSection.setCollapsable(true);
        control = this.runtimeSection.createControl(rightColumn, factory);
        gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.requiresSection = new RequiresSection(this.page);
        this.requiresSection.setCollapsable(true);
        control = this.requiresSection.createControl(rightColumn, factory);
        gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.extensionPointSection = new ExtensionPointSection(this.page);
        this.extensionPointSection.setCollapsable(true);
        control = this.extensionPointSection.createControl(rightColumn, factory);
        gd = new GridData(770);
        gd.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gd);
        this.registerSection(this.alertSection);
        this.registerSection(this.pluginSection);
        this.registerSection(this.runtimeSection);
        this.registerSection(this.requiresSection);
        this.registerSection(this.extensionSection);
        this.registerSection(this.extensionPointSection);
        if (((ManifestEditor)this.page.getEditor()).isFragmentEditor()) {
            WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_fragment_overview");
        } else {
            WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_plugin_overview");
        }
    }

    public void initialize(Object modelObject) {
        IPluginModelBase model = (IPluginModelBase)modelObject;
        IPluginBase plugin = model.getPluginBase();
        String name = plugin.getTranslatedName();
        if (!model.isEditable()) {
            name = PDEPlugin.getFormattedMessage("ManifestEditor.readOnly", name);
        }
        super.initialize((Object)model);
        this.setHeadingText(name);
        ((Composite)this.getControl()).layout(true);
    }

    public void setFocus() {
        if (this.pluginSection != null) {
            this.pluginSection.setFocus();
        }
    }

    public void setHeadingText(String text) {
        super.setHeadingText(text);
        Composite control = (Composite)this.getControl();
        if (control != null) {
            control.layout(true);
            control.redraw();
        }
    }
}

