/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestRuntimePage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class LibrarySection
extends TableSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "ManifestEditor.LibrarySection.title";
    public static final String SECTION_DESC = "ManifestEditor.LibrarySection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.LibrarySection.fdesc";
    public static final String SECTION_NEW = "ManifestEditor.LibrarySection.new";
    public static final String SECTION_UP = "ManifestEditor.LibrarySection.up";
    public static final String SECTION_DOWN = "ManifestEditor.LibrarySection.down";
    public static final String POPUP_NEW_LIBRARY = "ManifestEditor.LibrarySection.newLibrary";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String NEW_LIBRARY_ENTRY = "ManifestEditor.LibrarySection.newLibraryEntry";
    private TableViewer libraryTable;

    public LibrarySection(ManifestRuntimePage page) {
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString(SECTION_NEW);
        stringArray[2] = PDEPlugin.getResourceString(SECTION_UP);
        stringArray[3] = PDEPlugin.getResourceString(SECTION_DOWN);
        super(page, stringArray);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        EditableTablePart tablePart = this.getTablePart();
        IModel model = (IModel)this.getFormPage().getModel();
        tablePart.setEditable(model.isEditable());
        this.createViewerPartControl(container, 65536, 2, factory);
        this.libraryTable = tablePart.getTableViewer();
        this.libraryTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.libraryTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        factory.paintBordersFor(container);
        tablePart.setButtonEnabled(2, false);
        tablePart.setButtonEnabled(3, false);
        return container;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)selection);
        this.updateDirectionalButtons();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    protected void entryModified(Object entry, String newValue) {
        Item item = (Item)entry;
        final IPluginLibrary library = (IPluginLibrary)item.getData();
        try {
            if (newValue.equals(library.getName())) {
                return;
            }
            library.setName(newValue);
            this.setDirty(true);
            this.commitChanges(false);
            this.libraryTable.getTable().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    LibrarySection.this.libraryTable.update((Object)library, null);
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        this.libraryTable.setSelection((ISelection)new StructuredSelection(object), true);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getFormPage().getModel();
        ISelection selection = this.libraryTable.getSelection();
        Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_LIBRARY)){

            public void run() {
                LibrarySection.this.handleNew();
            }
        };
        newAction.setEnabled(model.isEditable());
        manager.add((IAction)newAction);
        if (!selection.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            IAction renameAction = this.getRenameAction();
            renameAction.setEnabled(model.isEditable());
            manager.add(renameAction);
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    LibrarySection.this.handleDelete();
                }
            };
            deleteAction.setEnabled(model.isEditable());
            manager.add((IAction)deleteAction);
        }
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleDelete() {
        Object object = ((IStructuredSelection)this.libraryTable.getSelection()).getFirstElement();
        if (object != null && object instanceof IPluginLibrary) {
            IPluginLibrary ep = (IPluginLibrary)object;
            IPluginBase plugin = ep.getPluginBase();
            try {
                plugin.remove(ep);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleDown() {
        int index = this.libraryTable.getTable().getSelectionIndex();
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        IPluginLibrary[] libraries = plugin.getLibraries();
        IPluginLibrary l1 = libraries[index];
        IPluginLibrary l2 = libraries[index + 1];
        try {
            plugin.swap(l1, l2);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.updateDirectionalButtons();
    }

    private void handleNew() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginLibrary library = model.getPluginFactory().createLibrary();
        try {
            library.setName(PDEPlugin.getResourceString(NEW_LIBRARY_ENTRY));
            model.getPluginBase().add(library);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleUp() {
        int index = this.libraryTable.getTable().getSelectionIndex();
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        IPluginLibrary[] libraries = plugin.getLibraries();
        IPluginLibrary l1 = libraries[index];
        IPluginLibrary l2 = libraries[index - 1];
        try {
            plugin.swap(l1, l2);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.updateDirectionalButtons();
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.libraryTable.setInput((Object)model.getPluginBase());
        this.setReadOnly(!model.isEditable());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        this.getTablePart().setButtonEnabled(2, false);
        this.getTablePart().setButtonEnabled(3, false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.libraryTable.refresh();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginLibrary) {
            if (event.getChangeType() == 1) {
                this.libraryTable.add(changeObject);
                this.libraryTable.editElement(changeObject, 0);
            } else if (event.getChangeType() == 2) {
                this.libraryTable.remove(changeObject);
            } else if (event.getChangedProperty() == null) {
                this.libraryTable.update(changeObject, null);
            }
        } else if (changeObject.equals(this.libraryTable.getInput())) {
            this.libraryTable.refresh();
        }
    }

    public void setFocus() {
        this.libraryTable.getTable().setFocus();
    }

    private void updateDirectionalButtons() {
        Table table = this.libraryTable.getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(2, canMove && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected void doPaste(Object target, Object[] objects) {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        try {
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (obj instanceof IPluginLibrary) {
                    PluginLibrary library = (PluginLibrary)obj;
                    library.setModel((ISharedPluginModel)model);
                    library.setParent((IPluginObject)plugin);
                    plugin.add((IPluginLibrary)library);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return objects[0] instanceof IPluginLibrary;
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginBase) {
                return ((IPluginBase)parent).getLibraries();
            }
            return new Object[0];
        }
    }
}

