/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.codegen.AttributeClassCodeGenerator;
import org.eclipse.pde.internal.ui.parts.FolderSelectionDialog;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JavaAttributeWizardPage
extends WizardPage {
    private static final String DEFAULT = "<default>";
    private static final String ADD_TODO = "JavaAttributeWizard.AddToDo";
    private static final String OPEN_FILE = "JavaAttributeWizard.openFile";
    private static final int MAX_WIDTH = 250;
    private String className;
    private IProject project;
    private ISchemaAttribute attInfo;
    private Button searchButton;
    private Label searchLabel;
    private Text searchText;
    private Button searchBrowse;
    private Button generateButton;
    private Label containerLabel;
    private Text containerText;
    private Button containerBrowse;
    private Label packageLabel;
    private Text packageText;
    private Button packageBrowse;
    private Label classLabel;
    private Text classText;
    private Button openFileButton;
    private Button addToDoButton;
    private ModifyListener modifyListener;
    private IPackageFragmentRoot[] sourceFolders;

    public JavaAttributeWizardPage(IProject project, IPluginModelBase model, ISchemaAttribute attInfo, String className) {
        super("classPage");
        this.project = project;
        this.attInfo = attInfo;
        this.className = className;
        this.setTitle(PDEPlugin.getResourceString("JavaAttributeWizard.title"));
        this.setDescription(PDEPlugin.getResourceString("JavaAttributeWizard.desc"));
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaAttributeWizardPage.this.verifyComplete();
            }
        };
        this.computeSourceFolders();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.setPageComplete(false);
        this.createSearchSection(container);
        this.createGenerateSection(container);
        this.enableGenerateSection(false);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.java_attribute_wizard_page");
    }

    private void enableGenerateSection(boolean enabled) {
        this.containerLabel.setEnabled(enabled);
        this.containerText.setEnabled(enabled);
        this.containerBrowse.setEnabled(enabled);
        this.packageLabel.setEnabled(enabled);
        this.packageText.setEnabled(enabled);
        this.packageBrowse.setEnabled(enabled);
        this.classLabel.setEnabled(enabled);
        this.classText.setEnabled(enabled);
        this.openFileButton.setEnabled(enabled);
        this.addToDoButton.setEnabled(enabled);
    }

    private void enableSearchSection(boolean enabled) {
        this.searchLabel.setEnabled(enabled);
        this.searchText.setEnabled(enabled);
        this.searchBrowse.setEnabled(enabled);
    }

    private void createSearchSection(Composite parent) {
        this.searchButton = new Button(parent, 16);
        this.searchButton.setText(PDEPlugin.getResourceString("JavaAttributeWizard.search"));
        this.searchButton.setSelection(true);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.enableSearchSection(JavaAttributeWizardPage.this.searchButton.getSelection());
                JavaAttributeWizardPage.this.verifyComplete();
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchButton.setLayoutData((Object)gd);
        this.searchLabel = new Label(parent, 0);
        this.searchLabel.setText(PDEPlugin.getResourceString("JavaAttributeWizard.search.className"));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.searchLabel.setLayoutData((Object)gd);
        this.searchText = new Text(parent, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.searchText.setLayoutData((Object)gd);
        this.searchText.setText(this.className);
        this.searchText.addModifyListener(this.modifyListener);
        this.searchBrowse = new Button(parent, 8);
        this.searchBrowse.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.searchBrowse);
        this.searchBrowse.setText(PDEPlugin.getResourceString("JavaAttributeWizard.search.className.browse"));
        this.searchBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.handleFindType(JavaAttributeWizardPage.this.searchText);
            }
        });
    }

    private void createGenerateSection(Composite parent) {
        this.generateButton = new Button(parent, 16);
        this.generateButton.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate"));
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.enableGenerateSection(JavaAttributeWizardPage.this.generateButton.getSelection());
                JavaAttributeWizardPage.this.verifyComplete();
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.generateButton.setLayoutData((Object)gd);
        this.containerLabel = new Label(parent, 0);
        this.containerLabel.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.container"));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.containerLabel.setLayoutData((Object)gd);
        this.containerText = new Text(parent, 2048);
        this.containerText.setText(this.sourceFolders.length > 0 ? String.valueOf(this.sourceFolders[0].getElementName()) + '/' : "");
        gd = new GridData(768);
        gd.widthHint = 250;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(this.modifyListener);
        this.containerBrowse = new Button(parent, 8);
        this.containerBrowse.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.container.browse"));
        this.containerBrowse.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.containerBrowse);
        this.containerBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.handleFindContainer();
            }
        });
        this.packageLabel = new Label(parent, 0);
        this.packageLabel.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.package"));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.packageLabel.setLayoutData((Object)gd);
        this.packageText = new Text(parent, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.packageText.setLayoutData((Object)gd);
        this.packageText.addModifyListener(this.modifyListener);
        this.packageBrowse = new Button(parent, 8);
        this.packageBrowse.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.package.browse"));
        this.packageBrowse.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.packageBrowse);
        this.packageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.handleFindPackage();
            }
        });
        this.classLabel = new Label(parent, 0);
        this.classLabel.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.class"));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.classLabel.setLayoutData((Object)gd);
        this.classText = new Text(parent, 2048);
        gd = new GridData(768);
        gd.widthHint = 250;
        this.classText.setLayoutData((Object)gd);
        this.classText.addModifyListener(this.modifyListener);
        int loc = this.className.lastIndexOf(46);
        if (loc != -1) {
            this.packageText.setText(this.className.substring(0, loc));
            this.classText.setText(this.className.substring(loc + 1));
        }
        this.openFileButton = new Button(parent, 32);
        this.openFileButton.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.openEditor"));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 25;
        this.openFileButton.setLayoutData((Object)gd);
        this.openFileButton.setSelection(this.getDialogSettings().getBoolean(OPEN_FILE));
        this.addToDoButton = new Button(parent, 32);
        this.addToDoButton.setText(PDEPlugin.getResourceString("JavaAttributeWizard.generate.addToDo"));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 25;
        this.addToDoButton.setLayoutData((Object)gd);
        this.addToDoButton.setSelection(this.getDialogSettings().getBoolean(ADD_TODO));
    }

    private void computeSourceFolders() {
        ArrayList<IPackageFragmentRoot> folders = new ArrayList<IPackageFragmentRoot>();
        try {
            if (this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)this.project);
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        folders.add(roots[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        this.sourceFolders = folders.toArray(new IPackageFragmentRoot[folders.size()]);
    }

    private IPackageFragmentRoot getSourceFolder(String folderName) {
        if (folderName != null) {
            int i = 0;
            while (i < this.sourceFolders.length) {
                if (this.sourceFolders[i].getPath().removeFirstSegments(1).equals((Object)new Path(folderName))) {
                    return this.sourceFolders[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected static void addSourceFolder(String name, IProject project, IProgressMonitor monitor) throws CoreException {
        IPath path = project.getFullPath().append(name);
        JavaAttributeWizardPage.ensureFolderExists(project, path, monitor);
        monitor.worked(1);
    }

    private static void ensureFolderExists(IProject project, IPath folderPath, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = project.getWorkspace();
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, null);
            }
            monitor.worked(1);
            ++i;
        }
    }

    public boolean finish() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(ADD_TODO, this.addToDoButton.getSelection());
        settings.put(OPEN_FILE, this.openFileButton.getSelection());
        if (!this.searchButton.getSelection()) {
            this.className = this.packageText.getText().equals(DEFAULT) ? this.classText.getText() : String.valueOf(this.packageText.getText()) + "." + this.classText.getText();
            return this.generateClass();
        }
        this.className = this.searchText.getText();
        return true;
    }

    private boolean generateClass() {
        if (this.isAlreadyCreated(this.className)) {
            Display.getCurrent().beep();
            boolean ok = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("JavaAttributeWizard.duplication.title"), (String)PDEPlugin.getFormattedMessage("JavaAttributeWizard.duplication.message", this.className));
            if (!ok) {
                return false;
            }
        }
        final String folderName = this.containerText.getText();
        final boolean openFile = this.openFileButton.getSelection();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    JavaAttributeWizardPage.this.generateClass(folderName, openFile, pm);
                }
                catch (JavaModelException e) {
                    MessageDialog.openError((Shell)JavaAttributeWizardPage.this.searchText.getShell(), (String)PDEPlugin.getResourceString("JavaAttributeWizard.nested.title"), (String)PDEPlugin.getFormattedMessage("JavaAttributeWizard.nested.desc", folderName));
                    throw new InvocationTargetException(e);
                }
                catch (Exception e) {
                    PDEPlugin.logException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    private void generateClass(String folderName, boolean openFile, IProgressMonitor monitor) throws Exception {
        IPackageFragmentRoot sourceFolder;
        monitor.beginTask(PDEPlugin.getFormattedMessage("JavaAttributeWizard.generating", this.className), 11);
        if (folderName.charAt(0) == '/') {
            folderName = folderName.substring(1, folderName.length());
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IPath path = this.project.getFullPath().append(folderName);
        IFolder folder = this.project.getWorkspace().getRoot().getFolder(path);
        AttributeClassCodeGenerator generator = new AttributeClassCodeGenerator(javaProject, folder, this.className, this.attInfo, this.addToDoButton.getSelection());
        path = this.project.getFullPath().append(folderName);
        if (!path.toFile().exists() && (sourceFolder = this.getSourceFolder(folderName)) == null) {
            IClasspathEntry newSrcEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
            monitor.worked(1);
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            monitor.worked(1);
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = newSrcEntry;
            monitor.worked(1);
            javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(2);
        }
        JavaAttributeWizardPage.addSourceFolder(folderName, this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.worked(1);
        IFile file = generator.generate((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        monitor.worked(8);
        if (file != null) {
            if (openFile) {
                IWorkbenchPage page = PDEPlugin.getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            monitor.worked(2);
        }
        monitor.done();
    }

    public String getClassName() {
        return this.className;
    }

    private void handleFindContainer() {
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getContainer().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ContentProvider(){});
        dialog.setInput(this.project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)JavaAttributeWizardPage.this.project);
                }
                return element instanceof IFolder;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString("JavaAttributeWizard.containerSelection"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFolder) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            IFolder folder = (IFolder)dialog.getFirstResult();
            this.containerText.setText(folder.getProjectRelativePath().addTrailingSeparator().toString());
            this.containerBrowse.setFocus();
        }
    }

    private void handleFindPackage() {
        try {
            IPackageFragmentRoot sourceFolder = this.getSourceFolder(this.containerText.getText());
            SelectionDialog dialog = sourceFolder != null ? JavaUI.createPackageDialog((Shell)this.getContainer().getShell(), (IPackageFragmentRoot)sourceFolder) : JavaUI.createPackageDialog((Shell)this.getContainer().getShell(), (IJavaProject)JavaCore.create((IProject)this.project), (int)0, (String)"");
            dialog.setTitle(PDEPlugin.getResourceString("JavaAttributeWizard.packageSelection"));
            dialog.setMessage("");
            int status = dialog.open();
            if (status == 0) {
                Object[] result = dialog.getResult();
                if (result[0].toString().startsWith(DEFAULT)) {
                    this.packageText.setText(DEFAULT);
                } else {
                    IPackageFragment packageFragment = (IPackageFragment)result[0];
                    sourceFolder = (IPackageFragmentRoot)packageFragment.getParent();
                    if (sourceFolder != null) {
                        this.containerText.setText(sourceFolder.getPath().removeFirstSegments(1).addTrailingSeparator().toString());
                    } else {
                        this.containerText.setText("");
                    }
                    this.packageText.setText(packageFragment.getElementName());
                }
                this.packageBrowse.setFocus();
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleFindType(Text target) {
        boolean initSearchSelect = this.searchButton.getSelection();
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getContainer().getShell(), (IRunnableContext)this.getContainer(), (IProject)this.project, (int)6, (boolean)false);
            dialog.setTitle(PDEPlugin.getResourceString("JavaAttributeWizard.findType"));
            dialog.setMessage(PDEPlugin.getResourceString("JavaAttributeWizard.filter"));
            int status = dialog.open();
            this.searchButton.setSelection(initSearchSelect);
            this.generateButton.setSelection(!initSearchSelect);
            if (status == 0) {
                Object[] result = dialog.getResult();
                IType type = (IType)result[0];
                target.setText(type.getFullyQualifiedName());
                target.setFocus();
                target.selectAll();
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean isAlreadyCreated(String fullName) {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        Path path = new Path(String.valueOf(fullName.replace('.', '/')) + ".java");
        try {
            return javaProject.findElement((IPath)path) != null;
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
            return false;
        }
    }

    private void verifyComplete() {
        IStatus status = null;
        if (this.searchButton.getSelection()) {
            status = JavaConventions.validateJavaTypeName((String)this.searchText.getText());
            this.setPageComplete(status.getSeverity() != 4);
        } else {
            if (!this.packageText.getText().equals(DEFAULT)) {
                status = JavaConventions.validatePackageName((String)this.packageText.getText());
            }
            IStatus second = JavaConventions.validateJavaTypeName((String)this.classText.getText());
            if (status == null || second.getSeverity() > status.getSeverity()) {
                status = second;
            }
            this.setPageComplete(status.getSeverity() != 4 && this.containerText.getText().length() > 0);
        }
        String errorMessage = null;
        if (status.getSeverity() == 4) {
            errorMessage = status.getMessage();
        }
        if (errorMessage == null && !this.searchButton.getSelection() && this.containerText.getText().length() == 0) {
            errorMessage = PDEPlugin.getResourceString("JavaAttributeWizard.error.container");
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
        }
        if (status.getSeverity() != 0) {
            this.setMessage(status.getMessage());
        } else {
            this.setMessage(null);
        }
    }

    class ContentProvider
    extends WorkbenchContentProvider {
        ContentProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFolder) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

