/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.manifest.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.manifest.JavaAttributeWizardPage;

public class JavaAttributeWizard
extends Wizard {
    private String className;
    private JavaAttributeWizardPage mainPage;
    private IProject project;
    private ISchemaAttribute attInfo;
    private IPluginModelBase model;
    private static String STORE_SECTION = "JavaAttributeWizard";

    public JavaAttributeWizard(IProject project, IPluginModelBase model, ISchemaAttribute attInfo, String className) {
        this.className = className;
        this.model = model;
        this.project = project;
        this.attInfo = attInfo;
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setWindowTitle(PDEPlugin.getResourceString("JavaAttributeWizard.wtitle"));
        this.setNeedsProgressMonitor(true);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public void addPages() {
        this.mainPage = new JavaAttributeWizardPage(this.project, this.model, this.attInfo, this.className);
        this.addPage((IWizardPage)this.mainPage);
    }

    public Object getValue() {
        return new JavaAttributeValue(this.project, this.model, this.attInfo, this.className);
    }

    public boolean performFinish() {
        boolean result = this.mainPage.finish();
        if (result) {
            this.className = this.mainPage.getClassName();
        }
        return result;
    }
}

