/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.DependenciesForm;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestDependenciesPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.NewDependencyWizard;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.ui.ClasspathUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class ImportListSection
extends TableSection
implements IModelChangedListener,
IModelProviderListener {
    private TableViewer importTable;
    public static final String SECTION_TITLE = "ManifestEditor.ImportListSection.title";
    public static final String SECTION_DESC = "ManifestEditor.ImportListSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.ImportListSection.fdesc";
    public static final String SECTION_NEW = "ManifestEditor.ImportListSection.new";
    public static final String POPUP_OPEN = "Actions.open.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String KEY_UPDATING_BUILD_PATH = "ManifestEditor.ImportListSection.updatingBuildPath";
    public static final String KEY_COMPUTE_BUILD_PATH = "ManifestEditor.ImportListSection.updateBuildPath";
    private Vector imports;
    private Action openAction;
    private Action newAction;
    private Action deleteAction;
    private Action buildpathAction;

    public ImportListSection(ManifestDependenciesPage page) {
        super(page, new String[]{PDEPlugin.getResourceString(SECTION_NEW)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)this.getFormPage().getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
        this.getTablePart().setEditable(false);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        this.createViewerPartControl(container, 2, 2, factory);
        EditableTablePart tablePart = this.getTablePart();
        this.importTable = tablePart.getTableViewer();
        this.importTable.setContentProvider((IContentProvider)new ImportContentProvider());
        this.importTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        factory.paintBordersFor(container);
        this.makeActions();
        return container;
    }

    protected void selectionChanged(IStructuredSelection sel) {
        Object item = sel.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)sel);
    }

    protected void handleDoubleClick(IStructuredSelection sel) {
        this.handleOpen((ISelection)sel);
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getWorkspaceModelManager().removeModelProviderListener((IModelProviderListener)this);
        PDECore.getDefault().getExternalModelManager().removeModelProviderListener((IModelProviderListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        if (object instanceof IPluginImport) {
            ImportObject iobj = new ImportObject((IPluginImport)object);
            this.importTable.setSelection((ISelection)new StructuredSelection((Object)iobj), true);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.importTable.getSelection();
        manager.add((IAction)this.newAction);
        if (!selection.isEmpty()) {
            manager.add((IAction)this.openAction);
        }
        manager.add((IContributionItem)new Separator());
        ((DependenciesForm)this.getFormPage().getForm()).fillContextMenu(manager);
        if (!selection.isEmpty()) {
            manager.add((IAction)this.deleteAction);
        }
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setContext(new ActionContext(selection));
        actionGroup.fillContextMenu(manager);
        if (this.getFormPage().getModel() instanceof WorkspacePluginModelBase) {
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)((WorkspacePluginModelBase)this.getFormPage().getModel())));
        }
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.importTable.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase pluginBase = model.getPluginBase();
        try {
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                ImportObject iobj = (ImportObject)iter.next();
                pluginBase.remove(iobj.getImport());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleNew() {
        final IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        BusyIndicator.showWhile((Display)this.importTable.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewDependencyWizard wizard = new NewDependencyWizard(model);
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                dialog.open();
            }
        });
    }

    private void handleOpen(ISelection sel) {
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1) {
            this.handleOpen(ssel.getFirstElement());
        }
    }

    private void handleOpen(Object obj) {
        IPlugin plugin;
        if (obj instanceof ImportObject && (plugin = ((ImportObject)obj).getPlugin()) != null) {
            ManifestEditor.openPluginEditor((IPluginBase)plugin);
        }
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.importTable.setInput((Object)model.getPluginBase());
        this.setReadOnly(!model.isEditable());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getWorkspaceModelManager().addModelProviderListener((IModelProviderListener)this);
        PDECore.getDefault().getExternalModelManager().addModelProviderListener((IModelProviderListener)this);
        this.newAction.setEnabled(model.isEditable());
        this.deleteAction.setEnabled(model.isEditable());
        this.buildpathAction.setEnabled(model.isEditable());
    }

    private void makeActions() {
        this.newAction = new Action(){

            public void run() {
                ImportListSection.this.handleNew();
            }
        };
        this.newAction.setText(PDEPlugin.getResourceString(SECTION_NEW));
        this.openAction = new Action(){

            public void run() {
                ImportListSection.this.handleOpen(ImportListSection.this.importTable.getSelection());
            }
        };
        this.openAction.setText(PDEPlugin.getResourceString(POPUP_OPEN));
        this.deleteAction = new Action(){

            public void run() {
                ImportListSection.this.handleDelete();
            }
        };
        this.deleteAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
        this.buildpathAction = new Action(){

            public void run() {
                Object model = ImportListSection.this.getFormPage().getModel();
                if (model instanceof IPluginModel) {
                    ImportListSection.this.computeBuildPath((IPluginModelBase)((IPluginModel)model), true);
                }
            }
        };
        this.buildpathAction.setText(PDEPlugin.getResourceString(KEY_COMPUTE_BUILD_PATH));
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.imports = null;
            this.importTable.refresh();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginImport) {
            IPluginImport iimport = (IPluginImport)changeObject;
            if (event.getChangeType() == 1) {
                ImportObject iobj = new ImportObject(iimport);
                this.imports.add(iobj);
                this.importTable.add((Object)iobj);
                this.importTable.setSelection((ISelection)new StructuredSelection((Object)iobj), true);
                this.importTable.getTable().setFocus();
            } else {
                ImportObject iobj = this.findImportObject(iimport);
                if (iobj != null) {
                    if (event.getChangeType() == 2) {
                        this.imports.remove(iobj);
                        this.importTable.remove((Object)iobj);
                    } else {
                        this.importTable.update((Object)iobj, null);
                    }
                }
            }
            this.setDirty(true);
        }
    }

    public void modelsChanged(IModelProviderEvent e) {
        this.imports = null;
        this.importTable.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!ImportListSection.this.importTable.getControl().isDisposed()) {
                    ImportListSection.this.importTable.refresh();
                }
            }
        });
    }

    private ImportObject findImportObject(IPluginImport iimport) {
        if (this.imports == null) {
            return null;
        }
        int i = 0;
        while (i < this.imports.size()) {
            ImportObject iobj = (ImportObject)this.imports.get(i);
            if (iobj.getImport().equals(iimport)) {
                return iobj;
            }
            ++i;
        }
        return null;
    }

    public void commitChanges(boolean onSave) {
        IProject project;
        IResource resource;
        if (onSave && (resource = ((IPluginModelBase)this.getFormPage().getModel()).getUnderlyingResource()) != null && WorkspaceModelManager.isJavaPluginProject((IProject)(project = resource.getProject()))) {
            PDESourcePage sourcePage = (PDESourcePage)this.getFormPage().getEditor().getPage("SourcePage");
            if (PDEPlugin.isManifestUpdate() && !sourcePage.containsError()) {
                this.updateBuildPath();
            }
        }
        this.setDirty(false);
    }

    private void updateBuildPath() {
        this.computeBuildPath((IPluginModelBase)this.getFormPage().getModel(), false);
    }

    Action getBuildpathAction() {
        return this.buildpathAction;
    }

    private void computeBuildPath(final IPluginModelBase model, final boolean save) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(PDEPlugin.getResourceString(ImportListSection.KEY_UPDATING_BUILD_PATH), 1);
                try {
                    try {
                        if (save && ImportListSection.this.getFormPage().getEditor().isDirty()) {
                            ImportListSection.this.getFormPage().getEditor().doSave(monitor);
                        }
                        boolean useContainers = PDEPlugin.getUseClasspathContainers();
                        ClasspathUtil.setClasspath((IPluginModelBase)model, (boolean)useContainers, (IProgressMonitor)monitor);
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog pm = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
        try {
            pm.run(false, false, op);
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e.getTargetException());
        }
    }

    public void setFocus() {
        if (this.importTable != null) {
            this.importTable.getTable().setFocus();
        }
    }

    protected void doPaste(Object target, Object[] objects) {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        try {
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (obj instanceof ImportObject) {
                    ImportObject iobj = (ImportObject)obj;
                    PluginImport iimport = (PluginImport)iobj.getImport();
                    iimport.setModel((ISharedPluginModel)model);
                    iimport.setParent((IPluginObject)plugin);
                    plugin.add((IPluginImport)iimport);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof ImportObject)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    protected void doPaste() {
        ModelDataTransfer modelTransfer;
        Clipboard clipboard = this.getFormPage().getEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)(modelTransfer = ModelDataTransfer.getInstance()));
        if (objects != null) {
            this.doPaste(null, objects);
        }
    }

    class ImportContentProvider
    extends DefaultTableProvider {
        ImportContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (ImportListSection.this.imports == null) {
                this.createImportObjects();
            }
            return ImportListSection.this.imports.toArray();
        }

        private void createImportObjects() {
            ImportListSection.this.imports = new Vector();
            IPluginModelBase model = (IPluginModelBase)ImportListSection.this.getFormPage().getModel();
            IPluginImport[] iimports = model.getPluginBase().getImports();
            int i = 0;
            while (i < iimports.length) {
                IPluginImport iimport = iimports[i];
                ImportListSection.this.imports.add(new ImportObject(iimport));
                ++i;
            }
        }
    }
}

