/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IOpenablePropertySource;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestPropertySource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExtensionPointPropertySource
extends ManifestPropertySource
implements IOpenablePropertySource {
    private PropertyDescriptor[] descriptors;
    private static final String P_SCHEMA = "schema";
    private static final String P_ID = "id";
    private static final String P_NAME = "name";

    public ExtensionPointPropertySource(IPluginExtensionPoint point) {
        super((IPluginObject)point);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPluginExtensionPoint getPoint() {
        return (IPluginExtensionPoint)this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new PropertyDescriptor[3];
            this.descriptors[0] = this.createTextPropertyDescriptor(P_ID, P_ID);
            this.descriptors[0].setLabelProvider((ILabelProvider)new PropertyLabelProvider(P_ID, PDEPluginImages.get(PDEPluginImages.IMG_ATT_REQ_OBJ)));
            this.descriptors[1] = this.createTextPropertyDescriptor(P_NAME, P_NAME);
            this.descriptors[2] = this.createTextPropertyDescriptor(P_SCHEMA, P_SCHEMA);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_ID)) {
            return this.getNonzeroValue(this.getPoint().getId());
        }
        if (name.equals(P_NAME)) {
            return this.getNonzeroValue(this.getPoint().getName());
        }
        if (name.equals(P_SCHEMA)) {
            return this.getNonzeroValue(this.getPoint().getSchema());
        }
        return "";
    }

    public boolean isOpenable(IPropertySheetEntry entry) {
        String value = entry.getValueAsString();
        return value != null && value.length() > 0 && entry.getDisplayName().equals(P_SCHEMA);
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void openInEditor(IPropertySheetEntry entry) {
        String value = entry.getValueAsString();
        if (value == null || value.length() == 0) {
            return;
        }
        IPluginModelBase model = this.getPoint().getPluginModel();
        IResource pluginFile = model.getUnderlyingResource();
        if (pluginFile != null) {
            IProject project = pluginFile.getProject();
            IPath fullPath = project.getFullPath();
            fullPath = fullPath.append(value);
            IWorkspace workspace = project.getWorkspace();
            IFile file = workspace.getRoot().getFile(fullPath);
            if (!file.exists()) {
                return;
            }
            IWorkbenchPage page = PDEPlugin.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                return;
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPoint(IPluginExtensionPoint newPoint) {
        this.object = newPoint;
    }

    public void setPropertyValue(Object name, Object value) {
        String svalue = value.toString();
        String realValue = svalue == null | svalue.length() == 0 ? null : svalue;
        IPluginExtensionPoint exp = (IPluginExtensionPoint)this.object;
        try {
            if (name.equals(P_ID)) {
                exp.setId(realValue);
            } else if (name.equals(P_NAME)) {
                exp.setName(realValue);
            } else if (name.equals(P_SCHEMA)) {
                exp.setSchema(realValue);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    class PropertyLabelProvider
    extends LabelProvider {
        private Image image;
        private String name;

        public PropertyLabelProvider(String name, Image image) {
            this.image = image;
            this.name = name;
        }

        public String getText(Object obj) {
            Object value = ExtensionPointPropertySource.this.getPropertyValue(this.name);
            return value != null ? value.toString() : "";
        }

        public Image getImage(Object obj) {
            return this.image;
        }
    }
}

