/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IOpenablePropertySource;
import org.eclipse.pde.internal.ui.editor.ModifiedTextPropertyDescriptor;
import org.eclipse.pde.internal.ui.editor.manifest.JavaAttributeDescriptor;
import org.eclipse.pde.internal.ui.editor.manifest.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestPropertySource;
import org.eclipse.pde.internal.ui.editor.manifest.ResourceAttributeDescriptor;
import org.eclipse.pde.internal.ui.editor.manifest.ResourceAttributeValue;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExtensionElementPropertySource
extends ManifestPropertySource
implements IOpenablePropertySource {
    public static final String KEY_FINISH = "ManifestEditor.ExtensionElementPR.finish";
    private Vector descriptors;
    private String TAG_NAME = PDEPlugin.getResourceString("ManifestEditor.PropertyPage.tagName");

    public ExtensionElementPropertySource(IPluginElement element) {
        super((IPluginObject)element);
    }

    public boolean canGenerate(IPropertySheetEntry entry) {
        if (!this.isEditable()) {
            return false;
        }
        String name = entry.getDisplayName();
        IPluginAttribute att = this.getElement().getAttribute(name);
        if (att == null) {
            return false;
        }
        ISchemaAttribute info = ((PluginAttribute)att).getAttributeInfo();
        if (info == null) {
            return false;
        }
        String baseType = info.getBasedOn();
        if (info.getKind() != 1 || baseType == null || baseType.length() == 0) {
            return false;
        }
        String value = entry.getValueAsString();
        return value != null && value.length() != 0;
    }

    private String createDescription(ISchemaAttribute att) {
        String fullText = att.getDescription();
        StringBuffer buff = new StringBuffer();
        boolean tag = false;
        int i = 0;
        while (i < fullText.length()) {
            char c = fullText.charAt(i);
            if (c == '<') {
                tag = true;
            } else if (c == '>') {
                tag = false;
            } else if (!tag) {
                if (c == '\r' || c == '\n') {
                    buff.append(' ');
                } else {
                    if (c == '.') break;
                    buff.append(c);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    protected PropertyDescriptor createPropertyDescriptor(ISchemaAttribute att) {
        String description = this.createDescription(att);
        if (!this.isEditable()) {
            PropertyDescriptor desc = new PropertyDescriptor((Object)att.getName(), att.getName());
            desc.setDescription(description);
            return desc;
        }
        ISchemaSimpleType type = att.getType();
        ModifiedTextPropertyDescriptor desc = null;
        if (type.getName().equals("boolean")) {
            desc = new ComboBoxPropertyDescriptor((Object)att.getName(), att.getName(), new String[]{"false", "true"});
        } else {
            ISchemaRestriction restriction = type.getRestriction();
            if (restriction instanceof ChoiceRestriction) {
                String[] choices = ((ChoiceRestriction)restriction).getChoicesAsStrings();
                desc = new ComboBoxPropertyDescriptor((Object)att.getName(), att.getName(), choices);
            }
        }
        if (desc == null) {
            desc = new ModifiedTextPropertyDescriptor(att.getName(), att.getName());
        }
        if (desc instanceof ComboBoxPropertyDescriptor) {
            desc.setLabelProvider((ILabelProvider)new PropertyLabelProvider(att.getName(), null));
        }
        desc.setDescription(description);
        return desc;
    }

    public void createPropertyDescriptors() {
        this.descriptors = new Vector();
        Image reqImage = PDEPluginImages.get(PDEPluginImages.IMG_ATT_REQ_OBJ);
        Image classImage = PDEPluginImages.get(PDEPluginImages.IMG_ATT_CLASS_OBJ);
        Image resourceImage = PDEPluginImages.get(PDEPluginImages.IMG_ATT_FILE_OBJ);
        Image elementImage = PDEPluginImages.get(PDEPluginImages.IMG_GENERIC_XML_OBJ);
        ISchemaElement info = ((PluginElement)this.getElement()).getElementInfo();
        ISchemaAttribute[] attributes = info.getAttributes();
        PropertyDescriptor nameDesc = new PropertyDescriptor((Object)this.TAG_NAME, this.TAG_NAME);
        nameDesc.setLabelProvider((ILabelProvider)new PropertyLabelProvider(this.TAG_NAME, elementImage));
        this.descriptors.addElement(nameDesc);
        int i = 0;
        while (i < attributes.length) {
            PropertyDescriptor desc;
            ISchemaAttribute att = attributes[i];
            if (att.getKind() == 1) {
                desc = new JavaAttributeDescriptor(att.getName(), att.getName(), !this.isEditable());
                desc.setLabelProvider((ILabelProvider)new PropertyLabelProvider(att.getName(), classImage));
            } else if (att.getKind() == 2) {
                desc = new ResourceAttributeDescriptor(att.getName(), att.getName(), !this.isEditable());
                desc.setLabelProvider((ILabelProvider)new PropertyLabelProvider(att.getName(), resourceImage));
            } else {
                desc = this.createPropertyDescriptor(att);
                if (att.getUse() == 1) {
                    desc.setLabelProvider((ILabelProvider)new PropertyLabelProvider(att.getName(), reqImage));
                }
            }
            this.descriptors.addElement(desc);
            ++i;
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPluginElement getElement() {
        return (IPluginElement)this.object;
    }

    private Object getIndexUsingType(ISchemaSimpleType type, Object value) {
        String svalue;
        String string = svalue = value != null ? value.toString().toLowerCase() : "";
        if (type.getName().equals("boolean")) {
            if (svalue.equals("true")) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        ISchemaRestriction restriction = type.getRestriction();
        if (restriction instanceof ChoiceRestriction) {
            String[] choices = ((ChoiceRestriction)restriction).getChoicesAsStrings();
            int i = 0;
            while (i < choices.length) {
                if (choices[i].equals(svalue)) {
                    return new Integer(i);
                }
                ++i;
            }
            return new Integer(0);
        }
        return value != null ? value : "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ISchema schema;
        ISchemaElement element = ((PluginElement)this.getElement()).getElementInfo();
        if (element != null && (schema = element.getSchema()).isEditable()) {
            this.descriptors = null;
        }
        if (this.descriptors == null) {
            this.createPropertyDescriptors();
        }
        return this.toDescriptorArray(this.descriptors);
    }

    public Object getPropertyValue(Object name) {
        IProject project;
        if (name.equals(this.TAG_NAME)) {
            return this.getElement().getName();
        }
        IPluginAttribute att = this.getElement().getAttribute(name.toString());
        ISchemaElement elementInfo = ((PluginElement)this.getElement()).getElementInfo();
        ISchemaAttribute attInfo = elementInfo != null ? elementInfo.getAttribute(name.toString()) : null;
        IResource resource = this.getElement().getModel().getUnderlyingResource();
        IProject iProject = project = resource != null ? resource.getProject() : null;
        if (att == null) {
            if (this.isEditable() && attInfo != null) {
                if (attInfo.getKind() == 1) {
                    IPluginModelBase model = this.getElement().getPluginModel();
                    return new JavaAttributeValue(project, model, attInfo, "");
                }
                if (attInfo.getKind() == 2) {
                    return new ResourceAttributeValue(project, "");
                }
                ISchemaSimpleType type = attInfo.getType();
                return this.getIndexUsingType(type, attInfo.getValue());
            }
        } else {
            String value = att.getValue();
            if (attInfo != null) {
                if (attInfo.getKind() == 1) {
                    IPluginModelBase model = att.getPluginModel();
                    return new JavaAttributeValue(project, model, attInfo, value.toString());
                }
                if (attInfo.getKind() == 2) {
                    return new ResourceAttributeValue(project, value.toString());
                }
                if (this.isEditable()) {
                    ISchemaSimpleType type = attInfo.getType();
                    return this.getIndexUsingType(type, value);
                }
            }
            return value;
        }
        return "";
    }

    private Object getStringUsingType(ISchemaSimpleType type, Object value) {
        if (value instanceof Integer) {
            int index = (Integer)value;
            if (type.getName().equals("boolean")) {
                return index == 1 ? "true" : "false";
            }
            ISchemaRestriction restriction = type.getRestriction();
            if (restriction instanceof ChoiceRestriction) {
                String[] choices = ((ChoiceRestriction)restriction).getChoicesAsStrings();
                if (index >= 0 && index < choices.length) {
                    return choices[index];
                }
            }
        }
        return "";
    }

    public boolean isAlreadyCreated(String fullName) {
        int nameloc = fullName.lastIndexOf(46);
        String packageName = fullName.substring(0, nameloc);
        String className = fullName.substring(nameloc + 1);
        String javaFileName = String.valueOf(className) + ".java";
        IProject project = this.getProject();
        IWorkspace workspace = project.getWorkspace();
        IPath path = project.getFullPath().append(packageName.replace('.', '/'));
        IPath filePath = path.append(javaFileName);
        return workspace.getRoot().exists(filePath);
    }

    public boolean isOpenable(IPropertySheetEntry entry) {
        if (!this.isEditable()) {
            return false;
        }
        String name = entry.getDisplayName();
        IPluginAttribute att = this.getElement().getAttribute(name);
        if (att == null) {
            return false;
        }
        ISchemaAttribute info = ((PluginAttribute)att).getAttributeInfo();
        if (info == null) {
            return false;
        }
        if (info.getKind() != 1 && info.getKind() != 2) {
            return false;
        }
        String value = entry.getValueAsString();
        return value != null && value.length() != 0;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void openInEditor(IPropertySheetEntry entry) {
        String name = entry.getDisplayName();
        IPluginAttribute att = this.getElement().getAttribute(name);
        if (att == null) {
            return;
        }
        ISchemaAttribute info = ((PluginAttribute)att).getAttributeInfo();
        if (info == null) {
            return;
        }
        String value = entry.getValueAsString();
        if (value == null || value.length() == 0) {
            return;
        }
        if (info.getKind() == 1) {
            this.openJavaFile(value);
        } else if (info.getKind() == 2) {
            this.openResourceFile(value);
        }
    }

    private void openJavaFile(String name) {
        IJavaProject jproject = this.getJavaProject();
        String path = String.valueOf(name.replace('.', '/')) + ".java";
        try {
            IJavaElement result = jproject.findElement((IPath)new Path(path));
            if (result != null) {
                JavaUI.openInEditor((IJavaElement)result);
            }
        }
        catch (PartInitException partInitException) {
            Display.getCurrent().beep();
        }
        catch (JavaModelException javaModelException) {
            Display.getCurrent().beep();
        }
    }

    private void openResourceFile(String name) {
        IPath path = this.getProject().getFullPath().append(name);
        IFile file = this.getProject().getWorkspace().getRoot().getFile(path);
        if (file.exists()) {
            try {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        } else {
            Display.getCurrent().beep();
        }
    }

    public void resetPropertyValue(Object property) {
    }

    public void setElement(IPluginElement newElement) {
        this.object = newElement;
    }

    public void setPropertyValue(Object name, Object value) {
        ISchemaAttribute attInfo;
        PluginElement ee = (PluginElement)this.object;
        ISchemaElement elementInfo = ee.getElementInfo();
        if (value instanceof Integer && elementInfo != null && (attInfo = elementInfo.getAttribute(name.toString())) != null) {
            value = this.getStringUsingType(attInfo.getType(), value);
        }
        String valueString = value.toString();
        try {
            ee.setAttribute(name.toString(), valueString == null | valueString.length() == 0 ? null : valueString);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    class PropertyLabelProvider
    extends LabelProvider {
        private Image image;
        private String name;

        public PropertyLabelProvider(String name, Image image) {
            this.image = image;
            this.name = name;
        }

        public String getText(Object obj) {
            if (this.name.equals(ExtensionElementPropertySource.this.TAG_NAME)) {
                return ExtensionElementPropertySource.this.getElement().getName();
            }
            IPluginAttribute att = ExtensionElementPropertySource.this.getElement().getAttribute(this.name);
            String value = att != null ? att.getValue() : null;
            return value != null ? value.toString() : "";
        }

        public Image getImage(Object obj) {
            return this.image;
        }
    }
}

