/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestRuntimePage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class ExportSection
extends TableSection {
    private Button noExportButton;
    private Button fullExportButton;
    private Button selectedExportButton;
    private IPluginLibrary currentLibrary;
    private Composite nameFilterContainer;
    private TableViewer nameTableViewer;
    public static final String SECTION_TITLE = "ManifestEditor.ExportSection.title";
    public static final String SECTION_DESC = "ManifestEditor.ExportSection.desc";
    public static final String KEY_NO_EXPORT = "ManifestEditor.ExportSection.noExport";
    public static final String KEY_NEW_FILTER = "ManifestEditor.ExportSection.newFilter";
    public static final String KEY_FULL_EXPORT = "ManifestEditor.ExportSection.fullExport";
    public static final String KEY_SELECTED_EXPORT = "ManifestEditor.ExportSection.selectedExport";
    public static final String KEY_ADD = "ManifestEditor.ExportSection.add";
    public static final String KEY_REMOVE = "ManifestEditor.ExportSection.remove";
    private Vector filters;
    private boolean ignoreModelEvents;

    public ExportSection(ManifestRuntimePage formPage) {
        super(formPage, new String[]{PDEPlugin.getResourceString(KEY_ADD), PDEPlugin.getResourceString(KEY_REMOVE)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.handleDefaultButton = false;
    }

    private void buttonChanged(Button selectedButton) {
        this.ignoreModelEvents = true;
        this.nameFilterContainer.setVisible(selectedButton == this.selectedExportButton && selectedButton.getSelection());
        try {
            this.currentLibrary.setExported(selectedButton == this.selectedExportButton || selectedButton == this.fullExportButton);
            if (!this.selectedExportButton.getSelection() && this.currentLibrary.getContentFilters() != null) {
                this.currentLibrary.setContentFilters(null);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.ignoreModelEvents = false;
    }

    public void commitChanges(boolean onSave) {
        if (!this.isDirty()) {
            return;
        }
        this.ignoreModelEvents = true;
        if (this.filters != null && this.currentLibrary != null) {
            try {
                if (this.filters.size() == 0) {
                    this.currentLibrary.setContentFilters(null);
                } else {
                    String[] result = new String[this.filters.size()];
                    int i = 0;
                    while (i < this.filters.size()) {
                        result[i] = this.filters.elementAt(i).toString();
                        ++i;
                    }
                    this.currentLibrary.setContentFilters(result);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        this.setDirty(false);
        this.ignoreModelEvents = false;
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.noExportButton = factory.createButton(container, PDEPlugin.getResourceString(KEY_NO_EXPORT), 16);
        GridData gd = new GridData(768);
        this.noExportButton.setLayoutData((Object)gd);
        this.noExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportSection.this.noExportButton.getSelection()) {
                    ExportSection.this.buttonChanged(ExportSection.this.noExportButton);
                }
            }
        });
        this.fullExportButton = factory.createButton(container, PDEPlugin.getResourceString(KEY_FULL_EXPORT), 16);
        gd = new GridData(768);
        this.fullExportButton.setLayoutData((Object)gd);
        this.fullExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportSection.this.fullExportButton.getSelection()) {
                    ExportSection.this.buttonChanged(ExportSection.this.fullExportButton);
                }
            }
        });
        this.selectedExportButton = factory.createButton(container, PDEPlugin.getResourceString(KEY_SELECTED_EXPORT), 16);
        gd = new GridData(768);
        this.selectedExportButton.setLayoutData((Object)gd);
        this.selectedExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportSection.this.selectedExportButton.getSelection()) {
                    ExportSection.this.buttonChanged(ExportSection.this.selectedExportButton);
                }
            }
        });
        this.nameFilterContainer = factory.createComposite(container);
        gd = new GridData(1808);
        this.nameFilterContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 2;
        this.nameFilterContainer.setLayout((Layout)layout);
        this.createNameTable(this.nameFilterContainer, factory);
        this.update(null);
        return container;
    }

    private Object[] createFilters(String[] names) {
        if (this.filters == null) {
            this.filters = new Vector();
            if (names != null) {
                int i = 0;
                while (i < names.length) {
                    this.filters.add(new NameFilter(names[i]));
                    ++i;
                }
            }
        }
        Object[] result = new Object[this.filters.size()];
        this.filters.copyInto(result);
        return result;
    }

    private void createNameTable(Composite parent, FormWidgetFactory factory) {
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(((IModel)this.getFormPage().getModel()).isEditable());
        this.createViewerPartControl(parent, 65536, 2, factory);
        this.nameTableViewer = tablePart.getTableViewer();
        this.nameTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.nameTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        factory.paintBordersFor(parent);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.getFormPage().setSelection((ISelection)selection);
        this.getTablePart().setButtonEnabled(1, item != null);
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleAdd();
        } else if (index == 1) {
            this.handleDelete();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    protected void entryModified(Object entry, String newValue) {
        Item item = (Item)entry;
        final NameFilter filter = (NameFilter)item.getData();
        filter.setName(newValue);
        this.setDirty(true);
        this.commitChanges(false);
        this.getTablePart().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ExportSection.this.nameTableViewer.update((Object)filter, null);
            }
        });
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    protected void fillContextMenu(IMenuManager manager) {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IAction renameAction = this.getRenameAction();
        renameAction.setEnabled(model.isEditable());
        manager.add(renameAction);
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleAdd() {
        NameFilter filter = new NameFilter(PDEPlugin.getResourceString(KEY_NEW_FILTER));
        this.filters.add(filter);
        this.nameTableViewer.add((Object)filter);
        this.nameTableViewer.editElement((Object)filter, 0);
        this.setDirty(true);
        this.commitChanges(false);
    }

    private void handleDelete() {
        ISelection selection = this.nameTableViewer.getSelection();
        Object item = ((IStructuredSelection)selection).getFirstElement();
        if (item != null) {
            this.filters.remove(item);
            this.nameTableViewer.remove(item);
        }
        this.getTablePart().setButtonEnabled(1, false);
        this.setDirty(true);
        this.commitChanges(false);
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.setReadOnly(!model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        Object object;
        if (this.ignoreModelEvents) {
            return;
        }
        if (e.getChangeType() == 3 && (object = e.getChangedObjects()[0]).equals(this.currentLibrary)) {
            this.update(this.currentLibrary);
        }
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        this.update((IPluginLibrary)changeObject);
    }

    private void selectButton(Button button) {
        this.noExportButton.setSelection(button == this.noExportButton);
        this.selectedExportButton.setSelection(button == this.selectedExportButton);
        this.fullExportButton.setSelection(button == this.fullExportButton);
    }

    private void update(IPluginLibrary library) {
        if (library == null) {
            this.nameFilterContainer.setVisible(false);
            this.fullExportButton.setEnabled(false);
            this.fullExportButton.setSelection(false);
            this.noExportButton.setEnabled(false);
            this.noExportButton.setSelection(false);
            this.selectedExportButton.setEnabled(false);
            this.selectedExportButton.setSelection(false);
            this.currentLibrary = null;
            return;
        }
        if (this.currentLibrary == null && !this.isReadOnly()) {
            this.fullExportButton.setEnabled(true);
            this.noExportButton.setEnabled(true);
            this.selectedExportButton.setEnabled(true);
        }
        this.currentLibrary = library;
        if (library.isFullyExported()) {
            this.selectButton(this.fullExportButton);
        } else if (!library.isExported()) {
            this.selectButton(this.noExportButton);
        } else {
            this.selectButton(this.selectedExportButton);
        }
        this.nameFilterContainer.setVisible(this.selectedExportButton.getSelection());
        this.filters = null;
        this.nameTableViewer.setInput((Object)library);
        this.getTablePart().setButtonEnabled(1, false);
    }

    class NameFilter {
        private String name;

        public NameFilter(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginLibrary) {
                return ExportSection.this.createFilters(((IPluginLibrary)parent).getContentFilters());
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

