/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionPointPage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionPointWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class DetailExtensionPointSection
extends TableSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "ManifestEditor.DetailExtensionPointSection.title";
    public static final String SECTION_DESC = "ManifestEditor.DetailExtensionPointSection.desc";
    public static final String SECTION_NEW = "ManifestEditor.DetailExtensionPointSection.new";
    public static final String POPUP_NEW_EXTENSION_POINT = "ManifestEditor.DetailExtensionPointSection.newExtensionPoint";
    public static final String POPUP_OPEN_SCHEMA = "ManifestEditor.DetailExtensionPointSection.openSchema";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private TableViewer pointTable;

    public DetailExtensionPointSection(ManifestExtensionPointPage page) {
        super(page, new String[]{PDEPlugin.getResourceString(SECTION_NEW)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.getTablePart().setEditable(false);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        this.createViewerPartControl(container, 65536, 2, factory);
        EditableTablePart part = this.getTablePart();
        this.pointTable = part.getTableViewer();
        this.pointTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.pointTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        factory.paintBordersFor(container);
        return container;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)selection);
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        this.pointTable.setSelection((ISelection)new StructuredSelection(object), true);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.pointTable.getSelection();
        Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_EXTENSION_POINT)){

            public void run() {
                DetailExtensionPointSection.this.handleNew();
            }
        };
        newAction.setEnabled(!this.isReadOnly());
        manager.add((IAction)newAction);
        if (!selection.isEmpty()) {
            IEditorInput input;
            Object object = ((IStructuredSelection)selection).getFirstElement();
            final IPluginExtensionPoint point = (IPluginExtensionPoint)object;
            if (point.getSchema() != null && ((input = this.getFormPage().getEditor().getEditorInput()) instanceof IFileEditorInput || input instanceof SystemFileEditorInput)) {
                Action openSchemaAction = new Action(PDEPlugin.getResourceString(POPUP_OPEN_SCHEMA)){

                    public void run() {
                        DetailExtensionPointSection.this.handleOpenSchema(point);
                    }
                };
                manager.add((IAction)openSchemaAction);
            }
            manager.add((IContributionItem)new Separator());
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    IPluginBase plugin = point.getPluginBase();
                    try {
                        plugin.remove(point);
                    }
                    catch (CoreException coreException) {}
                }
            };
            deleteAction.setEnabled(!this.isReadOnly());
            manager.add((IAction)deleteAction);
        }
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
            actionGroup.setContext(new ActionContext(selection));
            actionGroup.fillContextMenu(manager);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new PropertiesAction(this.getFormPage().getEditor()));
        }
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    private void handleDelete() {
        Object object = ((IStructuredSelection)this.pointTable.getSelection()).getFirstElement();
        if (object != null && object instanceof IPluginExtensionPoint) {
            IPluginExtensionPoint ep = (IPluginExtensionPoint)object;
            IPluginBase plugin = ep.getPluginBase();
            try {
                plugin.remove(ep);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNew() {
        IFile file = ((IFileEditorInput)this.getFormPage().getEditor().getEditorInput()).getFile();
        final IProject project = file.getProject();
        BusyIndicator.showWhile((Display)this.pointTable.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewExtensionPointWizard wizard = new NewExtensionPointWizard(project, (IPluginModelBase)DetailExtensionPointSection.this.getFormPage().getModel());
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
                dialog.open();
            }
        });
    }

    private void handleOpenSchema(IPluginExtensionPoint point) {
        Object input;
        String schema = point.getSchema();
        ISharedPluginModel model = point.getModel();
        IResource resource = model.getUnderlyingResource();
        final IWorkbenchPage page = PDEPlugin.getActivePage();
        if (resource != null) {
            IProject project = resource.getProject();
            IFile file = project.getFile(schema);
            input = new FileEditorInput(file);
        } else {
            File file;
            IPluginModelBase pmodel = (IPluginModelBase)model;
            String location = pmodel.getInstallLocation();
            if (location.startsWith("file:")) {
                location = location.substring(5);
            }
            if (!(file = new File(String.valueOf(location) + File.separator + schema)).exists()) {
                SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
                file = manager.findSourceFile(point.getPluginBase(), (IPath)new Path(schema));
            }
            input = new SystemFileEditorInput(file);
        }
        BusyIndicator.showWhile((Display)this.pointTable.getTable().getDisplay(), (Runnable)new Runnable((IEditorInput)input){
            private final /* synthetic */ IEditorInput val$input;
            {
                this.val$input = iEditorInput;
            }

            public void run() {
                try {
                    page.openEditor(this.val$input, "org.eclipse.pde.ui.schemaEditor");
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.pointTable.setInput((Object)model.getPluginBase());
        this.setReadOnly(!model.isEditable());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.pointTable.refresh();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginExtensionPoint) {
            if (event.getChangeType() == 1) {
                this.pointTable.add(changeObject);
                this.pointTable.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.pointTable.getTable().setFocus();
            } else if (event.getChangeType() == 2) {
                this.pointTable.remove(changeObject);
            } else {
                IStructuredSelection ssel;
                ISelection sel;
                this.pointTable.update(changeObject, null);
                if (this.pointTable.getTable().isFocusControl() && (sel = this.getFormPage().getSelection()) != null && sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty() && ssel.getFirstElement().equals(changeObject)) {
                    this.asyncResendSelection(sel);
                }
            }
        }
    }

    private void asyncResendSelection(final ISelection sel) {
        this.pointTable.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DetailExtensionPointSection.this.getFormPage().setSelection(sel);
            }
        });
    }

    public void setFocus() {
        this.pointTable.getTable().setFocus();
    }

    protected void doPaste(Object target, Object[] objects) {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        try {
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (obj instanceof IPluginExtensionPoint) {
                    PluginExtensionPoint point = (PluginExtensionPoint)obj;
                    point.setModel((ISharedPluginModel)model);
                    point.setParent((IPluginObject)plugin);
                    plugin.add((IPluginExtensionPoint)point);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return objects[0] instanceof IPluginExtensionPoint;
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginBase) {
                return ((IPluginBase)parent).getExtensionPoints();
            }
            return new Object[0];
        }
    }
}

