/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.builders.DependencyLoop;
import org.eclipse.pde.internal.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.views.markers.MarkerViewUtil;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HyperlinkAdapter;
import org.eclipse.update.ui.forms.internal.HyperlinkHandler;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class AlertSection
extends PDEFormSection
implements IResourceChangeListener {
    public static final String SECTION_TITLE = "ManifestEditor.AlertSection.title";
    public static final String KEY_NO_ALERTS = "ManifestEditor.AlertSection.noAlerts";
    public static final String KEY_UNRESOLVED = "ManifestEditor.AlertSection.unresolved";
    public static final String KEY_UNRESOLVED_TOOLTIP = "ManifestEditor.AlertSection.unresolved.tooltip";
    public static final String KEY_FRAGMENT_MARKERS = "ManifestEditor.AlertSection.fragmentMarkers";
    public static final String KEY_PLUGIN_MARKERS = "ManifestEditor.AlertSection.pluginMarkers";
    public static final String KEY_MARKERS_TOOLTIP = "ManifestEditor.AlertSection.markers.tooltip";
    private Image alertImage;
    private Image taskAlertImage;
    private boolean updateNeeded;
    private HyperlinkHandler handler;
    private Composite container;

    public AlertSection(ManifestFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.handler = new HyperlinkHandler();
        this.alertImage = PDEPluginImages.DESC_ALERT_OBJ.createImage();
        this.taskAlertImage = PDEPluginImages.DESC_TSK_ALERT_OBJ.createImage();
    }

    private boolean checkMarkers(Composite parent, FormWidgetFactory factory) {
        IEditorInput input = this.getFormPage().getEditor().getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return false;
        }
        IFile file = ((IFileEditorInput)input).getFile();
        IProject project = file.getProject();
        try {
            IMarker[] problems = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            IMarker[] tasks = project.findMarkers("org.eclipse.core.resources.taskmarker", true, 2);
            if (problems.length == 0 && tasks.length == 0) {
                return false;
            }
            final IMarker[] markers = this.mergeMarkers(problems, tasks);
            String[] args = new String[]{"" + problems.length, "" + tasks.length};
            String message = ((ManifestEditor)this.getFormPage().getEditor()).isFragmentEditor() ? PDEPlugin.getFormattedMessage(KEY_FRAGMENT_MARKERS, args) : PDEPlugin.getFormattedMessage(KEY_PLUGIN_MARKERS, args);
            Label imageLabel = factory.createLabel(parent, null);
            imageLabel.setImage(this.taskAlertImage);
            SelectableFormLabel label = factory.createSelectableLabel(parent, message);
            label.setToolTipText(PDEPlugin.getResourceString(KEY_MARKERS_TOOLTIP));
            this.handler.registerHyperlink((Control)label, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(Control link) {
                    Display.getCurrent().asyncExec(new Runnable(this, markers){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IMarker[] val$markers;
                        {
                            this.this$1 = var1_1;
                            this.val$markers = iMarkerArray;
                        }

                        public void run() {
                            MarkerViewUtil.showMarker((IWorkbenchPage)PDEPlugin.getActivePage(), (IMarker)this.val$markers[0], (boolean)true);
                        }
                    });
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private boolean checkReferences(Composite parent, FormWidgetFactory factory) {
        IPluginModel model = (IPluginModel)this.getFormPage().getModel();
        if (!model.isEditable()) {
            return false;
        }
        IPlugin plugin = model.getPlugin();
        IPluginImport[] imports = plugin.getImports();
        boolean unresolvedReferences = false;
        boolean cycles = false;
        int i = 0;
        while (i < imports.length) {
            IPlugin refPlugin;
            IPluginImport iimport = imports[i];
            if (iimport.getId() != null && (refPlugin = PDECore.getDefault().findPlugin(iimport.getId())) == null) {
                unresolvedReferences = true;
                break;
            }
            ++i;
        }
        if (!unresolvedReferences) {
            DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)plugin);
            boolean bl = cycles = loops.length > 0;
        }
        if (!unresolvedReferences && !cycles) {
            return false;
        }
        String message = PDEPlugin.getResourceString(KEY_UNRESOLVED);
        Label imageLabel = factory.createLabel(parent, null);
        imageLabel.setImage(this.alertImage);
        SelectableFormLabel label = factory.createSelectableLabel(parent, message);
        label.setToolTipText(PDEPlugin.getResourceString(KEY_UNRESOLVED_TOOLTIP));
        this.handler.registerHyperlink((Control)label, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(Control link) {
                AlertSection.this.getFormPage().getEditor().showPage("DependenciesPage");
            }
        });
        return true;
    }

    public void createAlerts(Composite container, FormWidgetFactory factory) {
        boolean hasAlerts = false;
        boolean fragment = ((ManifestEditor)this.getFormPage().getEditor()).isFragmentEditor();
        hasAlerts = this.checkMarkers(container, factory);
        if (!fragment && this.checkReferences(container, factory)) {
            hasAlerts = true;
        }
        if (!hasAlerts) {
            Label label = factory.createLabel(container, PDEPlugin.getResourceString(KEY_NO_ALERTS));
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.handler.setBackground(factory.getBackgroundColor());
        this.handler.setForeground(factory.getForegroundColor());
        this.handler.setActiveForeground(factory.getHyperlinkColor());
        this.handler.setHyperlinkUnderlineMode(3);
        this.container = factory.createComposite(parent);
        this.container.setLayout((Layout)layout);
        this.createAlerts(this.container, factory);
        return this.container;
    }

    public void dispose() {
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        this.handler.dispose();
        this.alertImage.dispose();
        this.taskAlertImage.dispose();
        super.dispose();
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private IMarker[] mergeMarkers(IMarker[] problems, IMarker[] tasks) {
        IMarker[] result = new IMarker[problems.length + tasks.length];
        int i = 0;
        while (i < problems.length) {
            result[i] = problems[i];
            ++i;
        }
        int j = 0;
        while (j < tasks.length) {
            result[i++] = tasks[j];
            ++j;
        }
        return result;
    }

    public void modelChanged(IModelChangedEvent e) {
        int eventType = e.getChangeType();
        if (eventType == 99) {
            this.updateNeeded = true;
        } else {
            Object object = e.getChangedObjects()[0];
            if (object instanceof IPluginImport && (eventType == 1 || eventType == 2)) {
                this.updateNeeded = true;
            }
        }
        if (this.getFormPage().isVisible()) {
            this.update();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input = this.getFormPage().getEditor().getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IProject ourProject = file.getProject();
            if (event.getType() == 2 || event.getType() == 4) {
                return;
            }
            if (this.container == null || this.container.isDisposed()) {
                return;
            }
            DeltaVisitor visitor = new DeltaVisitor(ourProject);
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                try {
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                if (visitor.getMarkersChanged()) {
                    this.updateNeeded = true;
                    if (this.getFormPage().isVisible()) {
                        this.container.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                AlertSection.this.update();
                            }
                        });
                    }
                }
            }
        }
    }

    public void update() {
        if (this.container.isDisposed()) {
            return;
        }
        if (this.updateNeeded) {
            Control[] children = this.container.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            this.createAlerts(this.container, this.getFormPage().getForm().getFactory());
            this.container.layout(true);
            this.container.getParent().getParent().layout(true);
            ((Composite)this.getFormPage().getForm().getControl()).layout(true);
            this.updateNeeded = false;
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean markersChanged = false;
        private IProject ourProject;

        public DeltaVisitor(IProject ourProject) {
            this.ourProject = ourProject;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource == null) {
                return true;
            }
            IProject project = resource.getProject();
            if (project == null) {
                return true;
            }
            if (resource.getProject().equals((Object)this.ourProject)) {
                if ((delta.getKind() & 4) != 0 && (delta.getFlags() & 0x20000) != 0) {
                    this.markersChanged = true;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public boolean getMarkersChanged() {
            return this.markersChanged;
        }
    }
}

