/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureEntry;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEntryPropertySource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ReferencePropertySource
extends FeatureEntryPropertySource {
    private IPluginBase pluginBase;
    private Image errorImage;
    public static final String KEY_NAME = "FeatureEditor.ReferenceProp.name";
    public static final String KEY_VERSION = "FeatureEditor.ReferenceProp.version";
    public static final String KEY_ORIGINAL_VERSION = "FeatureEditor.ReferenceProp.originalVersion";
    private static final String P_NAME = "name";
    private static final String P_VERSION = "version";
    private static final String P_REF_VERSION = "ref_version";

    public ReferencePropertySource(IFeaturePlugin reference, Image errorImage) {
        super((IFeatureEntry)reference);
        this.errorImage = errorImage;
    }

    private String getOriginalVersion() {
        IPluginBase pluginBase = this.getPluginBase();
        if (pluginBase == null) {
            return "";
        }
        return pluginBase.getVersion();
    }

    private IPluginBase getPluginBase() {
        if (this.pluginBase == null) {
            IFeaturePlugin reference = this.getPluginReference();
            if (reference.getModel().getUnderlyingResource() == null) {
                return null;
            }
            String id = reference.getId();
            IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            Object[] models = null;
            models = reference.isFragment() ? manager.getFragmentModels() : manager.getPluginModels();
            int i = 0;
            while (i < models.length) {
                IPluginModelBase modelBase = models[i];
                IPluginBase candidate = modelBase.getPluginBase();
                if (candidate.getId().equals(id)) {
                    this.pluginBase = candidate;
                    break;
                }
                ++i;
            }
        }
        return this.pluginBase;
    }

    public IFeaturePlugin getPluginReference() {
        return (IFeaturePlugin)this.object;
    }

    protected void createPropertyDescriptors() {
        super.createPropertyDescriptors();
        PropertyDescriptor desc = new PropertyDescriptor((Object)P_NAME, PDEPlugin.getResourceString(KEY_NAME));
        this.descriptors.addElement(desc);
        desc = this.createTextPropertyDescriptor(P_VERSION, PDEPlugin.getResourceString(KEY_VERSION));
        this.descriptors.addElement(desc);
        desc = new PropertyDescriptor((Object)P_REF_VERSION, PDEPlugin.getResourceString(KEY_ORIGINAL_VERSION));
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_NAME)) {
            return this.getPluginReference().getLabel();
        }
        if (name.equals(P_VERSION)) {
            return this.getPluginReference().getVersion();
        }
        if (name.equals(P_REF_VERSION)) {
            return this.getOriginalVersion();
        }
        return super.getPropertyValue(name);
    }

    public void setElement(IFeaturePlugin plugin) {
        this.object = plugin;
    }

    public void setPropertyValue(Object name, Object value) {
        String svalue = value.toString();
        String realValue = svalue == null | svalue.length() == 0 ? null : svalue;
        try {
            if (name.equals(P_NAME)) {
                this.getPluginReference().setLabel(realValue);
            } else if (name.equals(P_VERSION)) {
                this.getPluginReference().setVersion(realValue);
            } else {
                super.setPropertyValue(name, value);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public class VersionProvider
    extends LabelProvider {
        public Image getImage(Object obj) {
            String originalVersion = ReferencePropertySource.this.getOriginalVersion();
            IFeaturePlugin ref = ReferencePropertySource.this.getPluginReference();
            boolean inSync = ref.getVersion().equals(originalVersion);
            return inSync ? null : ReferencePropertySource.this.errorImage;
        }
    }
}

