/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureSpecSection;
import org.eclipse.pde.internal.ui.editor.feature.PortabilitySection;
import org.eclipse.pde.internal.ui.editor.feature.URLSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public class FeatureForm
extends ScrollableSectionForm {
    private FeatureFormPage page;
    private URLSection urlSection;
    private FeatureSpecSection specSection;
    private PortabilitySection portabilitySection;

    public FeatureForm(FeatureFormPage page) {
        this.page = page;
        this.setVerticalFit(true);
    }

    protected void createFormClient(Composite parent) {
        FormWidgetFactory factory = this.getFactory();
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        this.specSection = new FeatureSpecSection(this.page);
        Control control = this.specSection.createControl(parent, factory);
        GridData gd = new GridData(770);
        control.setLayoutData((Object)gd);
        this.urlSection = new URLSection(this.page);
        control = this.urlSection.createControl(parent, factory);
        gd = new GridData(784);
        control.setLayoutData((Object)gd);
        this.portabilitySection = new PortabilitySection(this.page);
        control = this.portabilitySection.createControl(parent, factory);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.registerSection(this.specSection);
        this.registerSection(this.urlSection);
        this.registerSection(this.portabilitySection);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_feature_overview");
    }

    public void expandTo(Object object) {
        this.urlSection.expandTo(object);
    }

    public void initialize(Object modelObject) {
        IFeatureModel model = (IFeatureModel)modelObject;
        super.initialize((Object)model);
        IFeature feature = model.getFeature();
        this.setHeadingText(model.getResourceString(feature.getLabel()));
        ((Composite)this.getControl()).layout(true);
    }

    public void setFocus() {
    }
}

