/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageXMLEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureSourcePage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureUndoManager;
import org.eclipse.pde.internal.ui.editor.feature.InfoFormPage;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class FeatureEditor
extends PDEMultiPageXMLEditor {
    public static final String FEATURE_PAGE = "ComponentPage";
    public static final String INFO_PAGE = "InfoPage";
    public static final String REFERENCE_PAGE = "ReferencePage";
    public static final String ADVANCED_PAGE = "AdvancedPage";
    public static final String SOURCE_PAGE = "SourcePage";
    public static final String UNRESOLVED_TITLE = "FeatureEditor.Unresolved.title";
    public static final String VERSION_TITLE = "FeatureEditor.Version.title";
    public static final String VERSION_MESSAGE = "FeatureEditor.Version.message";
    public static final String VERSION_EXISTS = "FeatureEditor.Version.exists";
    public static final String UNRESOLVED_MESSAGE = "FeatureEditor.Unresolved.message";
    public static final String FEATURE_PAGE_TITLE = "FeatureEditor.FeaturePage.title";
    public static final String REFERENCE_PAGE_TITLE = "FeatureEditor.ReferencePage.title";
    public static final String ADVANCED_PAGE_TITLE = "FeatureEditor.AdvancedPage.title";
    public static final String INFO_PAGE_TITLE = "FeatureEditor.InfoPage.title";
    private boolean storageModel = false;

    protected IModelUndoManager createModelUndoManager() {
        return new FeatureUndoManager(this);
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected Object createModel(Object input) throws CoreException {
        if (input instanceof IFile) {
            return this.createResourceModel((IFile)input);
        }
        if (input instanceof IStorage) {
            return this.createStorageModel((IStorage)input);
        }
        return null;
    }

    protected void createPages() {
        this.firstPageId = FEATURE_PAGE;
        this.formWorkbook.setFirstPageSelected(false);
        FeatureFormPage featurePage = new FeatureFormPage(this, PDEPlugin.getResourceString(FEATURE_PAGE_TITLE));
        FeatureReferencePage referencePage = new FeatureReferencePage(featurePage, PDEPlugin.getResourceString(REFERENCE_PAGE_TITLE));
        InfoFormPage infoPage = new InfoFormPage(featurePage, PDEPlugin.getResourceString(INFO_PAGE_TITLE));
        FeatureAdvancedPage advancedPage = new FeatureAdvancedPage(featurePage, PDEPlugin.getResourceString(ADVANCED_PAGE_TITLE));
        this.addPage(FEATURE_PAGE, featurePage);
        this.addPage(INFO_PAGE, infoPage);
        this.addPage(REFERENCE_PAGE, referencePage);
        this.addPage(ADVANCED_PAGE, advancedPage);
        this.addPage(SOURCE_PAGE, new FeatureSourcePage(this));
    }

    private IFeatureModel createResourceModel(IFile file) throws CoreException {
        InputStream stream = null;
        stream = file.getContents(false);
        IWorkspaceModelManager provider = PDECore.getDefault().getWorkspaceModelManager();
        provider.connect((Object)file, (Object)this);
        IFeatureModel model = (IFeatureModel)provider.getModel((Object)file, (Object)this);
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    private IFeatureModel createStorageModel(IStorage storage) {
        InputStream stream = null;
        try {
            stream = storage.getContents();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation("");
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        this.storageModel = true;
        return model;
    }

    public void dispose() {
        super.dispose();
        IWorkspaceModelManager provider = PDECore.getDefault().getWorkspaceModelManager();
        IModel model = (IModel)this.getModel();
        if (this.storageModel) {
            model.dispose();
        } else {
            provider.disconnect((Object)model.getUnderlyingResource(), (Object)this);
        }
    }

    public IPDEEditorPage getHomePage() {
        return this.getPage(FEATURE_PAGE);
    }

    protected String getSourcePageId() {
        return SOURCE_PAGE;
    }

    public String getTitle() {
        if (!this.isModelCorrect(this.getModel())) {
            return super.getTitle();
        }
        IFeatureModel model = (IFeatureModel)this.getModel();
        String name = model.getFeature().getLabel();
        if (name == null) {
            return super.getTitle();
        }
        return model.getResourceString(name);
    }

    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.clipboard.getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < transfers.length) {
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    protected boolean isModelDirty(Object model) {
        return model != null && model instanceof IEditable && model instanceof IModel && ((IModel)model).isEditable() && ((IEditable)model).isDirty();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IFeatureModel)model).isValid() : false;
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        return input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput) ? name.startsWith("feature.xml") : name.equals("feature.xml");
    }

    protected boolean updateModel() {
        IFeatureModel model = (IFeatureModel)this.getModel();
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        boolean cleanModel = true;
        String text = document.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }
}

