/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizard;
import org.eclipse.ui.PlatformUI;

public class EditorBuildFeatureAction
extends Action {
    public static final String LABEL = "FeatureEditor.BuildAction.label";
    private FeatureEditor activeEditor;
    private IFile featureFile;

    public EditorBuildFeatureAction() {
        this.setText(PDEPlugin.getResourceString(LABEL));
    }

    private void ensureContentSaved() {
        if (this.activeEditor.isDirty()) {
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
            try {
                monitor.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        EditorBuildFeatureAction.this.activeEditor.doSave(monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        this.ensureContentSaved();
        FeatureExportWizard wizard = new FeatureExportWizard();
        StructuredSelection selection = this.featureFile != null ? new StructuredSelection((Object)this.featureFile) : new StructuredSelection();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wd.create();
        wd.getShell().setSize(450, 600);
        wd.open();
    }

    public void setActiveEditor(FeatureEditor editor) {
        this.activeEditor = editor;
        IFeatureModel model = (IFeatureModel)editor.getModel();
        this.featureFile = (IFile)model.getUnderlyingResource();
        this.setEnabled(model.isEditable());
    }
}

