/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;

public class SrcSection
extends BuildContentsSection
implements IModelChangedListener {
    private static String SECTION_TITLE = "BuildPropertiesEditor.SrcSection.title";
    private static String SECTION_DESC = "BuildPropertiesEditor.SrcSection.desc";

    public SrcSection(BuildPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    protected void initializeCheckState() {
        super.initializeCheckState();
        IBuild build = this.buildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        if (srcIncl == null) {
            return;
        }
        super.initializeCheckState(srcIncl, srcExcl);
    }

    protected void deleteFolderChildrenFromEntries(IFolder folder) {
        IBuild build = this.buildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        String parentFolder = this.getResourceFolderName(folder.getProjectRelativePath().toString());
        this.removeChildren(srcIncl, parentFolder);
        this.removeChildren(srcExcl, parentFolder);
    }

    protected void handleBuildCheckStateChange(IResource resource, boolean checked, boolean wasTopParentChecked) {
        String resourceName = resource.getFullPath().removeFirstSegments(1).toString();
        IBuild build = this.buildModel.getBuild();
        IBuildEntry includes = build.getEntry("src.includes");
        IBuildEntry excludes = build.getEntry("src.excludes");
        resourceName = this.handleResourceFolder(resource, resourceName);
        if (checked) {
            this.handleCheck(includes, excludes, resourceName, resource, wasTopParentChecked, "src.includes");
        } else {
            this.handleUncheck(includes, excludes, resourceName, resource, "src.excludes");
        }
        this.deleteEmptyEntries();
    }
}

