/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.build.AddLibraryDialog;
import org.eclipse.pde.internal.ui.editor.build.BuildUtil;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.parts.FolderSelectionDialog;
import org.eclipse.pde.internal.ui.parts.RenameDialog;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class RuntimeInfoSection
extends PDEFormSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "BuildPropertiesEditor.RuntimeInfoSection.title";
    public static final String SECTION_DESC = "BuildPropertiesEditor.RuntimeInfoSection.desc";
    public static final String SECTION_NEW = "BuildPropertiesEditor.RuntimeInfoSection.addLibrary";
    public static final String SECTION_UP = "ManifestEditor.LibrarySection.up";
    public static final String SECTION_DOWN = "ManifestEditor.LibrarySection.down";
    public static final String POPUP_NEW_LIBRARY = "ManifestEditor.LibrarySection.newLibrary";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String NEW_LIBRARY_ENTRY = "ManifestEditor.LibrarySection.newLibraryEntry";
    public static final String JSECTION_NEW = "BuildPropertiesEditor.RuntimeInfoSection.addFolder";
    public static final String POPUP_NEW_FOLDER = "ManifestEditor.JarsSection.newFolder";
    public static final String JAR_INCLUDE = "BuildPropertiesEditor.RuntimeInfoSection.buildInclude";
    private static RGB LIGHT_GRAY = new RGB(172, 168, 153);
    private static RGB BLACK = new RGB(0, 0, 0);
    public Image libImage;
    public Image jarsImage;
    protected TableViewer libraryViewer;
    protected TableViewer foldersViewer;
    protected Control sectionControl;
    protected StructuredViewerPart libraryPart;
    protected StructuredViewerPart foldersPart;
    private IBuildEntry currentLibrary;
    private Button jarIncludeButton;
    private PDEFormPage page;

    public RuntimeInfoSection(PDEFormPage page) {
        super(page);
        this.page = page;
        this.setAddSeparator(true);
        this.setHeaderPainted(true);
        this.setDescriptionPainted(true);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    protected void handleLibInBinBuild(boolean isSelected) {
        String libName = this.currentLibrary.getName().substring(7);
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        IBuildEntry binIncl = model.getBuild().getEntry("bin.includes");
        IProject project = model.getUnderlyingResource().getProject();
        IPath libPath = project.getFile(libName).getProjectRelativePath();
        try {
            if (binIncl == null && !isSelected) {
                return;
            }
            if (binIncl == null) {
                binIncl = model.getFactory().createEntry("bin.includes");
                model.getBuild().add(binIncl);
            }
            if (!isSelected && libPath.segmentCount() == 1 && binIncl.contains("*.jar")) {
                this.addAllJarsToBinIncludes(binIncl, project, model);
            }
            if (isSelected && !binIncl.contains(libName)) {
                binIncl.addToken(libName);
            } else if (!isSelected && binIncl.contains(libName)) {
                binIncl.removeToken(libName);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void addAllJarsToBinIncludes(IBuildEntry binIncl, IProject project, IBuildModel model) {
        try {
            IResource[] members = project.members();
            int i = 0;
            while (i < members.length) {
                if (!(members[i] instanceof IFolder) && members[i].getFileExtension().equals("jar")) {
                    binIncl.addToken(members[i].getName());
                }
                ++i;
            }
            IBuildEntry[] libraries = BuildUtil.getBuildLibraries(model.getBuild().getBuildEntries());
            if (libraries.length != 0) {
                int j = 0;
                while (j < libraries.length) {
                    String libraryName = libraries[j].getName().substring(7);
                    IPath path = project.getFile(libraryName).getProjectRelativePath();
                    if (path.segmentCount() == 1 && !binIncl.contains(libraryName)) {
                        binIncl.addToken(libraryName);
                    }
                    ++j;
                }
            }
            binIncl.removeToken("*.jar");
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void initialize(Object input) {
        IBuildModel model = (IBuildModel)input;
        this.setReadOnly(false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private IBuildEntry createOutputKey(String libName) {
        IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();
        IBuild build = buildModel.getBuild();
        String outputName = "output." + libName;
        IBuildEntry outputEntry = build.getEntry(outputName);
        try {
            if (outputEntry != null) {
                build.remove(outputEntry);
            }
            outputEntry = buildModel.getFactory().createEntry(outputName);
            build.add(outputEntry);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return outputEntry;
    }

    private void setOutputEntryTokens(Set outputFolders, IBuildEntry outputEntry) {
        Iterator iter = outputFolders.iterator();
        try {
            while (iter.hasNext()) {
                String outputFolder = iter.next().toString();
                if (!outputFolder.endsWith("/")) {
                    outputFolder = outputFolder.concat("/");
                }
                outputEntry.addToken(outputFolder.toString());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        PartAdapter tablePart = new PartAdapter(buttonLabels);
        tablePart.setEditable(true);
        return tablePart;
    }

    private void intializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.libImage = provider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
        IWorkbench workbench = PlatformUI.getWorkbench();
        ISharedImages sharedImages = workbench.getSharedImages();
        this.jarsImage = sharedImages.getImage("IMG_OBJ_FOLDER");
    }

    private IPackageFragmentRoot[] computeSourceFolders() {
        ArrayList<IPackageFragmentRoot> folders = new ArrayList<IPackageFragmentRoot>();
        IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        folders.add(roots[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return folders.toArray(new IPackageFragmentRoot[folders.size()]);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.intializeImages();
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.createLeftSection(container, factory);
        this.createRightSection(container, factory);
        this.jarIncludeButton = factory.createButton(container, PDEPlugin.getResourceString(JAR_INCLUDE), 32);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.jarIncludeButton.setLayoutData((Object)gd);
        this.jarIncludeButton.setVisible(false);
        this.jarIncludeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeInfoSection.this.handleLibInBinBuild(RuntimeInfoSection.this.jarIncludeButton.getSelection());
            }
        });
        factory.paintBordersFor(container);
        return container;
    }

    private void createLeftSection(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        container.setLayoutData((Object)gd);
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString(SECTION_NEW);
        stringArray[2] = PDEPlugin.getResourceString(SECTION_UP);
        stringArray[3] = PDEPlugin.getResourceString(SECTION_DOWN);
        this.libraryPart = this.createViewerPart(stringArray);
        this.libraryPart.createControl(container, 65536, 2, factory);
        ((EditableTablePart)this.libraryPart).setEditable(true);
        this.libraryViewer = (TableViewer)this.libraryPart.getViewer();
        this.libraryViewer.setContentProvider((IContentProvider)new LibTableContentProvider());
        this.libraryViewer.setLabelProvider((IBaseLabelProvider)new LibTableLabelProvider());
        this.libraryPart.setButtonEnabled(2, false);
        this.libraryPart.setButtonEnabled(3, false);
        this.libraryViewer.setInput(this.getFormPage().getModel());
        factory.paintBordersFor(container);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RuntimeInfoSection.this.fillLibContextMenu(manager);
            }
        });
        this.libraryViewer.getControl().setMenu(menuMgr.createContextMenu(this.libraryViewer.getControl()));
    }

    private void createRightSection(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        container.setLayoutData((Object)gd);
        this.foldersPart = this.createViewerPart(new String[]{PDEPlugin.getResourceString(JSECTION_NEW)});
        this.foldersPart.createControl(container, 65536, 2, factory);
        ((EditableTablePart)this.foldersPart).setEditable(true);
        this.foldersViewer = (TableViewer)this.foldersPart.getViewer();
        this.foldersViewer.setContentProvider((IContentProvider)new JarsTableContentProvider());
        this.foldersViewer.setLabelProvider((IBaseLabelProvider)new JarsTableLabelProvider());
        factory.paintBordersFor(container);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RuntimeInfoSection.this.fillJarsContextMenu(manager);
            }
        });
        this.foldersViewer.getControl().setMenu(menuMgr.createContextMenu(this.foldersViewer.getControl()));
    }

    protected EditableTablePart getLibTablePart() {
        return (EditableTablePart)this.libraryPart;
    }

    protected EditableTablePart getJarsTablePart() {
        return (EditableTablePart)this.foldersPart;
    }

    protected void fillJarsContextMenu(IMenuManager manager) {
        ISelection selection = this.foldersViewer.getSelection();
        if (this.currentLibrary != null) {
            Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_FOLDER)){

                public void run() {
                    RuntimeInfoSection.this.handleJarsNew();
                }
            };
            newAction.setEnabled(true);
            manager.add((IAction)newAction);
        }
        manager.add((IContributionItem)new Separator());
        Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

            public void run() {
                RuntimeInfoSection.this.handleJarsDelete();
            }
        };
        deleteAction.setEnabled(!selection.isEmpty());
        manager.add((IAction)deleteAction);
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    protected void fillLibContextMenu(IMenuManager manager) {
        ISelection selection = this.libraryViewer.getSelection();
        Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_LIBRARY)){

            public void run() {
                RuntimeInfoSection.this.handleNew();
            }
        };
        newAction.setEnabled(true);
        manager.add((IAction)newAction);
        manager.add((IContributionItem)new Separator());
        RenameAction renameAction = new RenameAction();
        renameAction.setEnabled(!selection.isEmpty());
        manager.add((IAction)renameAction);
        Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

            public void run() {
                RuntimeInfoSection.this.handleDelete();
            }
        };
        deleteAction.setEnabled(!selection.isEmpty());
        manager.add((IAction)deleteAction);
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    protected void entryModified(IBuildEntry oldEntry, String newValue) {
        final IBuildEntry entry = oldEntry;
        IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();
        IBuild build = buildModel.getBuild();
        String oldName = entry.getName().substring(7);
        try {
            if (newValue.equals(entry.getName())) {
                return;
            }
            if (!newValue.startsWith("source.")) {
                newValue = "source." + newValue;
            }
            if (!newValue.endsWith(".jar")) {
                newValue = String.valueOf(newValue) + ".jar";
            }
            entry.setName(newValue);
            IBuildEntry tempEntry = build.getEntry("jars.compile.order");
            if (tempEntry != null) {
                tempEntry.renameToken(oldName, newValue.substring(7));
            }
            if ((tempEntry = build.getEntry("output." + oldName)) != null) {
                build.remove(tempEntry);
                this.refreshOutputKeys();
            }
            if ((tempEntry = build.getEntry("bin.includes")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newValue.substring(7));
            }
            if ((tempEntry = build.getEntry("bin.excludes")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newValue.substring(7));
            }
            this.libraryViewer.getTable().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RuntimeInfoSection.this.libraryViewer.update((Object)entry, null);
                }
            });
            this.libraryViewer.refresh();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void expandTo(Object object) {
        this.libraryViewer.setSelection((ISelection)new StructuredSelection(object), true);
    }

    public void handleDoubleClick(IStructuredSelection selection) {
    }

    public void disableSection() {
        if (this.getSectionControl() != null) {
            this.getSectionControl().setEnabled(false);
        }
        EditableTablePart tablePart = this.getJarsTablePart();
        tablePart.setButtonEnabled(0, false);
        tablePart.getControl().setForeground(new Color((Device)tablePart.getControl().getDisplay(), LIGHT_GRAY));
        tablePart.getTableViewer().setSelection(null, false);
        tablePart = this.getLibTablePart();
        tablePart.setButtonEnabled(0, false);
        tablePart.setButtonEnabled(2, false);
        tablePart.setButtonEnabled(3, false);
        tablePart.getControl().setForeground(new Color((Device)tablePart.getControl().getDisplay(), LIGHT_GRAY));
        tablePart.getTableViewer().setSelection(null, false);
    }

    public void setSectionControl(Control control) {
        this.sectionControl = control;
    }

    public Control getSectionControl() {
        return this.sectionControl;
    }

    public boolean doGlobalAction(String actionId) {
        IStructuredSelection currentSelection = (IStructuredSelection)this.getFormPage().getSelection();
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (currentSelection.getFirstElement().toString().startsWith("source.")) {
                this.handleDelete();
            } else {
                this.handleJarsDelete();
            }
            return true;
        }
        return false;
    }

    private void doRename() {
        IStructuredSelection selection = (IStructuredSelection)this.libraryViewer.getSelection();
        if (selection.size() == 1) {
            IBuildEntry entry = (IBuildEntry)selection.getFirstElement();
            String oldName = entry.getName().substring(7);
            RenameDialog dialog = new RenameDialog(this.libraryViewer.getControl().getShell(), oldName);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("EditableTablePart.renameTitle"));
            dialog.getShell().setSize(300, 150);
            if (dialog.open() == 0) {
                this.entryModified(entry, dialog.getNewName());
            }
        }
    }

    public void enableSection() {
        EditableTablePart tablePart = this.getLibTablePart();
        tablePart.setButtonEnabled(0, true);
        tablePart.setButtonEnabled(2, false);
        tablePart.setButtonEnabled(3, false);
        tablePart.getControl().setForeground(new Color((Device)tablePart.getControl().getDisplay(), BLACK));
        tablePart = this.getJarsTablePart();
        tablePart.setButtonEnabled(0, false);
        tablePart.getControl().setForeground(new Color((Device)tablePart.getControl().getDisplay(), BLACK));
        if (this.getSectionControl() != null) {
            this.getSectionControl().setEnabled(true);
        }
    }

    public void dispose() {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void refreshOutputKeys() {
        if (!this.isJavaProject()) {
            return;
        }
        IPackageFragmentRoot[] sourceFolders = this.computeSourceFolders();
        String[] jarFolders = this.currentLibrary.getTokens();
        try {
            HashSet<String> outputFolders = new HashSet<String>();
            int j = 0;
            while (j < jarFolders.length) {
                IPackageFragmentRoot sourceFolder = this.getSourceFolder(jarFolders[j], sourceFolders);
                if (sourceFolder != null) {
                    IClasspathEntry entry = sourceFolder.getRawClasspathEntry();
                    IPath outputPath = entry.getOutputLocation();
                    if (outputPath == null) {
                        outputFolders.add("bin");
                    } else {
                        outputPath = outputPath.removeFirstSegments(1);
                        outputFolders.add(outputPath.toString());
                    }
                }
                ++j;
            }
            if (outputFolders.size() != 0) {
                IBuildEntry outputEntry = this.createOutputKey(this.currentLibrary.getName().substring(7));
                this.setOutputEntryTokens(outputFolders, outputEntry);
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    private boolean isJavaProject() {
        try {
            IBuildModel buildModel = (IBuildModel)this.page.getModel();
            IProject project = buildModel.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void sectionChanged(Object changeObject) {
        IBuildEntry variable = (IBuildEntry)changeObject;
        this.update(variable);
    }

    private void update(IBuildEntry variable) {
        this.currentLibrary = variable;
        this.foldersViewer.setInput((Object)this.currentLibrary);
        this.getJarsTablePart().setButtonEnabled(0, !this.isReadOnly() && variable != null);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        if (item.toString().startsWith("source.")) {
            this.sectionChanged(item);
            this.updateDirectionalButtons();
            this.jarIncludeButton.setVisible(true);
            this.jarIncludeButton.setSelection(this.isJarIncluded(item.toString().substring(7)));
        }
        this.getFormPage().setSelection((ISelection)selection);
    }

    protected void updateDirectionalButtons() {
        Table table = this.libraryViewer.getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1;
        EditableTablePart tablePart = this.getLibTablePart();
        tablePart.setButtonEnabled(2, canMove && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    private boolean isJarIncluded(String libName) {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        IPath libPath = project.getFile(libName).getProjectRelativePath();
        IBuildEntry binIncl = model.getBuild().getEntry("bin.includes");
        IBuildEntry binExcl = model.getBuild().getEntry("bin.excludes");
        if (binIncl == null) {
            return false;
        }
        if (libPath.segmentCount() == 1) {
            return binIncl.contains(libName) || binIncl.contains("*.jar");
        }
        if (binIncl.contains(libName)) {
            return true;
        }
        if (binExcl != null && binExcl.contains(libName)) {
            return false;
        }
        return this.isParentIncluded(libPath, binIncl, binExcl);
    }

    protected boolean isParentIncluded(IPath libPath, IBuildEntry binIncl, IBuildEntry binExcl) {
        while (libPath.segmentCount() > 1) {
            if (binIncl.contains(String.valueOf((libPath = libPath.removeLastSegments(1)).toString()) + '/')) {
                return true;
            }
            if (binExcl == null || !binExcl.contains(String.valueOf(libPath.toString()) + '/')) continue;
            return false;
        }
        return false;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.libraryViewer.refresh();
            this.foldersViewer.refresh();
            this.libraryViewer.setSelection(null);
            this.foldersViewer.setInput(null);
            this.getJarsTablePart().setButtonEnabled(0, false);
            this.jarIncludeButton.setVisible(false);
            this.updateDirectionalButtons();
        }
    }

    protected String[] getLibraryNames() {
        String[] libNames = new String[this.libraryViewer.getTable().getItemCount()];
        int i = 0;
        while (i < libNames.length) {
            libNames[i] = this.libraryViewer.getTable().getItem(i).getText();
            ++i;
        }
        return libNames;
    }

    protected void handleNew() {
        final String[] libNames = this.getLibraryNames();
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        IModel pluginModel = PDECore.getDefault().getWorkspaceModelManager().getWorkspaceModel(project);
        final IPluginModelBase pluginModelBase = pluginModel instanceof IPluginModelBase ? (IPluginModelBase)pluginModel : null;
        BusyIndicator.showWhile((Display)this.libraryViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IBuildModel buildModel = (IBuildModel)RuntimeInfoSection.this.getFormPage().getModel();
                IBuild build = buildModel.getBuild();
                AddLibraryDialog dialog = new AddLibraryDialog(RuntimeInfoSection.this.getFormPage().getControl().getShell(), libNames, pluginModelBase);
                dialog.create();
                dialog.getShell().setText("Add Entry");
                dialog.getShell().setSize(300, 350);
                try {
                    if (dialog.open() == 0) {
                        String name = dialog.getNewName();
                        if (!name.endsWith(".jar")) {
                            name = String.valueOf(name) + ".jar";
                        }
                        if (!name.startsWith("source.")) {
                            name = "source." + name;
                        }
                        IBuildEntry library = buildModel.getFactory().createEntry(name);
                        build.add(library);
                        RuntimeInfoSection.this.libraryViewer.refresh();
                        RuntimeInfoSection.this.libraryViewer.setSelection((ISelection)new StructuredSelection((Object)library));
                        RuntimeInfoSection.this.jarIncludeButton.setSelection(true);
                        RuntimeInfoSection.this.handleLibInBinBuild(true);
                        if (RuntimeInfoSection.this.libraryViewer.getTable().getItemCount() > 1) {
                            RuntimeInfoSection.this.updateJarsCompileOrder(RuntimeInfoSection.this.libraryViewer.getTable().getItems());
                        }
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    private IPackageFragmentRoot getSourceFolder(String folderName, IPackageFragmentRoot[] sourceFolders) {
        int i = 0;
        while (i < sourceFolders.length) {
            if (sourceFolders[i].getPath().removeFirstSegments(1).equals((Object)new Path(folderName))) {
                return sourceFolders[i];
            }
            ++i;
        }
        return null;
    }

    protected void handleDelete() {
        int index = this.libraryViewer.getTable().getSelectionIndex();
        if (index != -1) {
            String libName = this.libraryViewer.getTable().getItem(index).getText();
            IBuild build = ((IBuildModel)this.getFormPage().getModel()).getBuild();
            try {
                IBuildEntry entry = build.getEntry("jars.compile.order");
                if (entry != null) {
                    entry.removeToken(libName);
                }
                if ((entry = build.getEntry("output." + libName)) != null) {
                    build.remove(entry);
                }
                if ((entry = build.getEntry("bin.includes")) != null && entry.contains(libName)) {
                    entry.removeToken(libName);
                }
                if ((entry = build.getEntry("bin.excludes")) != null && entry.contains(libName)) {
                    entry.removeToken(libName);
                }
                build.remove(build.getEntry("source." + libName));
                this.libraryViewer.refresh();
                int libCount = this.libraryViewer.getTable().getItemCount();
                libName = libCount > index ? this.libraryViewer.getElementAt(index).toString() : (libCount == index && libCount != 0 ? this.libraryViewer.getElementAt(index - 1).toString() : "");
                IBuildEntry selection = build.getEntry(libName);
                if (selection != null) {
                    this.libraryViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                } else {
                    this.getJarsTablePart().setButtonEnabled(0, false);
                    this.libraryViewer.setSelection(null);
                    this.foldersViewer.setInput(null);
                    this.jarIncludeButton.setVisible(false);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleJarsDelete() {
        IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();
        int index = this.foldersViewer.getTable().getSelectionIndex();
        Object object = ((IStructuredSelection)this.foldersViewer.getSelection()).getFirstElement();
        if (object != null && object instanceof String) {
            String libKey = this.currentLibrary.getName();
            IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
            if (entry != null) {
                try {
                    entry.removeToken(object.toString());
                    this.foldersViewer.remove(object);
                    String[] tokens = entry.getTokens();
                    if (tokens.length > index) {
                        this.foldersViewer.setSelection((ISelection)new StructuredSelection((Object)tokens[index]));
                    } else if (tokens.length != 0) {
                        this.foldersViewer.setSelection((ISelection)new StructuredSelection((Object)tokens[index - 1]));
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        }
    }

    private void handleJarsNew() {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        IFile file = (IFile)model.getUnderlyingResource();
        final IProject project = file.getProject();
        FolderSelectionDialog dialog = new FolderSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new JarsNewContentProvider(){});
        dialog.setInput(project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return element instanceof IFolder;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString("ManifestEditor.JarsSection.dialogTitle"));
        dialog.setMessage(PDEPlugin.getResourceString("ManifestEditor.JarsSection.dialogMessage"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length != 1 || !(selection[0] instanceof IFolder)) {
                    return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
                }
                IBuildModel buildModel = (IBuildModel)RuntimeInfoSection.this.getFormPage().getModel();
                String libKey = RuntimeInfoSection.this.currentLibrary.getName();
                IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
                String folderPath = ((IFolder)selection[0]).getProjectRelativePath().addTrailingSeparator().toString();
                if (entry != null && entry.contains(folderPath)) {
                    return new Status(4, PDEPlugin.getPluginId(), 4, PDEPlugin.getResourceString("BuildPropertiesEditor.RuntimeInfoSection.missingSource.duplicateFolder"), null);
                }
                return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            try {
                IFolder folder = (IFolder)dialog.getFirstResult();
                String folderPath = folder.getProjectRelativePath().addTrailingSeparator().toString();
                IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();
                String libKey = this.currentLibrary.getName();
                IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
                if (entry == null) {
                    entry = buildModel.getFactory().createEntry(libKey);
                    buildModel.getBuild().add(entry);
                }
                entry.addToken(folderPath);
                this.foldersViewer.refresh();
                this.foldersViewer.setSelection((ISelection)new StructuredSelection((Object)folderPath));
                this.refreshOutputKeys();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    protected void handleDown() {
        int index = this.libraryViewer.getTable().getSelectionIndex();
        Vector libElements = this.swapLibraries(index, index + 1);
        this.updateJarsCompileOrder(libElements.toArray(new IBuildEntry[libElements.size()]));
        this.libraryViewer.refresh();
        this.libraryViewer.setSelection((ISelection)new StructuredSelection(libElements.get(index + 1)));
        this.updateDirectionalButtons();
    }

    protected void handleUp() {
        int index = this.libraryViewer.getTable().getSelectionIndex();
        Vector libElements = this.swapLibraries(index, index - 1);
        this.updateJarsCompileOrder(libElements.toArray(new IBuildEntry[libElements.size()]));
        this.libraryViewer.refresh();
        this.libraryViewer.setSelection((ISelection)new StructuredSelection(libElements.get(index - 1)));
        this.updateDirectionalButtons();
    }

    protected Vector swapLibraries(int index_old, int index_new) {
        int i = 0;
        Vector<Object> libElements = new Vector<Object>();
        while (this.libraryViewer.getElementAt(i) != null) {
            libElements.add(this.libraryViewer.getElementAt(i));
            ++i;
        }
        IBuildEntry tempLib_curr = (IBuildEntry)libElements.elementAt(index_old);
        IBuildEntry tempLib_prev = (IBuildEntry)libElements.elementAt(index_new);
        libElements.setElementAt(tempLib_prev, index_old);
        libElements.setElementAt(tempLib_curr, index_new);
        return libElements;
    }

    public void updateJarsCompileOrder(IBuildEntry[] libraries) {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        IBuild build = model.getBuild();
        IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
        try {
            if (jarOrderEntry != null) {
                build.remove(jarOrderEntry);
            }
            jarOrderEntry = model.getFactory().createEntry("jars.compile.order");
            int i = 0;
            while (i < libraries.length) {
                jarOrderEntry.addToken(libraries[i].getName().substring(7));
                ++i;
            }
            build.add(jarOrderEntry);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void updateJarsCompileOrder(TableItem[] libraries) {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        IBuild build = model.getBuild();
        IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
        try {
            if (jarOrderEntry != null) {
                build.remove(jarOrderEntry);
            }
            jarOrderEntry = model.getFactory().createEntry("jars.compile.order");
            int i = 0;
            while (i < libraries.length) {
                jarOrderEntry.addToken(libraries[i].getText());
                ++i;
            }
            build.add(jarOrderEntry);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    class RenameAction
    extends Action {
        public RenameAction() {
            super(PDEPlugin.getResourceString("EditableTablePart.renameAction"));
        }

        public void run() {
            RuntimeInfoSection.this.doRename();
        }
    }

    class PartAdapter
    extends EditableTablePart {
        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        public void entryModified(Object entry, String value) {
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.size() != 0) {
                RuntimeInfoSection.this.selectionChanged(selection);
            }
        }

        public void handleDoubleClick(IStructuredSelection selection) {
            RuntimeInfoSection.this.handleDoubleClick(selection);
        }

        public void buttonSelected(Button button, int index) {
            if (this.getViewer() == RuntimeInfoSection.this.libraryPart.getViewer()) {
                switch (index) {
                    case 0: {
                        RuntimeInfoSection.this.handleNew();
                        break;
                    }
                    case 2: {
                        RuntimeInfoSection.this.handleUp();
                        break;
                    }
                    case 3: {
                        RuntimeInfoSection.this.handleDown();
                    }
                }
            } else if (this.getViewer() == RuntimeInfoSection.this.foldersPart.getViewer()) {
                if (index == 0) {
                    RuntimeInfoSection.this.handleJarsNew();
                }
            } else {
                button.getShell().setDefaultButton(null);
            }
        }
    }

    public class LibTableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildModel) {
                IBuild build = ((IBuildModel)parent).getBuild();
                IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
                Object[] libraries = BuildUtil.getBuildLibraries(build.getBuildEntries());
                if (jarOrderEntry == null) {
                    return libraries;
                }
                Vector<Object> libList = new Vector<Object>();
                String[] tokens = jarOrderEntry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    IBuildEntry entry = build.getEntry("source." + tokens[i]);
                    if (entry != null) {
                        libList.add(entry);
                    }
                    ++i;
                }
                i = 0;
                while (i < libraries.length) {
                    if (!libList.contains(libraries[i])) {
                        libList.add(libraries[i]);
                    }
                    ++i;
                }
                return libList.toArray(new IBuildEntry[libList.size()]);
            }
            return new Object[0];
        }
    }

    public class LibTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (obj.toString().startsWith("source.")) {
                return obj.toString().substring(7);
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return RuntimeInfoSection.this.libImage;
        }
    }

    class JarsNewContentProvider
    extends WorkbenchContentProvider {
        JarsNewContentProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFolder) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public class JarsTableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            IBuildModel buildModel;
            IBuild build;
            IBuildEntry entry;
            if (parent instanceof IBuildEntry && (entry = (build = (buildModel = (IBuildModel)RuntimeInfoSection.this.getFormPage().getModel()).getBuild()).getEntry(((IBuildEntry)parent).getName())) != null) {
                return entry.getTokens();
            }
            return new Object[0];
        }
    }

    public class JarsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return RuntimeInfoSection.this.jarsImage;
        }
    }
}

