/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class JARFileFilter
extends ViewerFilter {
    private static final String jarExt = "jar";

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return this.isJarPath(((IFile)element).getFullPath());
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        return false;
    }

    public boolean isJarPath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            return ext.equals(jarExt);
        }
        return false;
    }
}

