/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.ExternalBuildModel;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.build.BuildUtil;
import org.eclipse.pde.internal.ui.preferences.EditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class BuildPropertiesEditor
extends PDEMultiPageEditor {
    public static final String BUILD_PAGE_TITLE = "BuildPropertiesEditor.BuildPage.title";
    public static final String BUILD_PAGE = "BuildPage";
    public static final String SOURCE_PAGE = "SourcePage";

    protected Object createModel(Object input) throws CoreException {
        if (input instanceof IFile) {
            return this.createResourceModel((IFile)input);
        }
        if (input instanceof IStorage) {
            return this.createStorageModel((IStorage)input);
        }
        return null;
    }

    protected void createPages() {
        this.addPage(SOURCE_PAGE, new BuildSourcePage(this));
    }

    private IBuildModel createResourceModel(IFile file) throws CoreException {
        InputStream stream = file.getContents(false);
        WorkspaceBuildModel model = new WorkspaceBuildModel(file);
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    private IBuildModel createStorageModel(IStorage storage) throws CoreException {
        InputStream stream = null;
        stream = storage.getContents();
        ExternalBuildModel model = new ExternalBuildModel("");
        model.load(stream, false);
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    public void dispose() {
        super.dispose();
        IModel model = (IModel)this.getModel();
        model.dispose();
    }

    public IPDEEditorPage getHomePage() {
        if (this.model instanceof ExternalBuildModel) {
            return this.getPage(SOURCE_PAGE);
        }
        return this.getPage(BUILD_PAGE);
    }

    protected String getSourcePageId() {
        return SOURCE_PAGE;
    }

    public void createPartControl(Composite parent) {
        if (this.model instanceof WorkspaceBuildModel) {
            this.firstPageId = BUILD_PAGE;
            this.formWorkbook.setFirstPageSelected(false);
            BuildPage buildPage = new BuildPage(this, PDEPlugin.getResourceString(BUILD_PAGE_TITLE));
            this.addPage(BUILD_PAGE, buildPage, 0);
        }
        super.createPartControl(parent);
        if (this.model instanceof ExternalBuildModel) {
            this.firstPageId = SOURCE_PAGE;
            this.showPage(SOURCE_PAGE);
        }
    }

    public void openTo(Object obj, IMarker marker) {
        if (EditorPreferencePage.getUseSourcePage() || this.model instanceof ExternalBuildModel) {
            PDESourcePage sourcePage = (PDESourcePage)this.showPage(this.getSourcePageId());
            if (marker != null) {
                sourcePage.openTo(marker);
            }
        } else {
            IPDEEditorPage page = this.getPageFor(obj);
            if (page != null) {
                this.showPage(page);
                page.openTo(obj);
            }
        }
    }

    public String getTitle() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            return ((IStorageEditorInput)input).getName();
        }
        return super.getTitle();
    }

    protected boolean isModelDirty(Object model) {
        return model != null && model instanceof IEditable && model instanceof IModel && ((IEditable)model).isDirty();
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        return name.equals("build.properties") || name.equals("delta.properties");
    }

    protected boolean updateModel() {
        IBuildModel model = (IBuildModel)this.getModel();
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        boolean cleanModel = true;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
                if (model instanceof IEditable) {
                    ((IEditable)model).setDirty(false);
                    this.fireSaveNeeded();
                }
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isJavaProject() && PDEPlugin.isBuildPropertiesUpdate() && this.hasPluginModel()) {
            this.validateSourceFolders(monitor);
        }
        super.doSave(monitor);
    }

    private boolean hasPluginModel() {
        IBuildModel buildModel = (IBuildModel)this.getModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        IModel pluginModel = PDECore.getDefault().getWorkspaceModelManager().getWorkspaceModel(project);
        return pluginModel instanceof IPluginModelBase;
    }

    private void validateSourceFolders(IProgressMonitor monitor) {
        String[] folders = this.getFolderNames();
        if (folders.length > 0) {
            IPackageFragmentRoot[] sourceFolders = this.computeSourceFolders();
            if (sourceFolders.length == 0) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < folders.length) {
                if (this.getSourceFolder(folders[i], sourceFolders) == null) {
                    list.add(folders[i]);
                }
                ++i;
            }
            if (list.size() > 0) {
                this.convertToSourceFolders(list, monitor);
            }
        }
    }

    private String[] getFolderNames() {
        ArrayList<String> folderNames = new ArrayList<String>();
        IBuildModel buildModel = (IBuildModel)this.getModel();
        IBuildEntry[] entries = BuildUtil.getBuildLibraries(buildModel.getBuild().getBuildEntries());
        int i = 0;
        while (i < entries.length) {
            String[] tokens = entries[i].getTokens();
            int j = 0;
            while (j < tokens.length) {
                if (!folderNames.contains(tokens[j])) {
                    folderNames.add(tokens[j]);
                }
                ++j;
            }
            ++i;
        }
        return folderNames.toArray(new String[folderNames.size()]);
    }

    private void convertToSourceFolders(ArrayList folders, IProgressMonitor monitor) {
        Vector newSrcEntries = this.getNewSourceFolderEntries(folders);
        this.handleNewClasspathEntries(newSrcEntries, monitor);
    }

    private void handleNewClasspathEntries(Vector newSrcEntries, IProgressMonitor monitor) {
        IBuildModel buildModel = (IBuildModel)this.getModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (newSrcEntries.size() == 0) {
            return;
        }
        try {
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + newSrcEntries.size()];
            int i = 0;
            while (i < newSrcEntries.size()) {
                newEntries[i] = (IClasspathEntry)newSrcEntries.elementAt(i);
                ++i;
            }
            System.arraycopy(oldEntries, 0, newEntries, newSrcEntries.size(), oldEntries.length);
            monitor.setTaskName("");
            javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    private Vector getNewSourceFolderEntries(ArrayList folders) {
        Vector<IClasspathEntry> newSrcEntries = new Vector<IClasspathEntry>();
        IBuildModel buildModel = (IBuildModel)this.getModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        int i = 0;
        while (i < folders.size()) {
            String folderName = folders.get(i).toString();
            IPath path = project.getFullPath().append(folderName);
            IFolder folder = project.getWorkspace().getRoot().getFolder(path);
            if (folder.exists()) {
                newSrcEntries.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
            }
            ++i;
        }
        return newSrcEntries;
    }

    private IPackageFragmentRoot[] computeSourceFolders() {
        ArrayList<IPackageFragmentRoot> folders = new ArrayList<IPackageFragmentRoot>();
        IBuildModel buildModel = (IBuildModel)this.getModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        folders.add(roots[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return folders.toArray(new IPackageFragmentRoot[folders.size()]);
    }

    private IPackageFragmentRoot getSourceFolder(String folderName, IPackageFragmentRoot[] sourceFolders) {
        int i = 0;
        while (i < sourceFolders.length) {
            if (sourceFolders[i].getPath().removeFirstSegments(1).equals((Object)new Path(folderName))) {
                return sourceFolders[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isJavaProject() {
        try {
            IBuildModel buildModel = (IBuildModel)this.getModel();
            IProject project = buildModel.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

