/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.build.BinSection;
import org.eclipse.pde.internal.ui.editor.build.BuildClasspathSection;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.RuntimeInfoSection;
import org.eclipse.pde.internal.ui.editor.build.SrcSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public class BuildForm
extends ScrollableSectionForm {
    public static final String FORM_TITLE = "BuildEditor.Form.title";
    private BuildPage page;
    private BuildClasspathSection classpathSection;
    private BuildContentsSection srcSection;
    private BuildContentsSection binSection;
    private RuntimeInfoSection runtimeSection;
    private Button customButton;

    public BuildForm(BuildPage page) {
        this.page = page;
        this.setScrollable(true);
        this.setVerticalFit(true);
    }

    protected void createFormClient(Composite parent) {
        FormWidgetFactory factory = this.getFactory();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 10;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        this.customButton = factory.createButton(parent, this.getCustomText(), 32);
        this.customButton.setAlignment(16384);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.customButton.setLayoutData((Object)gd);
        Label label = new Label(parent, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        label.setBackground(parent.getBackground());
        label.setLayoutData((Object)gd);
        this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isCustom = BuildForm.this.customButton.getSelection();
                IBuildEntry customEntry = BuildForm.this.getCustomBuildEntry();
                BuildForm.this.setCustomEntryValue(customEntry, isCustom);
                BuildForm.this.handleCustomCheckState(isCustom);
            }
        });
        this.runtimeSection = new RuntimeInfoSection(this.page);
        Control control = this.runtimeSection.createControl(parent, factory);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        control.setLayoutData((Object)gd);
        this.runtimeSection.setSectionControl(control);
        this.binSection = new BinSection(this.page);
        control = this.binSection.createControl(parent, factory);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.binSection.setSectionControl(control);
        this.srcSection = new SrcSection(this.page);
        control = this.srcSection.createControl(parent, factory);
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        this.srcSection.setSectionControl(control);
        this.classpathSection = new BuildClasspathSection(this.page);
        control = this.classpathSection.createControl(parent, factory);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 100;
        gd.heightHint = 100;
        control.setLayoutData((Object)gd);
        this.classpathSection.setSectionControl(control);
        this.registerSection(this.runtimeSection);
        this.registerSection(this.srcSection);
        this.registerSection(this.binSection);
        this.registerSection(this.classpathSection);
        this.handleCustomCheckState(this.getCustomSelection());
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.build_page");
    }

    private IBuildEntry getCustomBuildEntry() {
        IBuildModel buildModel = (IBuildModel)this.page.getModel();
        IBuildEntry customEntry = buildModel.getBuild().getEntry("custom");
        if (customEntry != null) {
            return customEntry;
        }
        try {
            customEntry = buildModel.getFactory().createEntry("custom");
            buildModel.getBuild().add(customEntry);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return customEntry;
    }

    public void dispose() {
        if (this.runtimeSection != null) {
            this.unregisterSection(this.runtimeSection);
            this.runtimeSection.dispose();
        }
        if (this.srcSection != null) {
            this.unregisterSection(this.srcSection);
            this.srcSection.dispose();
        }
        if (this.binSection != null) {
            this.unregisterSection(this.binSection);
            this.binSection.dispose();
        }
        if (this.classpathSection != null) {
            this.unregisterSection(this.classpathSection);
            this.classpathSection.dispose();
        }
    }

    private boolean getCustomSelection() {
        IBuildModel model = (IBuildModel)this.page.getModel();
        IBuild build = model.getBuild();
        IBuildEntry customEntry = build.getEntry("custom");
        if (customEntry == null || customEntry.getTokens().length == 0) {
            return false;
        }
        return customEntry.getTokens()[0].equals("true");
    }

    private void handleCustomCheckState(boolean isCustom) {
        if (isCustom) {
            this.disableAllSections();
        } else {
            this.enableAllSections();
        }
    }

    public void initialize(Object modelObject) {
        IBuildModel model = (IBuildModel)modelObject;
        super.initialize((Object)model);
        this.setHeadingText(this.getText());
        ((Composite)this.getControl()).layout(true);
    }

    public void disableAllSections() {
        this.customButton.setSelection(true);
        this.runtimeSection.disableSection();
        this.binSection.disableSection();
        this.srcSection.disableSection();
        this.classpathSection.disableSection();
    }

    public void enableAllSections() {
        this.customButton.setSelection(false);
        this.runtimeSection.enableSection();
        this.binSection.enableSection();
        this.srcSection.enableSection();
        this.classpathSection.enableSection();
    }

    private void setCustomEntryValue(IBuildEntry customEntry, boolean isCustom) {
        String[] tokens = customEntry.getTokens();
        try {
            if (tokens.length != 0) {
                int i = 0;
                while (i < tokens.length) {
                    customEntry.removeToken(tokens[i]);
                    ++i;
                }
            }
            customEntry.addToken(isCustom ? "true" : "false");
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void setFocus() {
    }

    private String getText() {
        return "Build Configuration";
    }

    private String getCustomText() {
        IBuildModel buildModel = (IBuildModel)this.page.getModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        IModel model = PDECore.getDefault().getWorkspaceModelManager().getWorkspaceModel(project);
        if (model instanceof IFeatureModel) {
            return PDEPlugin.getResourceString("BuildPropertiesEditor.Custom.feature");
        }
        if (model instanceof IPluginModel) {
            return PDEPlugin.getResourceString("BuildPropertiesEditor.Custom.plugin");
        }
        return PDEPlugin.getResourceString("BuildPropertiesEditor.Custom.fragment");
    }
}

