/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildUtil;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public abstract class BuildContentsSection
extends TableSection
implements IModelChangedListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    protected CheckboxTreeViewer treeViewer;
    private boolean doRefresh = false;
    protected Control sectionControl;
    protected IProject project;
    protected IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();

    public BuildContentsSection(BuildPage page) {
        super(page, new String[0]);
        if (this.buildModel.getUnderlyingResource() != null) {
            this.project = this.buildModel.getUnderlyingResource().getProject();
        }
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public Composite createClient(final Composite parent, FormWidgetFactory factory) {
        Composite container = this.createClientContainer(parent, 2, factory);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        this.treeViewer = new CheckboxTreeViewer(this.createTree(container, factory));
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setAutoExpandLevel(0);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(this, element, event){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Object val$element;
                    private final /* synthetic */ CheckStateChangedEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$element = object;
                        this.val$event = checkStateChangedEvent;
                    }

                    public void run() {
                        if (this.val$element instanceof IFile) {
                            IFile file = (IFile)this.val$event.getElement();
                            1.access$0(this.this$1).handleCheckStateChanged((IResource)file, this.val$event.getChecked());
                        } else if (this.val$element instanceof IFolder) {
                            IFolder folder = (IFolder)this.val$event.getElement();
                            1.access$0(this.this$1).handleCheckStateChanged((IResource)folder, this.val$event.getChecked());
                        }
                    }
                });
            }

            static /* synthetic */ BuildContentsSection access$0(1 var0) {
                return var0.BuildContentsSection.this;
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 100;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.initialize();
        this.initializeCheckState();
        factory.paintBordersFor(container);
        return container;
    }

    private Tree createTree(Composite parent, FormWidgetFactory factory) {
        Tree tree = new Tree(parent, 32);
        tree.setBackground(factory.getBackgroundColor());
        tree.setForeground(factory.getForegroundColor());
        factory.hookDeleteListener((Control)tree);
        return tree;
    }

    public void disableSection() {
        this.treeViewer.getTree().setEnabled(false);
        if (this.getSectionControl() != null) {
            this.getSectionControl().setEnabled(false);
        }
    }

    public void enableSection() {
        this.treeViewer.getTree().setEnabled(true);
        if (this.getSectionControl() != null) {
            this.getSectionControl().setEnabled(true);
        }
    }

    protected void handleCheckStateChanged(IResource resource, boolean checked) {
        this.treeViewer.setChecked((Object)resource, checked);
        this.treeViewer.setParentsGrayed((Object)resource, true);
        this.treeViewer.setGrayed((Object)resource, false);
        boolean wasTopParentChecked = this.treeViewer.getChecked((Object)resource.getParent());
        if (checked) {
            this.setParentsChecked(resource);
        } else {
            resource = this.handleAllUnselected(resource);
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            this.treeViewer.setSubtreeChecked((Object)folder, checked);
            this.setChildrenGrayed((IResource)folder, false);
            this.handleBuildCheckStateChange((IResource)folder, checked, wasTopParentChecked);
        } else {
            this.handleBuildCheckStateChange(resource, checked, wasTopParentChecked);
        }
    }

    protected IResource handleAllUnselected(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent == resource.getProject()) {
            return resource;
        }
        try {
            boolean uncheck = true;
            IResource[] members = ((IFolder)parent).members();
            int i = 0;
            while (i < members.length) {
                if (this.treeViewer.getChecked((Object)members[i])) {
                    uncheck = false;
                }
                ++i;
            }
            if (uncheck) {
                this.treeViewer.setChecked((Object)parent, false);
                return this.handleAllUnselected((IResource)parent);
            }
            return resource;
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
    }

    protected void setChildrenGrayed(IResource folder, boolean isGray) {
        this.treeViewer.setGrayed((Object)folder, isGray);
        if (((TreeContentProvider)this.treeViewer.getContentProvider()).hasChildren(folder)) {
            Object[] members = ((TreeContentProvider)this.treeViewer.getContentProvider()).getFolderChildren(folder);
            int i = 0;
            while (i < members.length) {
                this.setChildrenGrayed((IResource)((IFolder)members[i]), isGray);
                ++i;
            }
        }
    }

    protected void setParentsChecked(IResource resource) {
        if (resource.getParent() != resource.getProject()) {
            this.treeViewer.setChecked((Object)resource.getParent(), true);
            this.setParentsChecked((IResource)resource.getParent());
        }
    }

    protected abstract void deleteFolderChildrenFromEntries(IFolder var1);

    protected void initializeCheckState() {
        this.uncheckAll();
    }

    protected void initializeCheckState(IBuildEntry includes, IBuildEntry excludes) {
        Vector<String> fileExt = new Vector<String>();
        String[] exclTokens = new String[]{};
        if (this.project == null || includes == null) {
            return;
        }
        String[] inclTokens = includes.getTokens();
        if (excludes != null) {
            exclTokens = excludes.getTokens();
        }
        TreeSet<String> temp = new TreeSet<String>();
        int i = 0;
        while (i < inclTokens.length) {
            temp.add(inclTokens[i]);
            ++i;
        }
        i = 0;
        while (i < exclTokens.length) {
            temp.add(exclTokens[i]);
            ++i;
        }
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            String resource = iter.next().toString();
            boolean isIncluded = includes.contains(resource);
            if (resource.lastIndexOf(47) == resource.length() - 1) {
                IFolder folder = this.project.getFolder(resource);
                this.treeViewer.setSubtreeChecked((Object)folder, isIncluded);
                this.treeViewer.setParentsGrayed((Object)folder, true);
                if (!isIncluded || !folder.exists()) continue;
                this.setParentsChecked((IResource)folder);
                this.treeViewer.setGrayed((Object)folder, false);
                continue;
            }
            if (resource.startsWith("*.")) {
                if (!isIncluded) continue;
                fileExt.add(resource.substring(2));
                continue;
            }
            IFile file = this.project.getFile(resource);
            this.treeViewer.setChecked((Object)file, isIncluded);
            this.treeViewer.setParentsGrayed((Object)file, true);
            if (!isIncluded || !file.exists()) continue;
            this.treeViewer.setGrayed((Object)file, false);
            this.setParentsChecked((IResource)file);
        }
        if (fileExt.size() == 0) {
            return;
        }
        try {
            IResource[] members = this.project.members();
            int i2 = 0;
            while (i2 < members.length) {
                if (!(members[i2] instanceof IFolder) && fileExt.contains(members[i2].getFileExtension())) {
                    this.treeViewer.setChecked((Object)((IFile)members[i2]), includes.contains("*." + members[i2].getFileExtension()));
                }
                ++i2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected abstract void handleBuildCheckStateChange(IResource var1, boolean var2, boolean var3);

    protected void handleCheck(IBuildEntry includes, IBuildEntry excludes, String resourceName, IResource resource, boolean wasTopParentChecked, String PROPERTY_INCLUDES) {
        try {
            if (includes == null) {
                includes = this.buildModel.getFactory().createEntry(PROPERTY_INCLUDES);
                IBuild build = this.buildModel.getBuild();
                build.add(includes);
            }
            if (!wasTopParentChecked && !includes.contains(resourceName) || this.isValidIncludeEntry(includes, excludes, resource, resourceName)) {
                includes.addToken(resourceName);
            }
            if (excludes != null && excludes.contains(resourceName)) {
                excludes.removeToken(resourceName);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean isValidIncludeEntry(IBuildEntry includes, IBuildEntry excludes, IResource resource, String resourceName) {
        if (excludes == null) {
            return true;
        }
        IPath resPath = resource.getProjectRelativePath();
        while (resPath.segmentCount() > 1) {
            if (includes.contains(String.valueOf((resPath = resPath.removeLastSegments(1)).toString()) + '/')) {
                return false;
            }
            if (excludes == null || !excludes.contains(String.valueOf(resPath.toString()) + '/')) continue;
            return true;
        }
        return !excludes.contains(resourceName);
    }

    protected void handleUncheck(IBuildEntry includes, IBuildEntry excludes, String resourceName, IResource resource, String PROPERTY_EXCLUDES) {
        try {
            if (this.treeViewer.getChecked((Object)resource.getParent())) {
                if (excludes == null) {
                    excludes = this.buildModel.getFactory().createEntry(PROPERTY_EXCLUDES);
                    IBuild build = this.buildModel.getBuild();
                    build.add(excludes);
                }
                if (!(excludes.contains(resourceName) || includes != null && includes.contains(resourceName))) {
                    excludes.addToken(resourceName);
                }
            }
            if (includes != null) {
                if (includes.contains(resourceName)) {
                    includes.removeToken(resourceName);
                }
                if (includes.contains("*." + resource.getFileExtension())) {
                    IResource[] members = this.project.members();
                    int i = 0;
                    while (i < members.length) {
                        if (!(members[i] instanceof IFolder) && !members[i].getName().equals(resource.getName()) && resource.getFileExtension().equals(members[i].getFileExtension())) {
                            includes.addToken(members[i].getName());
                        }
                        IBuildEntry[] libraries = BuildUtil.getBuildLibraries(this.buildModel.getBuild().getBuildEntries());
                        if (resource.getFileExtension().equals("jar") && libraries.length != 0) {
                            int j = 0;
                            while (j < libraries.length) {
                                String libName = libraries[j].getName().substring(7);
                                IPath path = this.project.getFile(libName).getProjectRelativePath();
                                if (path.segmentCount() == 1 && !includes.contains(libName) && !libName.equals(resource.getName())) {
                                    includes.addToken(libName);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    includes.removeToken("*." + resource.getFileExtension());
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected String getResourceFolderName(String resourceName) {
        return String.valueOf(resourceName) + '/';
    }

    protected String handleResourceFolder(IResource resource, String resourceName) {
        if (resource instanceof IFolder) {
            this.deleteFolderChildrenFromEntries((IFolder)resource);
            return this.getResourceFolderName(resourceName);
        }
        return resourceName;
    }

    public void initialize() {
        if (this.treeViewer.getInput() == null) {
            this.treeViewer.setUseHashlookup(true);
            this.treeViewer.setInput((Object)this.project);
        }
        this.buildModel.addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        this.buildModel.removeModelChangedListener((IModelChangedListener)this);
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected void deleteEmptyEntries() {
        IBuild build = this.buildModel.getBuild();
        IBuildEntry[] entries = new IBuildEntry[]{build.getEntry("bin.excludes"), build.getEntry("bin.includes"), build.getEntry("src.excludes"), build.getEntry("src.includes")};
        try {
            int i = 0;
            while (i < entries.length) {
                if (entries[i] != null && entries[i].getTokens().length == 0) {
                    build.remove(entries[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setSectionControl(Control control) {
        this.sectionControl = control;
    }

    public Control getSectionControl() {
        return this.sectionControl;
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.initializeCheckState();
        }
    }

    public void uncheckAll() {
        this.treeViewer.setCheckedElements(new Object[0]);
    }

    protected void removeChildren(IBuildEntry entry, String parentFolder) {
        try {
            if (entry != null) {
                String[] tokens = entry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].indexOf(47) != -1 && tokens[i].startsWith(parentFolder) && !tokens[i].equals(parentFolder)) {
                        entry.removeToken(tokens[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.doRefresh = false;
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
            if (this.doRefresh) {
                this.asyncRefresh();
                this.doRefresh = false;
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if ((resource instanceof IFile || resource instanceof IFolder) && resource.getProject().equals((Object)this.buildModel.getUnderlyingResource().getProject()) && (delta.getKind() == 1 || delta.getKind() == 2)) {
            this.doRefresh = true;
            return false;
        }
        return true;
    }

    private void asyncRefresh() {
        if (!this.getSectionControl().isDisposed()) {
            this.getSectionControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BuildContentsSection.this.treeViewer.getControl().isDisposed()) {
                        BuildContentsSection.this.treeViewer.refresh(true);
                        BuildContentsSection.this.initializeCheckState();
                    }
                }
            });
        }
    }

    public class TreeContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object parent) {
            if (parent instanceof IProject) {
                try {
                    return ((IProject)parent).members();
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parent) {
            try {
                if (parent instanceof IFolder) {
                    return ((IFolder)parent).members();
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            return new Object[0];
        }

        public Object[] getFolderChildren(Object parent) {
            IResource[] members = null;
            try {
                if (!(parent instanceof IFolder)) {
                    return new Object[0];
                }
                members = ((IFolder)parent).members();
                ArrayList<IResource> results = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    if (members[i].getType() == 2) {
                        results.add(members[i]);
                    }
                    ++i;
                }
                return results.toArray();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                return new Object[0];
            }
        }

        public Object getParent(Object element) {
            if (element != null && element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFolder) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }
    }
}

