/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.JARFileFilter;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class BuildClasspathSection
extends TableSection
implements IModelChangedListener {
    private static final String SECTION_ADD = "BuildPropertiesEditor.BuildClasspathSection.add";
    private static final String SECTION_REMOVE = "BuildPropertiesEditor.BuildClasspathSection.remove";
    private static final String SECTION_TITLE = "BuildPropertiesEditor.BuildClasspathSection.title";
    private static final String SECTION_DESC = "BuildPropertiesEditor.BuildClasspathSection.desc";
    private static final String POPUP_NEW = "BuildPropertiesEditor.BuildClasspathSection.popupAdd";
    private static final String POPUP_DELETE = "BuildPropertiesEditor.BuildClasspathSection.popupDelete";
    protected IBuildModel buildModel;
    private TableViewer entryTable;
    private Image entryImage;
    protected Control sectionControl;
    private static RGB LIGHT_GRAY = new RGB(172, 168, 153);
    private static RGB BLACK = new RGB(0, 0, 0);
    static /* synthetic */ Class class$0;

    public BuildClasspathSection(PDEFormPage page) {
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString(SECTION_ADD);
        stringArray[1] = PDEPlugin.getResourceString(SECTION_REMOVE);
        super(page, stringArray);
        this.buildModel = (IBuildModel)this.getFormPage().getModel();
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.setCollapsable(true);
        this.initialize();
    }

    public void initialize() {
        this.buildModel.addModelChangedListener((IModelChangedListener)this);
        IBuildEntry entry = this.buildModel.getBuild().getEntry("jars.extra.classpath");
        this.setCollapsed(entry == null || entry.getTokens().length == 0);
    }

    private void initializeImages() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.entryImage = sharedImages.getImage("IMG_OBJ_FILE");
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.initializeImages();
        Composite container = this.createClientContainer(parent, 2, factory);
        this.createViewerPartControl(container, 65536, 2, factory);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(true);
        this.entryTable = tablePart.getTableViewer();
        this.entryTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.entryTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.enableSection();
        factory.paintBordersFor(container);
        this.entryTable.setInput((Object)this.buildModel);
        return container;
    }

    public void disableSection() {
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(1, false);
        tablePart.setButtonEnabled(0, false);
        tablePart.getTableViewer().setSelection(null, false);
        tablePart.getControl().setForeground(new Color((Device)tablePart.getControl().getDisplay(), LIGHT_GRAY));
        if (this.getSectionControl() != null) {
            this.getSectionControl().setEnabled(false);
        }
    }

    public void setSectionControl(Control control) {
        this.sectionControl = control;
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.entryTable.getSelection();
        Action action = new Action(PDEPlugin.getResourceString(POPUP_NEW)){

            public void run() {
                BuildClasspathSection.this.handleNew();
            }
        };
        action.setEnabled(true);
        manager.add((IAction)action);
        manager.add((IContributionItem)new Separator());
        action = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

            public void run() {
                BuildClasspathSection.this.handleDelete();
            }
        };
        action.setEnabled(!selection.isEmpty());
        manager.add((IAction)action);
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    public Control getSectionControl() {
        return this.sectionControl;
    }

    public void dispose() {
        this.buildModel.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.entryTable.refresh();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    public void enableSection() {
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(1, false);
        tablePart.setButtonEnabled(0, true);
        tablePart.getTableViewer().setSelection(null, false);
        tablePart.getControl().setForeground(new Color((Device)tablePart.getControl().getDisplay(), BLACK));
        if (this.getSectionControl() != null) {
            this.getSectionControl().setEnabled(true);
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return;
        }
        this.updateRemoveStatus();
    }

    public void updateRemoveStatus() {
        Table table = this.entryTable.getTable();
        this.getTablePart().setButtonEnabled(1, table.getSelection().length > 0);
    }

    private void handleDelete() {
        IBuildEntry entry;
        Object selection = ((IStructuredSelection)this.entryTable.getSelection()).getFirstElement();
        int index = this.entryTable.getTable().getSelectionIndex();
        if (selection != null && selection instanceof String && (entry = this.buildModel.getBuild().getEntry("jars.extra.classpath")) != null) {
            try {
                entry.removeToken(selection.toString());
                this.entryTable.remove(selection);
                String[] tokens = entry.getTokens();
                if (tokens.length == 0) {
                    this.buildModel.getBuild().remove(entry);
                } else if (tokens.length > index) {
                    this.entryTable.setSelection((ISelection)new StructuredSelection((Object)tokens[index]));
                } else {
                    this.entryTable.setSelection((ISelection)new StructuredSelection((Object)tokens[index - 1]));
                }
                this.updateRemoveStatus();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void initializeDialogSettings(ElementTreeSelectionDialog dialog) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IFile;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        dialog.setValidator((ISelectionStatusValidator)new ElementSelectionValidator(acceptedClasses, true));
        dialog.setTitle(PDEPlugin.getResourceString("BuildPropertiesEditor.BuildClasspathSection.JarsSelection.title"));
        dialog.setMessage(PDEPlugin.getResourceString("BuildPropertiesEditor.BuildClasspathSection.JarsSelection.desc"));
        dialog.addFilter((ViewerFilter)new JARFileFilter());
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelection((Object)this.buildModel.getUnderlyingResource().getProject());
    }

    private void handleNew() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getFormPage().getControl().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.initializeDialogSettings(dialog);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i = 0;
            while (i < elements.length) {
                IResource elem = (IResource)elements[i];
                String tokenName = this.getRelativePathTokenName(elem);
                this.addClasspathToken(tokenName);
                this.entryTable.refresh();
                this.entryTable.setSelection((ISelection)new StructuredSelection((Object)tokenName));
                ++i;
            }
        }
    }

    private void addClasspathToken(String tokenName) {
        IBuildEntry entry = this.buildModel.getBuild().getEntry("jars.extra.classpath");
        try {
            if (entry == null) {
                entry = this.buildModel.getFactory().createEntry("jars.extra.classpath");
                this.buildModel.getBuild().add(entry);
            }
            if (!entry.contains(tokenName)) {
                entry.addToken(tokenName);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private String getRelativePathTokenName(IResource elem) {
        IPath projectPath;
        IPath path = elem.getFullPath();
        int sameSegments = path.matchingFirstSegments(projectPath = this.buildModel.getUnderlyingResource().getProject().getFullPath());
        if (sameSegments > 0) {
            return path.removeFirstSegments(sameSegments).toString();
        }
        return ".." + path.toString();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                this.entryTable.refresh();
                break;
            }
            case 1: {
                this.handleDelete();
                this.entryTable.refresh();
                break;
            }
        }
    }

    class ElementSelectionValidator
    implements ISelectionStatusValidator {
        private Class[] fAcceptedTypes;
        private boolean fAllowMultipleSelection;

        public ElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
            Assert.isNotNull((Object)acceptedTypes);
            this.fAcceptedTypes = acceptedTypes;
            this.fAllowMultipleSelection = allowMultipleSelection;
        }

        public IStatus validate(Object[] elements) {
            if (this.isValid(elements)) {
                return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
            }
            return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
        }

        private boolean isOfAcceptedType(Object o) {
            int i = 0;
            while (i < this.fAcceptedTypes.length) {
                if (this.fAcceptedTypes[i].isInstance(o)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isValid(Object[] selection) {
            if (selection.length == 0) {
                return false;
            }
            if (!this.fAllowMultipleSelection && selection.length != 1) {
                return false;
            }
            int i = 0;
            while (i < selection.length) {
                Object o = selection[i];
                if (!this.isOfAcceptedType(o)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IBuild build;
            IBuildEntry entry;
            if (parent instanceof IBuildModel && (entry = (build = ((IBuildModel)parent).getBuild()).getEntry("jars.extra.classpath")) != null) {
                return entry.getTokens();
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return BuildClasspathSection.this.entryImage;
        }
    }
}

