/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;

public class BinSection
extends BuildContentsSection
implements IModelChangedListener {
    private static String SECTION_TITLE = "BuildPropertiesEditor.BinSection.title";
    private static String SECTION_DESC = "BuildPropertiesEditor.BinSection.desc";

    public BinSection(BuildPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    protected void initializeCheckState() {
        super.initializeCheckState();
        IBuild build = this.buildModel.getBuild();
        IBuildEntry binIncl = build.getEntry("bin.includes");
        IBuildEntry binExcl = build.getEntry("bin.excludes");
        if (binIncl == null) {
            return;
        }
        super.initializeCheckState(binIncl, binExcl);
    }

    protected void deleteFolderChildrenFromEntries(IFolder folder) {
        IBuild build = this.buildModel.getBuild();
        IBuildEntry binIncl = build.getEntry("bin.includes");
        IBuildEntry binExcl = build.getEntry("bin.excludes");
        String parentFolder = this.getResourceFolderName(folder.getProjectRelativePath().toString());
        this.removeChildren(binIncl, parentFolder);
        this.removeChildren(binExcl, parentFolder);
    }

    protected void handleBuildCheckStateChange(IResource resource, boolean checked, boolean wasTopParentChecked) {
        String resourceName = resource.getFullPath().removeFirstSegments(1).toString();
        IBuild build = this.buildModel.getBuild();
        IBuildEntry includes = build.getEntry("bin.includes");
        IBuildEntry excludes = build.getEntry("bin.excludes");
        resourceName = this.handleResourceFolder(resource, resourceName);
        if (checked) {
            this.handleCheck(includes, excludes, resourceName, resource, wasTopParentChecked, "bin.includes");
        } else {
            this.handleUncheck(includes, excludes, resourceName, resource, "bin.excludes");
        }
        this.deleteEmptyEntries();
    }
}

