/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.update.ui.forms.internal.IFormPage;

public abstract class PDESourcePage
extends TextEditor
implements IPDEEditorPage,
IGotoMarker {
    public static final String PAGE_TITLE = "SourcePage.title";
    public static final String ERROR_MESSAGE = "SourcePage.errorMessage";
    public static final String ERROR_TITLE = "SourcePage.errorTitle";
    private IContentOutlinePage outlinePage;
    private boolean errorMode;
    private PDEMultiPageEditor editor;
    private boolean modelNeedsUpdating = false;
    private Control control;
    private IDocumentListener documentListener;
    static /* synthetic */ Class class$0;

    public PDESourcePage(PDEMultiPageEditor editor) {
        this.editor = editor;
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.initializeDocumentListener();
    }

    public boolean becomesInvisible(IFormPage newPage) {
        if (this.errorMode || this.isModelNeedsUpdating()) {
            boolean cleanModel = this.getEditor().updateModel();
            if (cleanModel) {
                this.setModelNeedsUpdating(false);
            }
            boolean valid = this.getEditor().validateModelSemantics();
            if (!cleanModel || !valid) {
                this.warnErrorsInSource();
                this.errorMode = true;
                return false;
            }
            this.errorMode = false;
        }
        this.unregisterGlobalActions();
        return true;
    }

    public void becomesVisible(IFormPage oldPage) {
        this.setModelNeedsUpdating(false);
        if (oldPage instanceof PDEFormPage) {
            this.selectObjectRange(((PDEFormPage)oldPage).getSelection());
        }
        this.registerGlobalActions();
    }

    public boolean contextMenuAboutToShow(IMenuManager manager) {
        return false;
    }

    public abstract IContentOutlinePage createContentOutlinePage();

    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
        WorkbenchHelp.setHelp((Control)this.control, (String)"org.eclipse.pde.doc.user.manifest_source_page");
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        document.addDocumentListener(this.documentListener);
        this.errorMode = !this.getEditor().isModelCorrect(this.getEditor().getModel());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getEditor());
    }

    protected void unregisterGlobalActions() {
        IKeyBindingService service = this.getEditor().getSite().getKeyBindingService();
        service.unregisterAction(this.getAction(ActionFactory.DELETE.getId()));
        service.unregisterAction(this.getAction(ActionFactory.UNDO.getId()));
        service.unregisterAction(this.getAction(ActionFactory.REDO.getId()));
        service.unregisterAction(this.getAction(ActionFactory.CUT.getId()));
        service.unregisterAction(this.getAction(ActionFactory.COPY.getId()));
        service.unregisterAction(this.getAction(ActionFactory.PASTE.getId()));
        service.unregisterAction(this.getAction(ActionFactory.SELECT_ALL.getId()));
        service.unregisterAction(this.getAction(ActionFactory.FIND.getId()));
        service.unregisterAction(this.getAction(IDEActionFactory.BOOKMARK.getId()));
        service.unregisterAction(this.getAction(IDEActionFactory.ADD_TASK.getId()));
    }

    protected void registerGlobalActions() {
        IKeyBindingService service = this.getEditor().getSite().getKeyBindingService();
        service.registerAction(this.getAction(ActionFactory.DELETE.getId()));
        service.registerAction(this.getAction(ActionFactory.UNDO.getId()));
        service.registerAction(this.getAction(ActionFactory.REDO.getId()));
        service.registerAction(this.getAction(ActionFactory.CUT.getId()));
        service.registerAction(this.getAction(ActionFactory.COPY.getId()));
        service.registerAction(this.getAction(ActionFactory.PASTE.getId()));
        service.registerAction(this.getAction(ActionFactory.SELECT_ALL.getId()));
        service.registerAction(this.getAction(ActionFactory.FIND.getId()));
        service.registerAction(this.getAction(IDEActionFactory.BOOKMARK.getId()));
        service.registerAction(this.getAction(IDEActionFactory.ADD_TASK.getId()));
    }

    public void dispose() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document != null) {
            document.removeDocumentListener(this.documentListener);
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        super.dispose();
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.getEditor().fireSaveNeeded();
        } else {
            super.firePropertyChange(type);
        }
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createContentOutlinePage();
        }
        return this.outlinePage;
    }

    public Control getControl() {
        return this.control;
    }

    public PDEMultiPageEditor getEditor() {
        if (this.editor.getEditorInput() != this.getEditorInput()) {
            this.editor.setInput(this.getEditorInput());
        }
        return this.editor;
    }

    public String getLabel() {
        return this.getTitle();
    }

    public IPropertySheetPage getPropertySheetPage() {
        return null;
    }

    public String getTitle() {
        return PDEPlugin.getResourceString(PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setDocumentProvider(this.getEditor().getDocumentProvider());
        super.init(site, input);
    }

    public boolean isEditable() {
        return this.getEditor().isEditable();
    }

    public boolean isSource() {
        return true;
    }

    public boolean isVisible() {
        return this.editor.getCurrentPage() == this;
    }

    public void openTo(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
        }
    }

    protected void selectObjectRange(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            int start = 0;
            int stop = 0;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                ISourceObject sobj = null;
                if (obj instanceof ISourceObject) {
                    sobj = (ISourceObject)obj;
                }
                if (obj instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)obj;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[Lorg.eclipse.pde.core.ISourceObject;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    sobj = (ISourceObject)adaptable.getAdapter((Class)clazz);
                }
                if (sobj == null) continue;
                start = start == 0 ? sobj.getStartLine() - 1 : Math.min(start, sobj.getStartLine() - 1);
                stop = Math.max(stop, sobj.getStopLine() - 1);
            }
            if (start > 0) {
                IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                if (document == null) {
                    return;
                }
                try {
                    int startOffset = document.getLineOffset(start);
                    int stopOffset = document.getLineOffset(stop) + document.getLineLength(stop);
                    this.selectAndReveal(startOffset, stopOffset - startOffset);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    public boolean performGlobalAction(String id) {
        return true;
    }

    public String toString() {
        return this.getTitle();
    }

    public void update() {
    }

    protected void warnErrorsInSource() {
        Display.getCurrent().beep();
        String title = this.editor.getSite().getRegisteredName();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)PDEPlugin.getResourceString(ERROR_MESSAGE));
    }

    protected void createActions() {
        PDEEditorContributor contributor = this.getEditor().getContributor();
        super.createActions();
        this.setAction(ActionFactory.SAVE.getId(), contributor.getSaveAction());
    }

    public void close(boolean save) {
        this.editor.close(save);
    }

    public boolean canPaste(Clipboard clipboard) {
        return true;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public boolean containsError() {
        return this.errorMode;
    }

    protected boolean isModelNeedsUpdating() {
        return this.modelNeedsUpdating;
    }

    protected void setModelNeedsUpdating(boolean modelNeedsUpdating) {
        this.modelNeedsUpdating = modelNeedsUpdating;
    }

    protected void setDocumentListener(IDocumentListener documentListener) {
        this.documentListener = documentListener;
    }

    protected void initializeDocumentListener() {
        this.setDocumentListener(new DocumentListener());
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            if (PDESourcePage.this.isVisible()) {
                PDESourcePage.this.setModelNeedsUpdating(true);
            }
        }
    }
}

