/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.NullUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageContentOutline;
import org.eclipse.pde.internal.ui.editor.PDEMultiPagePropertySheet;
import org.eclipse.pde.internal.ui.editor.PDEMultiSelectionProvider;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.StorageDocumentProvider;
import org.eclipse.pde.internal.ui.editor.SystemFileDocumentProvider;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.preferences.EditorPreferencePage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.update.ui.forms.internal.CustomWorkbook;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IFormSelectionListener;
import org.eclipse.update.ui.forms.internal.IFormWorkbook;

public abstract class PDEMultiPageEditor
extends EditorPart
implements ISelectionProvider,
IGotoMarker {
    public static final String WRONG_EDITOR = "MultiPageEditor.wrongEditor";
    public static final String TAG_TYPE = "input_type";
    public static final String TYPE_WORKBENCH = "workbench_file";
    public static final String TYPE_SYSTEM = "system_file";
    public static final String TAG_PATH = "input_path";
    protected IFormWorkbook formWorkbook;
    private PDEMultiSelectionProvider selectionProvider = new PDEMultiSelectionProvider();
    protected Object model;
    protected IModelChangedListener modelListener;
    private Vector pages;
    protected String firstPageId;
    private PDEMultiPageContentOutline contentOutline = new PDEMultiPageContentOutline(this);
    private PDEMultiPagePropertySheet propertySheet = new PDEMultiPagePropertySheet();
    private Hashtable table = new Hashtable();
    private Menu contextMenu;
    private IDocumentProvider documentProvider;
    private boolean disposed;
    protected IModelUndoManager undoManager;
    protected Clipboard clipboard;
    private boolean validated;
    private ElementListener elementListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public PDEMultiPageEditor() {
        this.formWorkbook = new CustomWorkbook();
        this.formWorkbook.setFirstPageSelected(false);
        this.pages = new Vector();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.createPages();
        this.undoManager = this.createModelUndoManager();
    }

    void updateUndo(IAction undoAction, IAction redoAction) {
        this.undoManager.setActions(undoAction, redoAction);
    }

    public void addPage(String id, IPDEEditorPage page) {
        this.table.put(id, page);
        this.pages.addElement(page);
    }

    public void addPage(String id, IPDEEditorPage page, int index) {
        this.table.put(id, page);
        this.pages.add(index, page);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public void commitFormPages(boolean onSave) {
        Iterator iter = this.getPages();
        while (iter.hasNext()) {
            IPDEEditorPage page = (IPDEEditorPage)iter.next();
            if (!(page instanceof PDEFormPage)) continue;
            PDEFormPage formPage = (PDEFormPage)page;
            formPage.getForm().commitChanges(onSave);
        }
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        return null;
    }

    protected IDocumentProvider createDocumentProvider(Object input) {
        Object documentProvider = null;
        if (input instanceof IFile) {
            documentProvider = new FileDocumentProvider(){

                public IDocument createDocument(Object element) throws CoreException {
                    IDocumentPartitioner partitioner;
                    IDocument document = super.createDocument(element);
                    if (document != null && (partitioner = PDEMultiPageEditor.this.createDocumentPartitioner()) != null) {
                        partitioner.connect(document);
                        document.setDocumentPartitioner(partitioner);
                    }
                    return document;
                }
            };
        } else if (input instanceof File) {
            documentProvider = new SystemFileDocumentProvider(this.createDocumentPartitioner());
        } else if (input instanceof IStorage) {
            documentProvider = new StorageDocumentProvider(this.createDocumentPartitioner());
        }
        return documentProvider;
    }

    protected abstract Object createModel(Object var1) throws CoreException;

    protected abstract void createPages();

    protected IModelUndoManager createModelUndoManager() {
        return new NullUndoManager();
    }

    public void createPartControl(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        this.formWorkbook.createControl(parent);
        this.formWorkbook.addFormSelectionListener(new IFormSelectionListener(){

            public void formSelected(IFormPage page, boolean setFocus) {
                PDEFormPage formPage;
                PDEMultiPageEditor.this.getContributor().setActivePage((IPDEEditorPage)page);
                if (page instanceof PDEFormPage && (formPage = (PDEFormPage)page).getSelection() != null) {
                    PDEMultiPageEditor.this.setSelection(formPage.getSelection());
                }
                if (page.isSource()) {
                    PDESourcePage sourcePage = (PDESourcePage)page;
                    PDEMultiPageEditor.this.selectionProvider.setSourcePage(sourcePage);
                }
                IPDEEditorPage pdePage = (IPDEEditorPage)page;
                if (setFocus) {
                    pdePage.setFocus();
                }
                PDEMultiPageEditor.this.updateSynchronizedViews((IPDEEditorPage)page);
            }
        });
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PDEMultiPageEditor.this.editorContextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        this.contextMenu = manager.createContextMenu(this.formWorkbook.getControl());
        this.formWorkbook.getControl().setMenu(this.contextMenu);
        Iterator iter = this.pages.iterator();
        while (iter.hasNext()) {
            IFormPage page = (IFormPage)iter.next();
            this.formWorkbook.addPage(page);
        }
        String storedFirstPageId = this.loadDefaultPage();
        if (storedFirstPageId != null) {
            this.firstPageId = storedFirstPageId;
        } else if (EditorPreferencePage.getUseSourcePage()) {
            this.firstPageId = this.getSourcePageId();
        }
        if (!this.isModelCorrect(this.getModel())) {
            this.firstPageId = this.getSourcePageId();
        }
        if (this.firstPageId != null) {
            IPDEEditorPage firstPage = this.getPage(this.firstPageId);
            if (firstPage == null) {
                firstPage = (IPDEEditorPage)this.pages.get(0);
            }
            this.showPage(firstPage);
        }
    }

    public void dispose() {
        this.storeDefaultPage();
        this.setSelection((ISelection)new StructuredSelection());
        int i = 0;
        while (i < this.pages.size()) {
            IWorkbenchPart part = (IWorkbenchPart)this.pages.elementAt(i);
            part.dispose();
            ++i;
        }
        IEditorInput input = this.getEditorInput();
        IAnnotationModel amodel = this.documentProvider.getAnnotationModel((Object)input);
        if (amodel != null) {
            amodel.disconnect(this.documentProvider.getDocument((Object)input));
        }
        this.documentProvider.disconnect((Object)input);
        if (this.modelListener != null && this.model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)this.model).removeModelChangedListener(this.modelListener);
            if (this.undoManager != null) {
                this.undoManager.disconnect((IModelChangeProvider)this.model);
            }
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        this.disposed = true;
    }

    private void storeDefaultPage() {
        IEditorInput input = this.getEditorInput();
        String pageId = this.getPageId(this.getCurrentPage());
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (file != null) {
                try {
                    file.setPersistentProperty(IPDEUIConstants.DEFAULT_EDITOR_PAGE_KEY, pageId);
                }
                catch (CoreException coreException) {}
            }
        } else if (input instanceof SystemFileEditorInput) {
            File file;
            SystemFileEditorInput systemFileEditorInput = (SystemFileEditorInput)input;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.io.File;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (File)systemFileEditorInput.getAdapter(clazz)) == null) {
                return;
            }
            IDialogSettings section = this.getSettingsSection();
            section.put(file.getPath(), pageId);
        }
    }

    private String loadDefaultPage() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                return file.getPersistentProperty(IPDEUIConstants.DEFAULT_EDITOR_PAGE_KEY);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        if (input instanceof SystemFileEditorInput) {
            File file;
            SystemFileEditorInput systemFileEditorInput = (SystemFileEditorInput)input;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.io.File;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (File)systemFileEditorInput.getAdapter(clazz)) == null) {
                return null;
            }
            IDialogSettings section = this.getSettingsSection();
            String key = file.getPath();
            return section.get(key);
        }
        return null;
    }

    private IDialogSettings getSettingsSection() {
        IDialogSettings root = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection("multi-page-editor");
        if (section == null) {
            section = root.addNewSection("multi-page-editor");
        }
        return section;
    }

    public void doSave(IProgressMonitor monitor) {
        final IEditorInput input = this.getEditorInput();
        this.commitFormPages(true);
        this.updateDocument();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                PDEMultiPageEditor.this.documentProvider.saveDocument(monitor, (Object)input, PDEMultiPageEditor.this.documentProvider.getDocument((Object)input), true);
            }
        };
        try {
            this.documentProvider.aboutToChange((Object)input);
            op.run(monitor);
            this.documentProvider.changed((Object)input);
            this.fireSaveNeeded();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            PDEPlugin.logException(x);
        }
    }

    public void doSaveAs() {
        this.getCurrentPage().doSaveAs();
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        PDEEditorContributor contributor = this.getContributor();
        this.getCurrentPage().contextMenuAboutToShow(menu);
        if (contributor != null) {
            contributor.contextMenuAboutToShow(menu);
        }
    }

    public void fireSaveNeeded() {
        this.firePropertyChange(257);
        PDEEditorContributor contributor = this.getContributor();
        if (contributor != null) {
            contributor.updateActions();
        }
        this.validateEdit();
    }

    private void validateEdit() {
        if (!this.isDirty()) {
            return;
        }
        if (!this.validated) {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                Shell shell = this.formWorkbook.getControl().getShell();
                IStatus validateStatus = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
                if (validateStatus.getCode() != 0) {
                    ErrorDialog.openError((Shell)shell, (String)this.getTitle(), null, (IStatus)validateStatus);
                }
            }
            this.validated = true;
        }
    }

    public IAction getAction(String id) {
        return this.getContributor().getGlobalAction(id);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.ui.views.contentoutline.IContentOutlinePage;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getContentOutline();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySheetPage;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz2)) {
            return this.getPropertySheet();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("[Lorg.eclipse.ui.ide.IGotoMarker;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public PDEMultiPageContentOutline getContentOutline() {
        if (this.contentOutline == null || this.contentOutline.isDisposed()) {
            this.contentOutline = new PDEMultiPageContentOutline(this);
            this.updateContentOutline(this.getCurrentPage());
        }
        return this.contentOutline;
    }

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public PDEEditorContributor getContributor() {
        return (PDEEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    public IPDEEditorPage getCurrentPage() {
        return (IPDEEditorPage)this.formWorkbook.getCurrentPage();
    }

    public String getPageId(IPDEEditorPage page) {
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            Object value = this.table.get(key);
            if (!value.equals(page)) continue;
            return key;
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public abstract IPDEEditorPage getHomePage();

    public Object getModel() {
        return this.model;
    }

    public IPDEEditorPage getPage(String pageId) {
        return (IPDEEditorPage)this.table.get(pageId);
    }

    public Iterator getPages() {
        return this.pages.iterator();
    }

    public PDEMultiPagePropertySheet getPropertySheet() {
        if (this.propertySheet == null || this.propertySheet.isDisposed()) {
            this.propertySheet = new PDEMultiPagePropertySheet();
            this.updatePropertySheet(this.getCurrentPage());
        }
        return this.propertySheet;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public Control getControl() {
        return this.formWorkbook.getControl();
    }

    public ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    protected abstract String getSourcePageId();

    public IStatusLineManager getStatusLineManager() {
        PDEEditorContributor contributor = this.getContributor();
        if (contributor != null) {
            return contributor.getStatusLineManager();
        }
        return null;
    }

    public void gotoMarker(IMarker marker) {
        IPDEEditorPage page = this.showPage(this.getPage(this.getSourcePageId()), false);
        IDE.gotoMarker((IEditorPart)page, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!this.isValidContentType(input)) {
            String message = PDEPlugin.getFormattedMessage(WRONG_EDITOR, input.getName());
            Status s = new Status(4, PDEPlugin.getPluginId(), 0, message, null);
            throw new PartInitException((IStatus)s);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        Object inputObject = null;
        if (input instanceof SystemFileEditorInput) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.io.File;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            inputObject = input.getAdapter((Class)clazz);
        } else if (input instanceof IFileEditorInput) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("[Lorg.eclipse.core.resources.IFile;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            inputObject = input.getAdapter((Class)clazz);
        } else if (input instanceof IStorageEditorInput) {
            try {
                inputObject = ((IStorageEditorInput)input).getStorage();
            }
            catch (CoreException e) {
                throw new PartInitException(e.getStatus());
            }
        }
        site.setSelectionProvider((ISelectionProvider)this);
        try {
            this.initializeModels(inputObject);
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
        Iterator iter = this.pages.iterator();
        while (iter.hasNext()) {
            IEditorPart part = (IEditorPart)iter.next();
            part.init(site, input);
        }
        if (inputObject instanceof IFile) {
            this.setTitle(((IFile)inputObject).getName());
        } else if (inputObject instanceof File) {
            this.setTitle("system:" + ((File)inputObject).getName());
        } else if (inputObject instanceof IStorage) {
            this.setTitle(((IStorage)inputObject).getName());
        } else {
            this.setTitle(input.toString());
        }
    }

    protected void initializeModels(Object input) throws CoreException {
        this.documentProvider = this.createDocumentProvider(input);
        if (this.documentProvider == null) {
            return;
        }
        this.model = this.createModel(input);
        if (this.model instanceof IModelChangeProvider) {
            this.modelListener = new IModelChangedListener(){

                public void modelChanged(IModelChangedEvent e) {
                    if (e.getChangeType() != 99) {
                        PDEMultiPageEditor.this.fireSaveNeeded();
                    }
                }
            };
            ((IModelChangeProvider)this.model).addModelChangedListener(this.modelListener);
            this.undoManager.connect((IModelChangeProvider)this.model);
        }
        try {
            IEditorInput editorInput = this.getEditorInput();
            this.documentProvider.connect((Object)editorInput);
            IAnnotationModel amodel = this.documentProvider.getAnnotationModel((Object)editorInput);
            if (amodel != null) {
                amodel.connect(this.documentProvider.getDocument((Object)editorInput));
            }
            this.elementListener = new ElementListener();
            this.documentProvider.addElementStateListener((IElementStateListener)this.elementListener);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        if (!this.isModelCorrect(this.model)) {
            this.firstPageId = this.getSourcePageId();
        }
    }

    public boolean isDirty() {
        if (this.isModelDirty(this.model)) {
            return true;
        }
        if (this.documentProvider != null) {
            return this.documentProvider.canSaveDocument((Object)this.getEditorInput());
        }
        return false;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isEditable() {
        if (this.model instanceof IModel) {
            return ((IModel)this.model).isEditable();
        }
        return true;
    }

    protected boolean isModelCorrect(Object model) {
        return true;
    }

    protected abstract boolean isModelDirty(Object var1);

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected boolean isValidContentType(IEditorInput input) {
        return true;
    }

    protected void performGlobalAction(String id) {
        IPDEEditorPage page;
        ISelection selection = this.getSelection();
        boolean handled = this.getCurrentPage().performGlobalAction(id);
        if (!handled && (page = this.getCurrentPage()) instanceof PDEFormPage) {
            if (id.equals(ActionFactory.UNDO.getId())) {
                this.undoManager.undo();
                return;
            }
            if (id.equals(ActionFactory.REDO.getId())) {
                this.undoManager.redo();
                return;
            }
            if (id.equals(ActionFactory.CUT.getId()) || id.equals(ActionFactory.COPY.getId())) {
                this.copyToClipboard(selection);
                return;
            }
        }
    }

    public void registerContentOutline(IPDEEditorPage page) {
        IContentOutlinePage outlinePage = page.getContentOutlinePage();
        outlinePage.createControl((Composite)this.contentOutline.getPagebook());
    }

    public void removePage(IPDEEditorPage page) {
        this.formWorkbook.removePage((IFormPage)page);
        this.pages.removeElement(page);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setFocus() {
        IPDEEditorPage page = this.getCurrentPage();
        if (page != null) {
            page.setFocus();
        }
    }

    public void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
        this.getContributor().updateSelectableActions(selection);
    }

    public IPDEEditorPage showPage(String id) {
        return this.showPage(this.getPage(id));
    }

    public void showPage(String id, Object openToObject) {
        IPDEEditorPage page = this.showPage(this.getPage(id));
        if (page != null) {
            page.openTo(openToObject);
        }
    }

    public void openTo(Object obj, IMarker marker) {
        if (EditorPreferencePage.getUseSourcePage()) {
            PDESourcePage sourcePage = (PDESourcePage)this.showPage(this.getSourcePageId());
            if (marker != null) {
                sourcePage.openTo(marker);
            }
        } else {
            IPDEEditorPage page = this.getPageFor(obj);
            if (page != null) {
                this.showPage(page);
                page.openTo(obj);
            }
        }
    }

    public IPDEEditorPage showPage(IPDEEditorPage page) {
        return this.showPage(page, true);
    }

    public IPDEEditorPage showPage(IPDEEditorPage page, boolean setFocus) {
        this.formWorkbook.selectPage((IFormPage)page, setFocus);
        return page;
    }

    void updateDocument() {
        if (!(this.model instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.model;
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            IDocument document = this.documentProvider.getDocument((Object)this.getEditorInput());
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            document.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    public void doRevert() {
        PDESourcePage sourcePage = (PDESourcePage)this.getPage(this.getSourcePageId());
        sourcePage.doRevertToSaved();
        this.updateModel();
        ((IEditable)this.getModel()).setDirty(false);
        this.fireSaveNeeded();
    }

    protected abstract boolean updateModel();

    public boolean validateModelSemantics() {
        IModel model = (IModel)this.getModel();
        return model != null && model.isValid();
    }

    public boolean containsError() {
        boolean loaded = ((IModel)this.getModel()).isLoaded();
        if (!loaded) {
            return true;
        }
        return !this.validateModelSemantics();
    }

    void updateSynchronizedViews(IPDEEditorPage page) {
        this.updateContentOutline(page);
        this.updatePropertySheet(page);
    }

    void updateContentOutline(IPDEEditorPage page) {
        IContentOutlinePage outlinePage = page.getContentOutlinePage();
        if (outlinePage != null) {
            this.contentOutline.setPageActive(outlinePage);
        }
    }

    void updatePropertySheet(IPDEEditorPage page) {
        IPropertySheetPage propertySheetPage = page.getPropertySheetPage();
        if (propertySheetPage != null) {
            this.propertySheet.setPageActive(propertySheetPage);
        } else {
            this.propertySheet.setDefaultPageActive();
        }
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                PDEMultiPageEditor.this.getSite().getPage().closeEditor((IEditorPart)PDEMultiPageEditor.this, save);
            }
        });
    }

    private void copyToClipboard(ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel == null || ssel.size() == 0) {
            return;
        }
        Object[] objects = ssel.toArray();
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Class<?> objClass = null;
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            if (objClass == null) {
                objClass = obj.getClass();
            } else if (!objClass.equals(obj.getClass())) {
                return;
            }
            if (obj instanceof IWritable) {
                ((IWritable)obj).write("", pwriter);
            }
            ++i;
        }
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        this.clipboard.setContents(new Object[]{objects, textVersion}, new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()});
    }

    public boolean canPasteFromClipboard() {
        IPDEEditorPage page = this.getCurrentPage();
        if (page instanceof PDEFormPage) {
            return page.canPaste(this.getClipboard());
        }
        return false;
    }

    public boolean canCopy(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            return !selection.isEmpty();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return textSelection.getLength() > 0;
        }
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected IPDEEditorPage getPageFor(Object object) {
        return null;
    }

    class ElementListener
    implements IElementStateListener {
        ElementListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            PDEMultiPageEditor.this.updateModel();
            PDEMultiPageEditor.this.fireSaveNeeded();
        }

        public void elementDeleted(Object element) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            PDEMultiPageEditor.this.close(true);
        }
    }
}

