/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.PDEMultiSelectionProvider;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PDEMultiPageContentOutline
implements IContentOutlinePage,
ISelectionChangedListener {
    private PageBook pagebook;
    private PDEMultiSelectionProvider selectionProvider = new PDEMultiSelectionProvider();
    private IContentOutlinePage currentPage;
    private boolean disposed;

    public PDEMultiPageContentOutline(PDEMultiPageEditor editor) {
    }

    public void addFocusListener(FocusListener listener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.addSelectionChangedListener(listener);
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        this.pagebook = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionProvider.removeSelectionChangedListener(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionProvider.setSelection(event.getSelection());
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    public void setPageActive(IContentOutlinePage page) {
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        page.addSelectionChangedListener((ISelectionChangedListener)this);
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.pagebook);
            control = page.getControl();
        }
        this.pagebook.showPage(control);
        this.currentPage = page;
    }

    public void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }
}

