/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.update.ui.forms.internal.AbstractSectionForm;
import org.eclipse.update.ui.forms.internal.IFormPage;

public abstract class PDEFormPage
extends EditorPart
implements IPDEEditorPage {
    private AbstractSectionForm form;
    private Control control;
    private PDEMultiPageEditor editor;
    private IContentOutlinePage contentOutlinePage;
    private IPropertySheetPage propertySheetPage;
    private ISelection selection;

    public PDEFormPage(PDEMultiPageEditor editor, String title) {
        this(editor, title, null);
    }

    public PDEFormPage(PDEMultiPageEditor editor, String title, AbstractSectionForm form) {
        this.editor = editor;
        if (form == null) {
            form = this.createForm();
        }
        this.form = form;
        if (this.isWhiteBackground()) {
            form.setHeadingImage(PDEPluginImages.get(PDEPluginImages.IMG_FORM_BANNER));
        }
        this.setTitle(title);
    }

    private boolean isWhiteBackground() {
        Color bg = this.form.getFactory().getBackgroundColor();
        return bg.getRed() == 255 && bg.getGreen() == 255 && bg.getBlue() == 255;
    }

    public boolean becomesInvisible(IFormPage newPage) {
        if (this.getModel() instanceof IModel && ((IModel)this.getModel()).isEditable()) {
            this.form.commitChanges(false);
        }
        this.getEditor().setSelection((ISelection)new StructuredSelection());
        if (newPage instanceof PDESourcePage) {
            this.getEditor().updateDocument();
        }
        return true;
    }

    public void becomesVisible(IFormPage oldPage) {
        this.update();
        this.setFocus();
        this.getEditor().getContributor().updateSelectableActions(null);
    }

    public boolean contextMenuAboutToShow(IMenuManager manager) {
        return true;
    }

    public abstract IContentOutlinePage createContentOutlinePage();

    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    protected abstract AbstractSectionForm createForm();

    public void createPartControl(Composite parent) {
        this.control = this.form.createControl(parent);
        this.control.setMenu(this.editor.getContextMenu());
        this.form.initialize(this.getModel());
    }

    public IPropertySheetPage createPropertySheetPage() {
        return null;
    }

    public void dispose() {
        this.form.dispose();
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public IAction getAction(String id) {
        return this.editor.getAction(id);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null || this.contentOutlinePage.getControl() != null && this.contentOutlinePage.getControl().isDisposed()) {
            this.contentOutlinePage = this.createContentOutlinePage();
        }
        return this.contentOutlinePage;
    }

    public Control getControl() {
        return this.control;
    }

    public PDEMultiPageEditor getEditor() {
        return this.editor;
    }

    public AbstractSectionForm getForm() {
        return this.form;
    }

    public String getLabel() {
        return this.getTitle();
    }

    public Object getModel() {
        return this.getEditor().getModel();
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null || this.propertySheetPage.getControl() != null && this.propertySheetPage.getControl().isDisposed()) {
            this.propertySheetPage = this.createPropertySheetPage();
        }
        return this.propertySheetPage;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public String getStatusText() {
        IEditorInput input = this.getEditor().getEditorInput();
        String status = "";
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            status = String.valueOf(file.getFullPath().toString()) + '/';
        }
        status = String.valueOf(status) + this.getTitle();
        return status;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSource() {
        return false;
    }

    public boolean isVisible() {
        return this.getEditor().getCurrentPage() == this;
    }

    public void openTo(Object object) {
        this.getForm().expandTo(object);
    }

    public boolean performGlobalAction(String id) {
        return this.getForm().doGlobalAction(id);
    }

    public void setFocus() {
        this.getForm().setFocus();
    }

    public void setSelection(ISelection newSelection) {
        this.selection = newSelection;
        this.getEditor().setSelection(this.selection);
    }

    public String toString() {
        return this.getTitle();
    }

    public void update() {
        this.form.update();
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.form.canPaste(clipboard);
    }
}

