/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class FormOutlinePage
extends ContentOutlinePage
implements IModelChangedListener {
    protected PDEFormPage formPage;
    protected TreeViewer treeViewer;

    public FormOutlinePage(PDEFormPage formPage) {
        this.formPage = formPage;
    }

    protected ITreeContentProvider createContentProvider() {
        return new BasicContentProvider();
    }

    public void createControl(Composite parent) {
        Tree widget = new Tree(parent, 770);
        this.treeViewer = new TreeViewer(widget);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.formPage.getEditor());
        Object model = this.formPage.getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
    }

    protected ILabelProvider createLabelProvider() {
        return new BasicLabelProvider();
    }

    public void dispose() {
        super.dispose();
        Object model = this.formPage.getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public Control getControl() {
        return this.treeViewer != null ? this.treeViewer.getControl() : null;
    }

    private Object[] getPages() {
        Vector<IPDEEditorPage> formPages = new Vector<IPDEEditorPage>();
        Iterator iter = this.formPage.getEditor().getPages();
        while (iter.hasNext()) {
            IPDEEditorPage page = (IPDEEditorPage)iter.next();
            if (page.isSource()) continue;
            formPages.addElement(page);
        }
        Object[] result = new Object[formPages.size()];
        formPages.copyInto(result);
        return result;
    }

    public IPDEEditorPage getParentPage(Object item) {
        if (item instanceof IPDEEditorPage) {
            return (IPDEEditorPage)item;
        }
        return null;
    }

    public void modelChanged(IModelChangedEvent event) {
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
    }

    public void selectionChanged(Object item) {
        IPDEEditorPage page = this.formPage.getEditor().getCurrentPage();
        IPDEEditorPage newPage = this.getParentPage(item);
        if (newPage != page) {
            this.formPage.getEditor().showPage(newPage);
        }
        if (newPage != item) {
            newPage.openTo(item);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object item = ssel.getFirstElement();
            this.selectionChanged(item);
        }
        this.fireSelectionChanged(selection);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public class BasicContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object obj) {
            return FormOutlinePage.this.getPages();
        }

        public Object[] getChildren(Object obj) {
            return new Object[0];
        }

        public boolean hasChildren(Object obj) {
            return this.getChildren(obj).length > 0;
        }

        public Object getParent(Object obj) {
            return null;
        }
    }

    public class BasicLabelProvider
    extends LabelProvider {
        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return PDEPlugin.getDefault().getLabelProvider().getImage(obj);
        }
    }
}

