/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class JavaCodeGenerator {
    private IProject project;
    private IFolder sourceFolder;
    private String qualifiedClassName;

    public JavaCodeGenerator(IProject project, String qualifiedClassName) {
        this.project = project;
        this.qualifiedClassName = qualifiedClassName;
    }

    public JavaCodeGenerator(IProject project, IFolder sourceFolder, String qualifiedClassName) {
        this.project = project;
        this.sourceFolder = sourceFolder;
        this.qualifiedClassName = qualifiedClassName;
    }

    public static void ensureFolderExist(IWorkspace workspace, IPath folderPath) throws CoreException {
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, null);
            }
            ++i;
        }
    }

    private void ensureFolderExist(IPath folderPath) throws CoreException {
        IWorkspace workspace = this.project.getWorkspace();
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, null);
            }
            ++i;
        }
    }

    private void ensureFoldersExist(String packageName) throws CoreException {
        StringTokenizer stok = new StringTokenizer(packageName, ".");
        IPath fpath = this.sourceFolder != null ? this.sourceFolder.getFullPath() : this.project.getFullPath();
        this.ensureFolderExist(fpath);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            fpath = fpath.append(tok);
            this.ensureFolderExist(fpath);
        }
    }

    public static void ensureFoldersExist(IProject project, String name, String delimeter) throws CoreException {
        StringTokenizer stok = new StringTokenizer(name, delimeter);
        IPath fpath = project.getFullPath();
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            fpath = fpath.append(tok);
            JavaCodeGenerator.ensureFolderExist(project.getWorkspace(), fpath);
        }
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException {
        int nameloc = this.qualifiedClassName.lastIndexOf(46);
        String packageName = nameloc == -1 ? "" : this.qualifiedClassName.substring(0, nameloc);
        String className = this.qualifiedClassName.substring(nameloc + 1);
        String javaFileName = String.valueOf(className) + ".java";
        this.ensureFoldersExist(packageName);
        IWorkspace workbench = this.project.getWorkspace();
        IPath path = this.sourceFolder != null ? this.sourceFolder.getFullPath() : this.project.getFullPath();
        path = path.append(packageName.replace('.', '/'));
        IFile file = workbench.getRoot().getFile(path.append(javaFileName));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.generateContents(packageName, className, writer);
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes());
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, monitor);
            } else {
                file.create((InputStream)stream, false, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    public abstract void generateContents(String var1, String var2, PrintWriter var3);

    public IProject getProject() {
        return this.project;
    }

    public IFolder getSourceFolder() {
        return this.sourceFolder;
    }
}

