/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.codegen.JavaCodeGenerator;
import org.eclipse.swt.widgets.Shell;

public class AttributeClassCodeGenerator
extends JavaCodeGenerator {
    private static final String KEY_MISSING_TITLE = "CodeGenerator.missing.title";
    private static final String KEY_MISSING_TYPE = "CodeGenerator.missing.type";
    private static final String KEY_MISSING_TYPES = "CodeGenerator.missing.types";
    private static final String KEY_CLASS_DESC = "CodeGenerator.desc.class";
    private static final String KEY_CONST_DESC = "CodeGenerator.desc.constructor";
    private static final String KEY_METHOD_DESC = "CodeGenerator.desc.method";
    private ISchemaAttribute attInfo;
    private IJavaProject javaProject;
    private IType expectedType;
    private IType expectedInterface;
    private Vector requiredMethods;
    private Vector requiredImports;
    private boolean addToDo = false;

    public AttributeClassCodeGenerator(IJavaProject javaProject, IFolder sourceFolder, String fullyQualifiedClassName, ISchemaAttribute attInfo, boolean addToDo) {
        super(javaProject.getProject(), sourceFolder, fullyQualifiedClassName);
        this.attInfo = attInfo;
        this.javaProject = javaProject;
        this.addToDo = addToDo;
        this.requiredImports = new Vector();
    }

    private void addAbstractMethod(IMethod method) throws JavaModelException {
        IMethod matchingMethod = this.findMatchingMethod(method);
        if (matchingMethod == null) {
            this.requiredMethods.addElement(method);
        }
    }

    private void addImports(PrintWriter writer) {
        int i = 0;
        while (i < this.requiredImports.size()) {
            String type = this.requiredImports.elementAt(i).toString();
            writer.println("import " + type + ";");
            ++i;
        }
        writer.println();
    }

    private void addRequiredMethodsFor(String typeName) throws JavaModelException {
        IType type = this.findTypeForName(typeName);
        if (type != null) {
            this.addRequiredMethodsFor(type);
        }
    }

    private void addRequiredMethodsFor(IType type) throws JavaModelException {
        String superclassName;
        String[] interfaceNames = type.getSuperInterfaceNames();
        int i = 0;
        while (i < interfaceNames.length) {
            if (!type.isBinary()) {
                interfaceNames[i] = this.getFullyQualifiedName(type, interfaceNames[i]);
            }
            this.addRequiredMethodsFor(interfaceNames[i]);
            ++i;
        }
        if (type.isClass() && (superclassName = type.getSuperclassName()) != null) {
            if (!type.isBinary()) {
                superclassName = this.getFullyQualifiedName(type, superclassName);
            }
            if (!superclassName.equals("java.lang.Object")) {
                this.addRequiredMethodsFor(superclassName);
            }
        }
        IMethod[] methods = type.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            IMethod method = methods[i2];
            if (type.isClass()) {
                int flags = method.getFlags();
                if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags)) {
                    if (Flags.isAbstract((int)flags)) {
                        this.addAbstractMethod(method);
                    } else {
                        this.removeImplementedMethod(method);
                    }
                }
            } else if (!method.getElementName().equals("<clinit>")) {
                this.addAbstractMethod(method);
            }
            ++i2;
        }
    }

    private String calculateReturnValue(String signature) {
        switch (signature.charAt(0)) {
            case 'Z': {
                return "false";
            }
            case 'B': {
                return "0";
            }
            case 'C': {
                return "0";
            }
            case 'D': {
                return "(double)0.0";
            }
            case 'F': {
                return "(float)0.0";
            }
            case 'I': {
                return "0";
            }
            case 'J': {
                return "(long)0";
            }
            case 'S': {
                return "(short)0";
            }
            case 'V': {
                return null;
            }
            case 'L': 
            case 'Q': 
            case '[': {
                return "null";
            }
        }
        return null;
    }

    private IMethod findMatchingMethod(IMethod method) throws JavaModelException {
        int i = 0;
        while (i < this.requiredMethods.size()) {
            IMethod requiredMethod = (IMethod)this.requiredMethods.elementAt(i);
            if (requiredMethod.getElementName().equals(method.getElementName()) && requiredMethod.getSignature().equals(method.getSignature())) {
                return requiredMethod;
            }
            ++i;
        }
        return null;
    }

    private void findRequiredMethods() {
        String expectedTypeName = this.attInfo.getBasedOn();
        String expectedClassName = null;
        String expectedInterfaceName = null;
        if (expectedTypeName == null) {
            return;
        }
        int del = expectedTypeName.indexOf(58);
        if (del != -1) {
            expectedClassName = expectedTypeName.substring(0, del);
            expectedInterfaceName = expectedTypeName.substring(del + 1);
            expectedTypeName = expectedClassName;
        }
        try {
            boolean missingInterface;
            this.expectedType = this.findTypeForName(expectedTypeName);
            if (this.expectedType != null && this.expectedType.isClass() && expectedInterfaceName != null) {
                this.expectedInterface = this.findTypeForName(expectedInterfaceName);
            }
            boolean missingType = expectedTypeName != null && this.expectedType == null;
            boolean bl = missingInterface = expectedInterfaceName != null && this.expectedInterface == null;
            if (missingType || missingInterface) {
                String mtype = missingType ? expectedTypeName : null;
                String minter = missingInterface ? expectedInterfaceName : null;
                this.warnAboutMissingTypes(mtype, minter);
            }
            if (this.expectedType == null) {
                return;
            }
            this.requiredMethods = new Vector();
            if (this.expectedInterface != null) {
                this.addRequiredMethodsFor(this.expectedInterface);
            }
            this.addRequiredMethodsFor(this.expectedType);
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    private void warnAboutMissingTypes(String typeName, String interfaceName) {
        String message = typeName == null ? PDEPlugin.getFormattedMessage(KEY_MISSING_TYPE, interfaceName) : (interfaceName == null ? PDEPlugin.getFormattedMessage(KEY_MISSING_TYPE, typeName) : PDEPlugin.getFormattedMessage(KEY_MISSING_TYPES, new String[]{typeName, interfaceName}));
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(KEY_MISSING_TITLE), (String)message);
    }

    private IType findTypeForName(String typeName) throws JavaModelException {
        IType type = null;
        String fileName = String.valueOf(typeName.replace('.', '/')) + ".java";
        IJavaElement element = this.javaProject.findElement((IPath)new Path(fileName));
        if (element == null) {
            return null;
        }
        if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        } else if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getTypes();
            type = types[0];
        }
        return type;
    }

    public void generateContents(String packageName, String className, PrintWriter writer) {
        try {
            this.findRequiredMethods();
            String methodsBuffer = null;
            if (this.expectedType == null) {
                this.generateUnknownContents(packageName, className, writer);
                return;
            }
            if (this.requiredMethods != null) {
                methodsBuffer = this.generateMethods();
            }
            String extending = this.expectedType.isInterface() ? " implements " : " extends ";
            String interfaceExtending = "";
            if (this.expectedInterface != null) {
                interfaceExtending = " implements " + this.getSimpleName(this.expectedInterface.getFullyQualifiedName());
            }
            this.requiredImports.add(this.expectedType.getFullyQualifiedName());
            if (this.expectedInterface != null) {
                this.requiredImports.add(this.expectedInterface.getFullyQualifiedName());
            }
            if (!packageName.equals("")) {
                writer.println("package " + packageName + ";");
                writer.println();
            }
            this.addImports(writer);
            writer.println("/**");
            if (this.addToDo) {
                writer.println(PDEPlugin.getFormattedMessage(KEY_CLASS_DESC, className));
            }
            writer.println(" * @see " + this.expectedType.getElementName());
            writer.println(" */");
            writer.println("public class " + className + extending + this.getSimpleName(this.expectedType.getFullyQualifiedName()) + interfaceExtending + " {");
            writer.println("\t/**");
            if (this.addToDo) {
                writer.println(PDEPlugin.getFormattedMessage(KEY_CONST_DESC, className));
            } else {
                writer.println("\t *");
            }
            writer.println("\t */");
            writer.println("\tpublic " + className + "() {");
            writer.println("\t}");
            if (methodsBuffer != null) {
                writer.println();
                writer.print(methodsBuffer);
            }
            writer.println("}");
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    public void generateUnknownContents(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        writer.println("/**");
        if (this.addToDo) {
            writer.println(PDEPlugin.getFormattedMessage(KEY_CLASS_DESC, className));
        }
        writer.println(" */");
        writer.println("public class " + className + " {");
        writer.println("\t/**");
        if (this.addToDo) {
            writer.println(PDEPlugin.getFormattedMessage(KEY_CONST_DESC, className));
        }
        writer.println("\t */");
        writer.println("\tpublic " + className + "() {");
        writer.println("\t}");
        writer.println("}");
    }

    private String generateMethods() throws JavaModelException {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)swriter, true);
        if (this.requiredMethods != null) {
            int i = 0;
            while (i < this.requiredMethods.size()) {
                if (i > 0) {
                    writer.println();
                }
                IMethod method = (IMethod)this.requiredMethods.elementAt(i);
                this.generateRequiredMethod(method, writer);
                ++i;
            }
        }
        writer.close();
        return swriter.toString();
    }

    private void generateRequiredMethod(IMethod method, PrintWriter writer) throws JavaModelException {
        int flags = method.getFlags();
        boolean isProtected = Flags.isProtected((int)flags);
        String access = isProtected ? "protected" : "public";
        String returnType = this.parseSignature(method, method.getReturnType());
        writer.println("\t/**");
        if (this.addToDo) {
            writer.println(PDEPlugin.getFormattedMessage(KEY_METHOD_DESC, method.getElementName()));
        }
        writer.println("\t * @see " + this.getSimpleName(this.expectedType.getElementName()) + "#" + method.getElementName());
        writer.println("\t */");
        writer.print("\t" + access + " " + returnType + " " + method.getElementName() + "(");
        String[] parameterNames = method.getParameterNames();
        String[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < method.getNumberOfParameters()) {
            if (i > 0) {
                writer.print(", ");
            }
            writer.print(this.parseSignature(method, parameterTypes[i]));
            writer.print(" " + parameterNames[i]);
            ++i;
        }
        writer.print(") ");
        String[] exceptionTypes = method.getExceptionTypes();
        int i2 = 0;
        while (i2 < exceptionTypes.length) {
            if (i2 == 0) {
                writer.print("throws ");
            } else {
                writer.print(", ");
            }
            writer.print(this.parseSignature(method, exceptionTypes[i2]));
            ++i2;
        }
        writer.println(" {");
        String returnValue = this.calculateReturnValue(method.getReturnType());
        if (returnValue != null) {
            writer.println("\t\treturn " + returnValue + ";");
        }
        writer.println("\t}");
    }

    private String getSimpleName(String fullyQualifiedName) {
        int dot = fullyQualifiedName.lastIndexOf(46);
        if (dot != -1) {
            return fullyQualifiedName.substring(dot + 1);
        }
        return fullyQualifiedName;
    }

    private String parseSignature(IMethod method, String signature) {
        int dimensions = 0;
        StringBuffer buffer = new StringBuffer();
        int nameLoc = 0;
        boolean inTypeName = false;
        int i = 0;
        while (i < signature.length()) {
            char c = signature.charAt(i);
            if (inTypeName) {
                if (c == ';') {
                    String shortTypeName;
                    String typeName = signature.substring(nameLoc, i);
                    if (method.getCompilationUnit() != null) {
                        try {
                            typeName = this.getFullyQualifiedName(method.getCompilationUnit().getAllTypes()[0], typeName);
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    if ((shortTypeName = this.getSimpleName(typeName)).length() < typeName.length() && !this.requiredImports.contains(typeName)) {
                        this.requiredImports.addElement(typeName);
                    }
                    buffer.append(shortTypeName);
                    inTypeName = false;
                }
            } else {
                switch (c) {
                    case 'Z': {
                        buffer.append("boolean");
                        break;
                    }
                    case 'B': {
                        buffer.append("byte");
                        break;
                    }
                    case 'C': {
                        buffer.append("char");
                        break;
                    }
                    case 'D': {
                        buffer.append("double");
                        break;
                    }
                    case 'F': {
                        buffer.append("float");
                        break;
                    }
                    case 'I': {
                        buffer.append("int");
                        break;
                    }
                    case 'J': {
                        buffer.append("long");
                        break;
                    }
                    case 'S': {
                        buffer.append("short");
                        break;
                    }
                    case 'V': {
                        buffer.append("void");
                        break;
                    }
                    case '[': {
                        ++dimensions;
                        break;
                    }
                    case 'L': {
                        nameLoc = i + 1;
                        inTypeName = true;
                        break;
                    }
                    case 'Q': {
                        nameLoc = i + 1;
                        inTypeName = true;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < dimensions) {
            if (i == 0) {
                buffer.append(" ");
            }
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }

    private void removeImplementedMethod(IMethod method) throws JavaModelException {
        IMethod matchingMethod = this.findMatchingMethod(method);
        if (matchingMethod != null) {
            this.requiredMethods.remove(matchingMethod);
        }
    }

    private String getFullyQualifiedName(IType type, String name) {
        try {
            String[][] resolvedType = type.resolveType(name);
            if (resolvedType != null) {
                name = String.valueOf(resolvedType[0][0]) + "." + resolvedType[0][1];
            }
        }
        catch (JavaModelException javaModelException) {}
        return name;
    }
}

