/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.IAlternativeRuntimeUISupport;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdapterFactory;
import org.eclipse.pde.internal.ui.editor.manifest.PluginAdapterFactory;
import org.eclipse.pde.internal.ui.editor.schema.SchemaAdapterFactory;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.launcher.LaunchListener;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.view.PluginsViewAdapterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ExtendedTextEditorPreferenceConstants;

public class PDEPlugin
extends AbstractUIPlugin
implements IPDEUIConstants,
IPreferenceConstants {
    private static PDEPlugin inst;
    private ResourceBundle resourceBundle;
    private IAlternativeRuntimeUISupport runtimeUISupport;
    private LaunchListener launchListener;
    private Hashtable counters;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public PDEPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.pde.internal.ui.pderesources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static IWorkbenchPage getActivePage() {
        return PDEPlugin.getDefault().internalGetActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PDEPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PDEPlugin getDefault() {
        return inst;
    }

    public Hashtable getDefaultNameCounters() {
        if (this.counters == null) {
            this.counters = new Hashtable();
        }
        return this.counters;
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = PDEPlugin.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = PDEPlugin.getResourceString(key);
        return MessageFormat.format(text, arg);
    }

    static IPath getInstallLocation() {
        return new Path(PDEPlugin.getDefault().getDescriptor().getInstallURL().getFile());
    }

    public static String getPluginId() {
        return PDEPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDEPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return key;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        PDEPlugin.log((IStatus)new Status(4, PDEPlugin.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDEPlugin.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = SWTUtil.getStandardDisplay();
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        PDEPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), e);
        PDEPlugin.log(status);
    }

    public void startup() throws CoreException {
        super.startup();
        IAdapterManager manager = Platform.getAdapterManager();
        SchemaAdapterFactory schemaFactory = new SchemaAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.pde.internal.core.ischema.ISchemaObject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)schemaFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.pde.internal.core.ischema.ISchemaObjectReference;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)schemaFactory, (Class)clazz2);
        PluginAdapterFactory pluginAdapterFactory = new PluginAdapterFactory();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.pde.core.plugin.IPluginObject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)pluginAdapterFactory, (Class)clazz3);
        FeatureAdapterFactory featureAdapterFactory = new FeatureAdapterFactory();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Lorg.eclipse.pde.internal.core.ifeature.IFeatureObject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)featureAdapterFactory, (Class)clazz4);
        PluginsViewAdapterFactory factory = new PluginsViewAdapterFactory();
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("[Lorg.eclipse.pde.internal.core.ModelEntry;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)factory, (Class)clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("[Lorg.eclipse.pde.internal.core.FileAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)factory, (Class)clazz6);
    }

    public void shutdown() throws CoreException {
        if (this.launchListener != null) {
            this.launchListener.shutdown();
        }
        super.shutdown();
    }

    public static File getFileInPlugin(IPath path) {
        try {
            URL installURL = new URL(PDEPlugin.getDefault().getDescriptor().getInstallURL(), path.toString());
            URL localURL = Platform.asLocalURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public PDELabelProvider getLabelProvider() {
        if (this.runtimeUISupport == null) {
            this.loadRuntimeUISupport();
        }
        return this.runtimeUISupport.getLabelProvider();
    }

    public LaunchListener getLaunchesListener() {
        if (this.launchListener == null) {
            this.launchListener = new LaunchListener();
        }
        return this.launchListener;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        ColorManager.initializeDefaults(store);
        store.setDefault("Preferences.BuildpathPage.pluginProjectUpdate", true);
        store.setDefault("Preferences.BuildpathPage.fragmentProjectUpdate", true);
        store.setDefault("Preferences.BuildpathPage.manifestUpdate", true);
        store.setDefault("Launcher.plugin.duplicates", false);
        store.setDefault("Preferences.BuildpathPage.useClasspathContainers", false);
        store.setDefault("useSourcePage", false);
        store.setDefault("Preferences.MainPage.showObjects", "useIds");
        store.setDefault("javacDebugInfo", true);
        store.setDefault("javacFailOnError", false);
        store.setDefault("javacVerbose", true);
        store.setDefault("javacSource", "1.3");
        store.setDefault("javacTarget", "1.2");
        ExtendedTextEditorPreferenceConstants.initializeDefaultValues((IPreferenceStore)store);
    }

    public static boolean isFullNameModeEnabled() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString("Preferences.MainPage.showObjects").equals("useNames");
    }

    public static boolean isPluginProjectUpdate() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("Preferences.BuildpathPage.pluginProjectUpdate");
    }

    public static boolean isFragmentProjectUpdate() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("Preferences.BuildpathPage.fragmentProjectUpdate");
    }

    public static boolean isManifestUpdate() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("Preferences.BuildpathPage.manifestUpdate");
    }

    public static boolean isDuplicateWarningNeeded() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("Launcher.plugin.duplicates");
    }

    public static boolean isBuildPropertiesUpdate() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("Preferences.BuildpathPage.buildPropertiesUpdate");
    }

    public static boolean getUseClasspathContainers() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("Preferences.BuildpathPage.useClasspathContainers");
    }

    private void loadRuntimeUISupport() {
        IConfigurationElement[] runtimes = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.pde.ui", "alternativeRuntimeUISupport");
        if (runtimes.length == 0) {
            return;
        }
        IConfigurationElement runtime = runtimes[0];
        if (runtimes.length > 1) {
            runtime = null;
            int i = 0;
            while (i < runtimes.length) {
                String def = runtimes[i].getAttribute("default");
                if (def != null && def.equalsIgnoreCase("true")) {
                    if (!PDECore.isAlternativeRuntimeSupportEnabled()) {
                        runtime = runtimes[i];
                        break;
                    }
                } else if (runtime == null) {
                    runtime = runtimes[i];
                    break;
                }
                ++i;
            }
        }
        if (runtime == null) {
            return;
        }
        try {
            this.runtimeUISupport = (IAlternativeRuntimeUISupport)runtime.createExecutableExtension("class");
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

