/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRepeatable;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.util.SharedLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PDELabelProvider
extends SharedLabelProvider {
    private static final String KEY_OUT_OF_SYNC = "PluginModelManager.outOfSync";

    public String getText(Object obj) {
        if (obj instanceof IPluginModelBase) {
            return this.getObjectText(((IPluginModelBase)obj).getPluginBase());
        }
        if (obj instanceof IPluginBase) {
            return this.getObjectText((IPluginBase)obj);
        }
        if (obj instanceof ImportObject) {
            return this.getObjectText((ImportObject)obj);
        }
        if (obj instanceof IPluginImport) {
            return this.getObjectText((IPluginImport)obj);
        }
        if (obj instanceof IPluginLibrary) {
            return this.getObjectText((IPluginLibrary)obj);
        }
        if (obj instanceof IPluginExtensionPoint) {
            return this.getObjectText((IPluginExtensionPoint)obj);
        }
        if (obj instanceof NamedElement) {
            return ((NamedElement)obj).getLabel();
        }
        if (obj instanceof ISchemaObject) {
            return this.getObjectText((ISchemaObject)obj);
        }
        if (obj instanceof FeaturePlugin) {
            return this.getObjectText((FeaturePlugin)obj);
        }
        if (obj instanceof FeatureImport) {
            return this.getObjectText((FeatureImport)obj);
        }
        if (obj instanceof IFeatureModel) {
            return this.getObjectText((IFeatureModel)obj);
        }
        if (obj instanceof FeatureChild) {
            return this.getObjectText((FeatureChild)obj);
        }
        if (obj instanceof ISiteFeature) {
            return this.getObjectText((ISiteFeature)obj);
        }
        if (obj instanceof ISiteArchive) {
            return this.getObjectText((ISiteArchive)obj);
        }
        if (obj instanceof ISiteCategoryDefinition) {
            return this.getObjectText((ISiteCategoryDefinition)obj);
        }
        if (obj instanceof ISiteCategory) {
            return this.getObjectText((ISiteCategory)obj);
        }
        if (obj instanceof ISiteBuildFeature) {
            return this.getObjectText((ISiteBuildFeature)obj);
        }
        return super.getText(obj);
    }

    public String getObjectText(IPluginBase pluginBase) {
        String name = this.isFullNameModeEnabled() ? pluginBase.getTranslatedName() : pluginBase.getId();
        name = this.preventNull(name);
        String version = pluginBase.getVersion();
        String text = version != null && version.length() > 0 ? String.valueOf(name) + " (" + pluginBase.getVersion() + ")" : name;
        if (pluginBase.getModel() != null && !pluginBase.getModel().isInSync()) {
            text = String.valueOf(text) + " " + PDEPlugin.getResourceString(KEY_OUT_OF_SYNC);
        }
        return text;
    }

    private String preventNull(String text) {
        return text != null ? text : "";
    }

    public String getObjectText(IPluginExtension extension) {
        return this.preventNull(this.isFullNameModeEnabled() ? extension.getTranslatedName() : extension.getId());
    }

    public String getObjectText(IPluginExtensionPoint point) {
        return this.preventNull(this.isFullNameModeEnabled() ? point.getTranslatedName() : point.getId());
    }

    public String getObjectText(ImportObject obj) {
        if (this.isFullNameModeEnabled()) {
            return obj.toString();
        }
        return this.preventNull(obj.getId());
    }

    public String getObjectText(IPluginImport obj) {
        if (this.isFullNameModeEnabled()) {
            return obj.toString();
        }
        return this.preventNull(obj.getId());
    }

    public String getObjectText(IPluginLibrary obj) {
        return this.preventNull(obj.getName());
    }

    public String getObjectText(ISchemaObject obj) {
        String text = obj.getName();
        if (obj instanceof ISchemaRepeatable) {
            ISchemaRepeatable rso = (ISchemaRepeatable)obj;
            boolean unbounded = rso.getMaxOccurs() == Integer.MAX_VALUE;
            int maxOccurs = rso.getMaxOccurs();
            int minOccurs = rso.getMinOccurs();
            if (maxOccurs != 1 || minOccurs != 1) {
                text = String.valueOf(text) + " (" + minOccurs + " - ";
                text = unbounded ? String.valueOf(text) + "*)" : String.valueOf(text) + maxOccurs + ")";
            }
        }
        return text;
    }

    public String getObjectText(FeaturePlugin obj) {
        FeaturePlugin fref = obj;
        IPluginBase pluginBase = fref.getPluginBase();
        if (pluginBase != null) {
            return this.getObjectText(pluginBase);
        }
        String name = this.isFullNameModeEnabled() ? obj.getTranslatableLabel() : obj.getId();
        String version = obj.getVersion();
        String text = version != null && version.length() > 0 ? String.valueOf(name) + " (" + version + ")" : name;
        return this.preventNull(text);
    }

    public String getObjectText(FeatureImport obj) {
        IFeature feature;
        int type = obj.getType();
        if (type == 0) {
            IPlugin plugin = obj.getPlugin();
            if (plugin != null && this.isFullNameModeEnabled()) {
                return this.preventNull(plugin.getTranslatedName());
            }
        } else if (type == 1 && (feature = obj.getFeature()) != null && this.isFullNameModeEnabled()) {
            return this.preventNull(feature.getLabel());
        }
        return this.preventNull(obj.getId());
    }

    public String getObjectText(IFeatureModel obj) {
        IFeature feature = obj.getFeature();
        return String.valueOf(this.preventNull(feature.getId())) + " (" + this.preventNull(feature.getVersion()) + ")";
    }

    public String getObjectText(FeatureChild obj) {
        return String.valueOf(this.preventNull(obj.getId())) + " (" + this.preventNull(obj.getVersion()) + ")";
    }

    public String getObjectText(ISiteFeature obj) {
        return this.preventNull(obj.getURL());
    }

    public String getObjectText(ISiteArchive obj) {
        return this.preventNull(obj.getPath());
    }

    public String getObjectText(ISiteCategoryDefinition obj) {
        return this.preventNull(obj.getLabel());
    }

    public String getObjectText(ISiteCategory obj) {
        ISiteCategoryDefinition def = obj.getDefinition();
        if (def != null) {
            return this.preventNull(def.getLabel());
        }
        return this.preventNull(obj.getName());
    }

    public String getObjectText(ISiteBuildFeature obj) {
        return String.valueOf(this.preventNull(obj.getId())) + " (" + this.preventNull(obj.getVersion()) + ")";
    }

    public Image getImage(Object obj) {
        if (obj instanceof IPlugin) {
            return this.getObjectImage((IPlugin)obj);
        }
        if (obj instanceof IFragment) {
            return this.getObjectImage((IFragment)obj);
        }
        if (obj instanceof IPluginModel) {
            return this.getObjectImage(((IPluginModel)obj).getPlugin());
        }
        if (obj instanceof IFragmentModel) {
            return this.getObjectImage(((IFragmentModel)obj).getFragment());
        }
        if (obj instanceof ImportObject) {
            return this.getObjectImage((ImportObject)obj);
        }
        if (obj instanceof IPluginImport) {
            return this.getObjectImage((IPluginImport)obj);
        }
        if (obj instanceof IPluginLibrary) {
            return this.getObjectImage((IPluginLibrary)obj);
        }
        if (obj instanceof IPluginExtension) {
            return this.getObjectImage((IPluginExtension)obj);
        }
        if (obj instanceof IPluginExtensionPoint) {
            return this.getObjectImage((IPluginExtensionPoint)obj);
        }
        if (obj instanceof NamedElement) {
            return ((NamedElement)obj).getImage();
        }
        if (obj instanceof ISchemaElement) {
            return this.getObjectImage((ISchemaElement)obj);
        }
        if (obj instanceof ISchemaAttribute) {
            return this.getObjectImage((ISchemaAttribute)obj);
        }
        if (obj instanceof IDocumentSection || obj instanceof ISchema) {
            int flags = this.getSchemaObjectFlags((ISchemaObject)obj);
            return this.get(PDEPluginImages.DESC_DOC_SECTION_OBJ, flags);
        }
        if (obj instanceof ISchemaCompositor) {
            return this.getObjectImage((ISchemaCompositor)obj);
        }
        if (obj instanceof IFeatureURLElement) {
            return this.getObjectImage((IFeatureURLElement)obj);
        }
        if (obj instanceof IFeatureModel) {
            return this.get(PDEPluginImages.DESC_FEATURE_OBJ);
        }
        if (obj instanceof IFeatureChild) {
            return this.getObjectImage((IFeatureChild)obj);
        }
        if (obj instanceof IFeaturePlugin) {
            return this.getObjectImage((IFeaturePlugin)obj);
        }
        if (obj instanceof IFeatureData) {
            return this.getObjectImage((IFeatureData)obj);
        }
        if (obj instanceof IFeatureImport) {
            return this.getObjectImage((IFeatureImport)obj);
        }
        if (obj instanceof IFeatureInfo) {
            return this.getObjectImage((IFeatureInfo)obj);
        }
        if (obj instanceof IPDEEditorPage) {
            return this.get(PDEPluginImages.DESC_PAGE_OBJ);
        }
        if (obj instanceof IBuildEntry) {
            return this.get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
        }
        if (obj instanceof ISiteFeature) {
            return this.getObjectImage((ISiteFeature)obj);
        }
        if (obj instanceof ISiteArchive) {
            return this.getObjectImage((ISiteArchive)obj);
        }
        if (obj instanceof ISiteCategoryDefinition) {
            return this.getObjectImage((ISiteCategoryDefinition)obj);
        }
        if (obj instanceof ISiteCategory) {
            return this.getObjectImage((ISiteCategory)obj);
        }
        if (obj instanceof ISiteBuildFeature) {
            return this.getObjectImage((ISiteBuildFeature)obj);
        }
        return super.getImage(obj);
    }

    private Image getObjectImage(IPlugin plugin) {
        return this.getObjectImage(plugin, false, false);
    }

    public Image getObjectImage(IPlugin plugin, boolean checkEnabled, boolean javaSearch) {
        IPluginModelBase model = plugin.getPluginModel();
        int flags = this.getModelFlags(model);
        if (javaSearch) {
            flags |= 0x40;
        }
        ImageDescriptor desc = PDEPluginImages.DESC_PLUGIN_OBJ;
        if (checkEnabled && !model.isEnabled()) {
            desc = PDEPluginImages.DESC_EXT_PLUGIN_OBJ;
        }
        return this.get(desc, flags);
    }

    private int getModelFlags(IPluginModelBase model) {
        IResource resource;
        int flags = 0;
        if (!model.isLoaded() || !model.isInSync()) {
            flags = 1;
        }
        if ((resource = model.getUnderlyingResource()) == null) {
            flags |= 0x20;
        } else {
            IProject project = resource.getProject();
            try {
                String property;
                if (WorkspaceModelManager.isBinaryPluginProject((IProject)project) && (property = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY)) != null) {
                    flags |= 0x10;
                }
            }
            catch (CoreException coreException) {}
        }
        return flags;
    }

    private Image getObjectImage(IFragment fragment) {
        return this.getObjectImage(fragment, false, false);
    }

    public Image getObjectImage(IFragment fragment, boolean checkEnabled, boolean javaSearch) {
        IPluginModelBase model = fragment.getPluginModel();
        int flags = this.getModelFlags(model);
        if (javaSearch) {
            flags |= 0x40;
        }
        ImageDescriptor desc = PDEPluginImages.DESC_FRAGMENT_OBJ;
        if (checkEnabled && !model.isEnabled()) {
            desc = PDEPluginImages.DESC_EXT_FRAGMENT_OBJ;
        }
        return this.get(desc, flags);
    }

    private Image getObjectImage(ImportObject iobj) {
        int flags = 0;
        if (!iobj.isResolved()) {
            flags = 1;
        } else if (iobj.getImport().isReexported()) {
            flags = 4;
        }
        IPlugin plugin = iobj.getPlugin();
        if (plugin != null) {
            IPluginModelBase model = plugin.getPluginModel();
            flags |= this.getModelFlags(model);
        }
        return this.get(this.getRequiredPluginImageDescriptor(iobj.getImport()), flags);
    }

    protected ImageDescriptor getRequiredPluginImageDescriptor(IPluginImport iobj) {
        return PDEPluginImages.DESC_REQ_PLUGIN_OBJ;
    }

    private Image getObjectImage(IPluginImport obj) {
        int flags = 0;
        if (obj.isReexported()) {
            flags = 4;
        }
        return this.get(this.getRequiredPluginImageDescriptor(obj), flags);
    }

    private Image getObjectImage(IPluginLibrary library) {
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
    }

    private Image getObjectImage(IPluginExtension point) {
        return this.get(PDEPluginImages.DESC_EXTENSION_OBJ);
    }

    private Image getObjectImage(IPluginExtensionPoint point) {
        return this.get(PDEPluginImages.DESC_EXT_POINT_OBJ);
    }

    private Image getObjectImage(ISchemaElement element) {
        int flags = this.getSchemaObjectFlags((ISchemaObject)element);
        return this.get(PDEPluginImages.DESC_GEL_SC_OBJ, flags);
    }

    private Image getObjectImage(ISchemaAttribute att) {
        int flags = this.getSchemaObjectFlags((ISchemaObject)att);
        if (att.getKind() == 1) {
            return this.get(PDEPluginImages.DESC_ATT_CLASS_OBJ, flags);
        }
        if (att.getKind() == 2) {
            return this.get(PDEPluginImages.DESC_ATT_FILE_OBJ, flags);
        }
        if (att.getUse() == 1) {
            return this.get(PDEPluginImages.DESC_ATT_REQ_OBJ, flags);
        }
        return this.get(PDEPluginImages.DESC_ATT_IMPL_OBJ, flags);
    }

    private Image getObjectImage(ISchemaCompositor compositor) {
        switch (compositor.getKind()) {
            case 0: {
                return this.get(PDEPluginImages.DESC_ALL_SC_OBJ);
            }
            case 1: {
                return this.get(PDEPluginImages.DESC_CHOICE_SC_OBJ);
            }
            case 2: {
                return this.get(PDEPluginImages.DESC_SEQ_SC_OBJ);
            }
            case 3: {
                return this.get(PDEPluginImages.DESC_GROUP_SC_OBJ);
            }
        }
        return null;
    }

    private int getSchemaObjectFlags(ISchemaObject sobj) {
        int flags = 0;
        String text = sobj.getDescription();
        if (text != null) {
            text = text.trim();
        }
        if (text != null && text.length() > 0) {
            flags = 8;
        }
        return flags;
    }

    private Image getObjectImage(IFeatureURLElement url) {
        return this.get(PDEPluginImages.DESC_LINK_OBJ);
    }

    private Image getObjectImage(IFeaturePlugin plugin) {
        int flags = 0;
        if (((FeaturePlugin)plugin).getPluginBase() == null) {
            int cflag = CompilerFlags.getFlag((String)"compilers.f.unresolved-plugins");
            if (cflag == 0) {
                flags = 1;
            } else if (cflag == 1) {
                flags = 2;
            }
        }
        if (plugin.isFragment()) {
            return this.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
        }
        return this.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
    }

    private Image getObjectImage(IFeatureChild feature) {
        int flags = 0;
        if (((FeatureChild)feature).getReferencedFeature() == null) {
            int cflag = CompilerFlags.getFlag((String)"compilers.f.unresolved-features");
            if (cflag == 0) {
                flags = 1;
            } else if (cflag == 1) {
                flags = 2;
            }
        }
        return this.get(PDEPluginImages.DESC_FEATURE_OBJ, flags);
    }

    private Image getObjectImage(IFeatureData data) {
        int flags = 0;
        if (!data.exists()) {
            flags = 1;
        }
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(data.getId());
        return this.get(desc, flags);
    }

    private Image getObjectImage(IFeatureImport obj) {
        ImageDescriptor base;
        FeatureImport iimport = (FeatureImport)obj;
        int type = iimport.getType();
        int flags = 0;
        if (type == 1) {
            base = PDEPluginImages.DESC_FEATURE_OBJ;
            IFeature feature = iimport.getFeature();
            if (feature == null) {
                flags = 1;
            }
        } else {
            base = PDEPluginImages.DESC_REQ_PLUGIN_OBJ;
            IPlugin plugin = iimport.getPlugin();
            if (plugin == null) {
                flags = 1;
            }
        }
        return this.get(base, flags);
    }

    private Image getObjectImage(IFeatureInfo info) {
        int flags = 0;
        String text = info.getDescription();
        if (text != null) {
            text = text.trim();
        }
        if (text != null && text.length() > 0) {
            flags = 8;
        }
        return this.get(PDEPluginImages.DESC_DOC_SECTION_OBJ, flags);
    }

    public Image getObjectImage(ISiteFeature obj) {
        int flags = 0;
        if (obj.getArchiveFile() != null) {
            flags = 16;
        }
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ, flags);
    }

    public Image getObjectImage(ISiteArchive obj) {
        return this.get(PDEPluginImages.DESC_JAVA_LIB_OBJ, 0);
    }

    public Image getObjectImage(ISiteCategoryDefinition obj) {
        return this.get(PDEPluginImages.DESC_CATEGORY_OBJ);
    }

    public Image getObjectImage(ISiteCategory obj) {
        int flags = obj.getDefinition() == null ? 1 : 0;
        return this.get(PDEPluginImages.DESC_CATEGORY_OBJ, flags);
    }

    public Image getObjectImage(ISiteBuildFeature obj) {
        if (obj.getReferencedFeature() == null) {
            return this.get(PDEPluginImages.DESC_NOREF_FEATURE_OBJ);
        }
        return this.get(PDEPluginImages.DESC_FEATURE_OBJ);
    }

    public boolean isFullNameModeEnabled() {
        return PDEPlugin.isFullNameModeEnabled();
    }
}

