/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ccvs.ssh2;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.ccvs.ssh2.CVSSSH2Plugin;
import org.eclipse.team.ccvs.ssh2.CVSSSH2PreferencePage;
import org.eclipse.team.ccvs.ssh2.Policy;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

class JSchSession {
    private static final int SSH_DEFAULT_PORT = 22;
    private static JSch jsch = new JSch();
    private static Hashtable pool = new Hashtable();
    static String default_ssh_home = null;
    private static String current_ssh_home;

    static {
        String ssh_dir_name = ".ssh";
        if (BootLoader.getOS().equals("win32")) {
            ssh_dir_name = "ssh";
        }
        if ((default_ssh_home = System.getProperty("user.home")) != null) {
            default_ssh_home = String.valueOf(default_ssh_home) + File.separator + ssh_dir_name;
        }
        current_ssh_home = null;
    }

    JSchSession() {
    }

    static Session getSession(ICVSRepositoryLocation location, String username, String password, String hostname, int port, final IProgressMonitor monitor) throws JSchException {
        if (port == 0) {
            port = 22;
        }
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        String ssh_home = store.getString(CVSSSH2PreferencePage.KEY_SSH2HOME);
        if (current_ssh_home == null || !current_ssh_home.equals(ssh_home)) {
            current_ssh_home = ssh_home;
            if (ssh_home.length() == 0) {
                ssh_home = default_ssh_home;
            }
            try {
                File file = new File(ssh_home, "known_hosts");
                jsch.setKnownHosts(file.getPath());
                String pkeys = store.getString(CVSSSH2PreferencePage.KEY_PRIVATEKEY);
                String[] pkey = pkeys.split(",");
                int i = 0;
                while (i < pkey.length) {
                    file = new File(ssh_home, pkey[i]);
                    if (file.exists()) {
                        jsch.addIdentity(file.getPath());
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        String key = String.valueOf(username) + "@" + hostname + ":" + port;
        try {
            Session session = (Session)pool.get(key);
            if (session != null && !session.isConnected()) {
                pool.remove(key);
                session = null;
            }
            if (session == null) {
                session = jsch.getSession(username, hostname, port);
                boolean useProxy = store.getString(CVSSSH2PreferencePage.KEY_PROXY).equals("true");
                if (useProxy) {
                    String _type = store.getString(CVSSSH2PreferencePage.KEY_PROXY_TYPE);
                    String _host = store.getString(CVSSSH2PreferencePage.KEY_PROXY_HOST);
                    String _port = store.getString(CVSSSH2PreferencePage.KEY_PROXY_PORT);
                    boolean useAuth = store.getString(CVSSSH2PreferencePage.KEY_PROXY_AUTH).equals("true");
                    String _user = store.getString(CVSSSH2PreferencePage.KEY_PROXY_USER);
                    String _pass = store.getString(CVSSSH2PreferencePage.KEY_PROXY_PASS);
                    ProxyHTTP proxy = null;
                    String proxyhost = String.valueOf(_host) + ":" + _port;
                    if (_type.equals(CVSSSH2PreferencePage.HTTP)) {
                        proxy = new ProxyHTTP(proxyhost);
                        if (useAuth) {
                            proxy.setUserPasswd(_user, _pass);
                        }
                    } else if (_type.equals(CVSSSH2PreferencePage.SOCKS5)) {
                        proxy = new ProxySOCKS5(proxyhost);
                        if (useAuth) {
                            ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
                        }
                    } else {
                        proxy = null;
                    }
                    if (proxy != null) {
                        session.setProxy((Proxy)proxy);
                    }
                }
                session.setPassword(password);
                MyUserInfo ui = new MyUserInfo(username, location);
                session.setUserInfo((UserInfo)ui);
                session.setSocketFactory(new SocketFactory(){
                    InputStream in = null;
                    OutputStream out = null;

                    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                        Socket socket = null;
                        socket = Util.createSocket((String)host, (int)port, (IProgressMonitor)monitor);
                        return socket;
                    }

                    public InputStream getInputStream(Socket socket) throws IOException {
                        if (this.in == null) {
                            this.in = socket.getInputStream();
                        }
                        return this.in;
                    }

                    public OutputStream getOutputStream(Socket socket) throws IOException {
                        if (this.out == null) {
                            this.out = socket.getOutputStream();
                        }
                        return this.out;
                    }
                });
                session.connect();
                pool.put(key, session);
            }
            return session;
        }
        catch (JSchException e) {
            pool.remove(key);
            throw e;
        }
    }

    static void shutdown() {
        if (jsch != null && pool.size() > 0) {
            Enumeration e = pool.elements();
            while (e.hasMoreElements()) {
                Session session = (Session)e.nextElement();
                try {
                    session.disconnect();
                }
                catch (Exception exception) {}
            }
            pool.clear();
        }
    }

    static JSch getJSch() {
        return jsch;
    }

    private static class MyUserInfo
    implements UserInfo {
        private String username;
        private String password;
        private String passphrase;
        private ICVSRepositoryLocation location;

        MyUserInfo(String username, ICVSRepositoryLocation location) {
            this.location = location;
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptYesNo(String str) {
            IUserAuthenticator authenticator = this.location.getUserAuthenticator();
            int prompt = authenticator.prompt(this.location, 3, Policy.bind("JSchSession.5"), str, new int[]{2, 3}, 0);
            return prompt == 0;
        }

        public boolean promptPassphrase(String message) {
            IUserAuthenticator authenticator = this.location.getUserAuthenticator();
            String[] _password = new String[1];
            IUserInfo info = new IUserInfo(this, _password){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String[] val$_password;
                {
                    this.this$1 = myUserInfo;
                    this.val$_password = stringArray;
                }

                public String getUsername() {
                    return MyUserInfo.access$0(this.this$1);
                }

                public boolean isUsernameMutable() {
                    return false;
                }

                public void setPassword(String password) {
                    this.val$_password[0] = password;
                }

                public void setUsername(String username) {
                }
            };
            try {
                authenticator.promptForUserInfo(this.location, info, message);
            }
            catch (CVSException cVSException) {
                return false;
            }
            if (_password[0] != null) {
                this.passphrase = _password[0];
            }
            return _password != null;
        }

        public boolean promptPassword(String message) {
            return this.promptPassphrase(message);
        }

        public void showMessage(String message) {
            IUserAuthenticator authenticator = this.location.getUserAuthenticator();
            authenticator.prompt(this.location, 2, Policy.bind("JSchSession.5"), message, new int[1], 0);
        }

        static /* synthetic */ String access$0(MyUserInfo myUserInfo) {
            return myUserInfo.username;
        }
    }
}

