/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.Vector;
import junit.extensions.TestDecorator;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.jdt.internal.junit.runner.JUnitMessages;

public class RemoteTestRunner
implements TestListener {
    private static final String SET_UP_TEST_METHOD_NAME = "setUpTest";
    private static final String SUITE_METHODNAME = "suite";
    private String[] fTestClassNames;
    private String fTestName;
    private TestResult fTestResult;
    private Socket fClientSocket;
    private PrintWriter fWriter;
    private BufferedReader fReader;
    private String fHost = "";
    private int fPort = -1;
    private boolean fDebugMode = false;
    private boolean fKeepAlive = false;
    private boolean fStopped = false;
    private Vector fRerunRequests = new Vector(10);
    private ReaderThread fReaderThread;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void main(String[] args) {
        RemoteTestRunner testRunServer = new RemoteTestRunner();
        testRunServer.init(args);
        testRunServer.run();
        System.exit(0);
    }

    protected void init(String[] args) {
        this.defaultInit(args);
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected final void defaultInit(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("-classnames") || args[i].toLowerCase().equals("-classname")) {
                Vector<String> list = new Vector<String>();
                int j = i + 1;
                while (j < args.length) {
                    if (args[j].startsWith("-")) break;
                    list.add(args[j]);
                    ++j;
                }
                this.fTestClassNames = list.toArray(new String[list.size()]);
            } else if (args[i].toLowerCase().equals("-test")) {
                String testName = args[i + 1];
                int p = testName.indexOf(58);
                if (p == -1) {
                    throw new IllegalArgumentException("Testname not separated by '%'");
                }
                this.fTestName = testName.substring(p + 1);
                this.fTestClassNames = new String[]{testName.substring(0, p)};
                ++i;
            } else if (args[i].toLowerCase().equals("-testnamefile")) {
                String testNameFile = args[i + 1];
                try {
                    this.readTestNames(testNameFile);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Cannot read testname file.");
                }
                ++i;
            } else if (args[i].toLowerCase().equals("-port")) {
                this.fPort = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].toLowerCase().equals("-host")) {
                this.fHost = args[i + 1];
                ++i;
            } else if (args[i].toLowerCase().equals("-keepalive")) {
                this.fKeepAlive = true;
            } else if (args[i].toLowerCase().equals("-debugging") || args[i].toLowerCase().equals("-debug")) {
                this.fDebugMode = true;
            }
            ++i;
        }
        if (this.fTestClassNames == null || this.fTestClassNames.length == 0) {
            throw new IllegalArgumentException(JUnitMessages.getString("RemoteTestRunner.error.classnamemissing"));
        }
        if (this.fPort == -1) {
            throw new IllegalArgumentException(JUnitMessages.getString("RemoteTestRunner.error.portmissing"));
        }
        if (this.fDebugMode) {
            System.out.println("keepalive " + this.fKeepAlive);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readTestNames(String testNameFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(new File(testNameFile)));
        try {
            Vector<String> list = new Vector<String>();
            while (true) {
                String line;
                block6: {
                    if ((line = br.readLine()) != null) break block6;
                    this.fTestClassNames = list.toArray(new String[list.size()]);
                    break;
                }
                list.add(line);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            br.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        br.close();
        if (this.fDebugMode) {
            System.out.println("Tests:");
            int i = 0;
            while (i < this.fTestClassNames.length) {
                System.out.println("    " + this.fTestClassNames[i]);
                ++i;
            }
        }
    }

    protected void run() {
        if (!this.connect()) {
            return;
        }
        this.fTestResult = new TestResult();
        this.fTestResult.addListener((TestListener)this);
        this.runTests(this.fTestClassNames, this.fTestName);
        this.fTestResult.removeListener((TestListener)this);
        if (this.fTestResult != null) {
            this.fTestResult.stop();
            this.fTestResult = null;
        }
        if (this.fKeepAlive) {
            this.waitForReruns();
        }
        this.shutDown();
    }

    private synchronized void waitForReruns() {
        while (!this.fStopped) {
            try {
                this.wait();
                if (this.fStopped || this.fRerunRequests.size() <= 0) continue;
                RerunRequest r = (RerunRequest)this.fRerunRequests.remove(0);
                this.rerunTest(r.fRerunTestId, r.fRerunClassName, r.fRerunTestName);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Test getTest(String suiteClassName, String testName) {
        Class testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.classnotfound", clazz));
            return null;
        }
        catch (Exception e) {
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.exception", e));
            return null;
        }
        if (testName != null) {
            return this.setupTest(testClass, this.createTest(testName, testClass));
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            return new TestSuite(testClass);
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.invoke", e.getTargetException().toString()));
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.invoke", e.toString()));
            return null;
        }
        return test;
    }

    protected void runFailed(String message) {
        System.err.println(message);
    }

    private Class loadSuiteClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        return this.getClassLoader().loadClass(className);
    }

    private void runTests(String[] testClassNames, String testName) {
        Test[] suites = new Test[testClassNames.length];
        int i = 0;
        while (i < suites.length) {
            suites[i] = this.getTest(testClassNames[i], testName);
            ++i;
        }
        int count = this.countTests(suites);
        this.notifyTestRunStarted(count);
        if (count == 0) {
            this.notifyTestRunEnded(0L);
            return;
        }
        long startTime = System.currentTimeMillis();
        if (this.fDebugMode) {
            System.out.print("start send tree...");
        }
        int i2 = 0;
        while (i2 < suites.length) {
            this.sendTree(suites[i2]);
            ++i2;
        }
        if (this.fDebugMode) {
            System.out.println("done send tree - time(ms): " + (System.currentTimeMillis() - startTime));
        }
        long testStartTime = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < suites.length) {
            suites[i3].run(this.fTestResult);
            ++i3;
        }
        if (this.fTestResult == null || this.fTestResult.shouldStop()) {
            this.notifyTestRunStopped(System.currentTimeMillis() - testStartTime);
        } else {
            this.notifyTestRunEnded(System.currentTimeMillis() - testStartTime);
        }
    }

    private int countTests(Test[] tests) {
        int count = 0;
        int i = 0;
        while (i < tests.length) {
            if (tests[i] != null) {
                count += tests[i].countTestCases();
            }
            ++i;
        }
        return count;
    }

    public void rerunTest(int testId, String className, String testName) {
        Test reloadedTest = null;
        Class<?> reloadedTestClass = null;
        try {
            reloadedTestClass = this.getClassLoader().loadClass(className);
            reloadedTest = this.createTest(testName, reloadedTestClass);
        }
        catch (Exception exception) {
            reloadedTest = this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotcreate", testName));
        }
        Test rerunTest = this.setupTest(reloadedTestClass, reloadedTest);
        TestResult result = new TestResult();
        rerunTest.run(result);
        this.notifyTestReran(result, Integer.toString(testId), className, testName);
    }

    private Test setupTest(Class reloadedTestClass, Test reloadedTest) {
        Method setup = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljunit.framework.Test;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            setup = reloadedTestClass.getMethod(SET_UP_TEST_METHOD_NAME, classArray);
        }
        catch (SecurityException securityException) {
            return reloadedTest;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return reloadedTest;
        }
        Class<?> clazz = setup.getReturnType();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljunit.framework.Test;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            return this.warning(JUnitMessages.getString("RemoteTestRunner.error.notestreturn"));
        }
        if (!Modifier.isPublic(setup.getModifiers())) {
            return this.warning(JUnitMessages.getString("RemoteTestRunner.error.shouldbepublic"));
        }
        if (!Modifier.isStatic(setup.getModifiers())) {
            return this.warning(JUnitMessages.getString("RemoteTestRunner.error.shouldbestatic"));
        }
        try {
            Test test = (Test)setup.invoke(null, reloadedTest);
            if (test == null) {
                return this.warning(JUnitMessages.getString("RemoteTestRunner.error.nullreturn"));
            }
            return test;
        }
        catch (IllegalArgumentException e) {
            return this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotinvoke", e));
        }
        catch (IllegalAccessException e) {
            return this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.couldnotinvoke", e));
        }
        catch (InvocationTargetException e) {
            return this.warning(JUnitMessages.getFormattedString("RemoteTestRunner.error.invocationexception", e.getTargetException()));
        }
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                Assert.fail((String)message);
            }
        };
    }

    private Test createTest(String testName, Class testClass) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArgs = classArray;
        Constructor constructor = null;
        try {
            Test test;
            block13: {
                try {
                    constructor = testClass.getConstructor(classArgs);
                    test = (Test)constructor.newInstance(testName);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    constructor = testClass.getConstructor(new Class[0]);
                    test = (Test)constructor.newInstance(new Object[0]);
                    if (!(test instanceof TestCase)) break block13;
                    ((TestCase)test).setName(testName);
                }
            }
            if (test != null) {
                return test;
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassCastException classCastException) {}
        return this.warning("Could not create test '" + testName + "' ");
    }

    public final void addError(Test test, Throwable throwable) {
        this.notifyTestFailed(test, "%ERROR  ", this.getTrace(throwable));
    }

    public final void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.notifyTestFailed(test, "%FAILED ", this.getTrace((Throwable)assertionFailedError));
    }

    public void endTest(Test test) {
        this.notifyTestEnded(test);
    }

    public void startTest(Test test) {
        this.notifyTestStarted(test);
    }

    private void sendTree(Test test) {
        if (test instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test;
            this.sendTree(decorator.getTest());
        } else if (test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            this.notifyTestTreeEntry(String.valueOf(this.getTestId(test)) + ',' + this.escapeComma(suite.toString().trim()) + ',' + true + ',' + suite.testCount());
            int i = 0;
            while (i < suite.testCount()) {
                this.sendTree(suite.testAt(i));
                ++i;
            }
        } else {
            this.notifyTestTreeEntry(String.valueOf(this.getTestId(test)) + ',' + this.escapeComma(this.getTestName(test).trim()) + ',' + false + ',' + test.countTestCases());
        }
    }

    private String escapeComma(String s) {
        if (s.indexOf(44) < 0 && s.indexOf(92) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == ',') {
                sb.append("\\,");
            } else if (c == '\\') {
                sb.append("\\\\");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private String getTestId(Test test) {
        return Integer.toString(System.identityHashCode(test));
    }

    private String getTestName(Test test) {
        return test.toString();
    }

    private String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    protected void stop() {
        if (this.fTestResult != null) {
            this.fTestResult.stop();
        }
    }

    private boolean connect() {
        if (this.fDebugMode) {
            System.out.println("RemoteTestRunner: trying to connect" + this.fHost + ":" + this.fPort);
        }
        IOException exception = null;
        int i = 1;
        while (i < 20) {
            try {
                this.fClientSocket = new Socket(this.fHost, this.fPort);
                this.fWriter = new PrintWriter(this.fClientSocket.getOutputStream(), false);
                this.fReader = new BufferedReader(new InputStreamReader(this.fClientSocket.getInputStream()));
                this.fReaderThread = new ReaderThread();
                this.fReaderThread.start();
                return true;
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        this.runFailed(JUnitMessages.getFormattedString("RemoteTestRunner.error.connect", new String[]{this.fHost, Integer.toString(this.fPort)}));
        exception.printStackTrace();
        return false;
    }

    private void shutDown() {
        block9: {
            block8: {
                if (this.fWriter != null) {
                    this.fWriter.close();
                    this.fWriter = null;
                }
                try {
                    if (this.fReaderThread != null) {
                        this.fReaderThread.interrupt();
                    }
                    if (this.fReader != null) {
                        this.fReader.close();
                        this.fReader = null;
                    }
                }
                catch (IOException e) {
                    if (!this.fDebugMode) break block8;
                    e.printStackTrace();
                }
            }
            try {
                if (this.fClientSocket != null) {
                    this.fClientSocket.close();
                    this.fClientSocket = null;
                }
            }
            catch (IOException e) {
                if (!this.fDebugMode) break block9;
                e.printStackTrace();
            }
        }
    }

    private void sendMessage(String msg) {
        if (this.fWriter == null) {
            return;
        }
        this.fWriter.println(msg);
    }

    private void notifyTestRunStarted(int testCount) {
        this.sendMessage("%TESTC  " + testCount + " " + "v2");
    }

    private void notifyTestRunEnded(long elapsedTime) {
        this.sendMessage("%RUNTIME" + elapsedTime);
        this.fWriter.flush();
    }

    private void notifyTestRunStopped(long elapsedTime) {
        this.sendMessage("%TSTSTP " + elapsedTime);
        this.fWriter.flush();
    }

    private void notifyTestStarted(Test test) {
        this.sendMessage("%TESTS  " + this.getTestId(test) + ',' + test.toString());
        this.fWriter.flush();
    }

    private void notifyTestEnded(Test test) {
        this.sendMessage("%TESTE  " + this.getTestId(test) + ',' + this.getTestName(test));
    }

    private void notifyTestFailed(Test test, String status, String trace) {
        this.sendMessage(String.valueOf(status) + this.getTestId(test) + ',' + this.getTestName(test));
        this.sendMessage("%TRACES ");
        this.sendMessage(trace);
        this.sendMessage("%TRACEE ");
        this.fWriter.flush();
    }

    private void notifyTestTreeEntry(String treeEntry) {
        this.sendMessage("%TSTTREE" + treeEntry);
    }

    private void notifyTestReran(TestResult result, String testId, String testClass, String testName) {
        TestFailure failure = null;
        if (result.errorCount() > 0) {
            failure = (TestFailure)result.errors().nextElement();
        }
        if (result.failureCount() > 0) {
            failure = (TestFailure)result.failures().nextElement();
        }
        if (failure != null) {
            Throwable t = failure.thrownException();
            String trace = this.getTrace(t);
            this.sendMessage("%RTRACES");
            this.sendMessage(trace);
            this.sendMessage("%RTRACEE");
            this.fWriter.flush();
        }
        String status = "OK";
        if (result.errorCount() > 0) {
            status = "ERROR";
        } else if (result.failureCount() > 0) {
            status = "FAILURE";
        }
        if (this.fPort != -1) {
            this.sendMessage("%TSTRERN" + testId + " " + testClass + " " + testName + " " + status);
            this.fWriter.flush();
        }
    }

    static /* synthetic */ BufferedReader access$0(RemoteTestRunner remoteTestRunner) {
        return remoteTestRunner.fReader;
    }

    static /* synthetic */ void access$1(RemoteTestRunner remoteTestRunner, boolean bl) {
        remoteTestRunner.fStopped = bl;
    }

    static /* synthetic */ Vector access$2(RemoteTestRunner remoteTestRunner) {
        return remoteTestRunner.fRerunRequests;
    }

    private static class RerunRequest {
        String fRerunClassName;
        String fRerunTestName;
        int fRerunTestId;

        public RerunRequest(int testId, String className, String testName) {
            this.fRerunTestId = testId;
            this.fRerunClassName = className;
            this.fRerunTestName = testName;
        }
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

