/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenLaunchDialogAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private String fIdentifier;
    private IAction fAction;

    public OpenLaunchDialogAction(String identifier) {
        this.fIdentifier = identifier;
        LaunchGroupExtension extension = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(identifier);
        if (extension != null) {
            this.setText(String.valueOf(extension.getLabel()) + "...");
            this.setImageDescriptor(extension.getImageDescriptor());
        }
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.OPEN_LAUNCH_CONFIGURATION_ACTION);
    }

    public void run() {
        LaunchHistory history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory(this.fIdentifier);
        ILaunchConfiguration configuration = history.getRecentLaunch();
        StructuredSelection selection = null;
        selection = configuration == null ? new StructuredSelection() : new StructuredSelection((Object)configuration);
        DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)selection, this.fIdentifier);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    private void initialize(IAction action) {
        this.fAction = action;
        action.setEnabled(this.existsConfigTypesForMode());
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getMode() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.fIdentifier).getMode();
    }
}

