/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class CommonTab
extends AbstractLaunchConfigurationTab {
    private Label fLocalSharedLabel;
    private Button fLocalRadioButton;
    private Button fSharedRadioButton;
    private Label fSharedLocationLabel;
    private Text fSharedLocationText;
    private Button fSharedLocationButton;
    protected Button fLaunchInBackgroundButton;
    private CheckboxTableViewer fFavoritesTable;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            CommonTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_COMMON_TAB);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 1);
        Composite radioComp = new Composite(comp, 0);
        GridLayout radioLayout = new GridLayout();
        radioLayout.marginHeight = 0;
        radioLayout.marginWidth = 0;
        radioComp.setLayout((Layout)radioLayout);
        this.setLocalSharedLabel(new Label(radioComp, 0));
        this.getLocalSharedLabel().setText(LaunchConfigurationsMessages.getString("CommonTab.Type_of_launch_configuration__2"));
        this.getLocalSharedLabel().setFont(font);
        this.setLocalRadioButton(new Button(radioComp, 16));
        this.getLocalRadioButton().setText(LaunchConfigurationsMessages.getString("CommonTab.L&ocal_3"));
        this.getLocalRadioButton().setFont(font);
        this.setSharedRadioButton(new Button(radioComp, 16));
        this.getSharedRadioButton().setText(LaunchConfigurationsMessages.getString("CommonTab.S&hared_4"));
        this.getSharedRadioButton().setFont(font);
        this.getSharedRadioButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonTab.this.handleSharedRadioButtonSelected();
            }
        });
        Composite locationComp = new Composite(comp, 0);
        GridLayout locationLayout = new GridLayout();
        locationLayout.numColumns = 2;
        locationLayout.marginHeight = 0;
        locationLayout.marginWidth = 0;
        locationComp.setLayout((Layout)locationLayout);
        GridData gd = new GridData(768);
        locationComp.setLayoutData((Object)gd);
        locationComp.setFont(font);
        this.setSharedLocationLabel(new Label(locationComp, 0));
        this.getSharedLocationLabel().setText(LaunchConfigurationsMessages.getString("CommonTab.Location_of_shared_confi&guration__5"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.getSharedLocationLabel().setLayoutData((Object)gd);
        this.getSharedLocationLabel().setFont(font);
        this.setSharedLocationText(new Text(locationComp, 2052));
        gd = new GridData(768);
        this.getSharedLocationText().setLayoutData((Object)gd);
        this.getSharedLocationText().setFont(font);
        this.getSharedLocationText().addModifyListener(this.fBasicModifyListener);
        this.setSharedLocationButton(this.createPushButton(locationComp, LaunchConfigurationsMessages.getString("CommonTab.&Browse_6"), null));
        this.getSharedLocationButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonTab.this.handleSharedLocationButtonSelected();
            }
        });
        this.getLocalRadioButton().setSelection(true);
        this.setSharedEnabled(false);
        this.createVerticalSpacer(comp, 1);
        Composite favComp = new Composite(comp, 0);
        gd = new GridData(768);
        favComp.setLayoutData((Object)gd);
        GridLayout favLayout = new GridLayout();
        favLayout.marginHeight = 0;
        favLayout.marginWidth = 0;
        favLayout.numColumns = 2;
        favLayout.makeColumnsEqualWidth = true;
        favComp.setLayout((Layout)favLayout);
        favComp.setFont(font);
        Label favLabel = new Label(favComp, 16640);
        favLabel.setText(LaunchConfigurationsMessages.getString("CommonTab.Display_in_favorites_menu__10"));
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        favLabel.setLayoutData((Object)gd);
        favLabel.setFont(font);
        this.fFavoritesTable = CheckboxTableViewer.newCheckList((Composite)favComp, (int)67618);
        Control table = this.fFavoritesTable.getControl();
        gd = new GridData(32);
        gd.horizontalSpan = 1;
        table.setLayoutData((Object)gd);
        table.setFont(font);
        this.fFavoritesTable.setContentProvider((IContentProvider)new FavoritesContentProvider());
        this.fFavoritesTable.setLabelProvider((IBaseLabelProvider)new FavoritesLabelProvider());
        this.fFavoritesTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 1);
        this.createLaunchInBackgroundComponent(comp);
    }

    protected void createLaunchInBackgroundComponent(Composite parent) {
        this.fLaunchInBackgroundButton = new Button(parent, 32);
        this.fLaunchInBackgroundButton.setText(LaunchConfigurationsMessages.getString("CommonTab.10"));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fLaunchInBackgroundButton.setLayoutData((Object)data);
        this.fLaunchInBackgroundButton.setFont(parent.getFont());
        this.fLaunchInBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void setSharedLocationButton(Button sharedLocationButton) {
        this.fSharedLocationButton = sharedLocationButton;
    }

    private Button getSharedLocationButton() {
        return this.fSharedLocationButton;
    }

    private void setSharedLocationText(Text sharedLocationText) {
        this.fSharedLocationText = sharedLocationText;
    }

    private Text getSharedLocationText() {
        return this.fSharedLocationText;
    }

    private void setSharedLocationLabel(Label sharedLocationLabel) {
        this.fSharedLocationLabel = sharedLocationLabel;
    }

    private Label getSharedLocationLabel() {
        return this.fSharedLocationLabel;
    }

    private void setLocalSharedLabel(Label localSharedLabel) {
        this.fLocalSharedLabel = localSharedLabel;
    }

    private Label getLocalSharedLabel() {
        return this.fLocalSharedLabel;
    }

    private void setLocalRadioButton(Button button) {
        this.fLocalRadioButton = button;
    }

    private Button getLocalRadioButton() {
        return this.fLocalRadioButton;
    }

    private void setSharedRadioButton(Button button) {
        this.fSharedRadioButton = button;
    }

    private Button getSharedRadioButton() {
        return this.fSharedRadioButton;
    }

    private void handleSharedRadioButtonSelected() {
        this.setSharedEnabled(this.isShared());
        this.updateLaunchConfigurationDialog();
    }

    private void setSharedEnabled(boolean enable) {
        this.getSharedLocationLabel().setEnabled(enable);
        this.getSharedLocationText().setEnabled(enable);
        this.getSharedLocationButton().setEnabled(enable);
    }

    private boolean isShared() {
        return this.getSharedRadioButton().getSelection();
    }

    private void handleSharedLocationButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)this.getWorkspaceRoot(), false, LaunchConfigurationsMessages.getString("CommonTab.Select_a_location_for_the_launch_configuration_13"));
        String currentContainerString = this.getSharedLocationText().getText();
        IContainer currentContainer = this.getContainer(currentContainerString);
        if (currentContainer != null) {
            IPath path = currentContainer.getFullPath();
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.toOSString();
            this.getSharedLocationText().setText(containerName);
        }
    }

    private IContainer getContainer(String path) {
        Path containerPath = new Path(path);
        return (IContainer)this.getWorkspaceRoot().findMember((IPath)containerPath);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateLocalSharedFromConfig(configuration);
        this.updateSharedLocationFromConfig(configuration);
        this.updateFavoritesFromConfig(configuration);
        this.updateLaunchInBackground(configuration);
    }

    protected void updateLaunchInBackground(ILaunchConfiguration configuration) {
        this.fLaunchInBackgroundButton.setSelection(CommonTab.isLaunchInBackground(configuration));
    }

    public static boolean isLaunchInBackground(ILaunchConfiguration configuration) {
        boolean launchInBackground = true;
        try {
            launchInBackground = configuration.getAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, true);
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return launchInBackground;
    }

    private void updateLocalSharedFromConfig(ILaunchConfiguration config) {
        boolean isShared = !config.isLocal();
        this.getSharedRadioButton().setSelection(isShared);
        this.getLocalRadioButton().setSelection(!isShared);
        this.setSharedEnabled(isShared);
    }

    private void updateSharedLocationFromConfig(ILaunchConfiguration config) {
        IContainer parent;
        IFile file = config.getFile();
        if (file != null && (parent = file.getParent()) != null) {
            String containerName = parent.getFullPath().toOSString();
            this.getSharedLocationText().setText(containerName);
        }
    }

    private void updateFavoritesFromConfig(ILaunchConfiguration config) {
        this.fFavoritesTable.setInput((Object)config);
        this.fFavoritesTable.setCheckedElements(new Object[0]);
        try {
            List groups = config.getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, new ArrayList());
            if (groups.isEmpty()) {
                if (config.getAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, false)) {
                    groups.add(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP);
                }
                if (config.getAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, false)) {
                    groups.add(IDebugUIConstants.ID_RUN_LAUNCH_GROUP);
                }
            }
            if (!groups.isEmpty()) {
                ArrayList<LaunchGroupExtension> list = new ArrayList<LaunchGroupExtension>();
                Iterator iterator = groups.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    LaunchGroupExtension extension = this.getLaunchConfigurationManager().getLaunchGroup(id);
                    list.add(extension);
                }
                this.fFavoritesTable.setCheckedElements(list.toArray());
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private void updateConfigFromLocalShared(ILaunchConfigurationWorkingCopy config) {
        if (this.isShared()) {
            String containerPathString = this.getSharedLocationText().getText();
            IContainer container = this.getContainer(containerPathString);
            config.setContainer(container);
        } else {
            config.setContainer(null);
        }
    }

    private void updateConfigFromFavorites(ILaunchConfigurationWorkingCopy config) {
        try {
            ArrayList<Object> groups;
            Object[] checked = this.fFavoritesTable.getCheckedElements();
            boolean debug = config.getAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, false);
            boolean run = config.getAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, false);
            if (debug || run) {
                groups = new ArrayList<Object>();
                int num = 0;
                if (debug) {
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP));
                    ++num;
                }
                if (run) {
                    ++num;
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup(IDebugUIConstants.ID_DEBUG_LAUNCH_GROUP));
                }
                if (num == checked.length) {
                    boolean different = false;
                    int i = 0;
                    while (i < checked.length) {
                        if (!groups.contains(checked[i])) {
                            different = true;
                            break;
                        }
                        ++i;
                    }
                    if (!different) {
                        return;
                    }
                }
            }
            config.setAttribute(IDebugUIConstants.ATTR_DEBUG_FAVORITE, null);
            config.setAttribute(IDebugUIConstants.ATTR_RUN_FAVORITE, null);
            groups = null;
            int i = 0;
            while (i < checked.length) {
                LaunchGroupExtension group = (LaunchGroupExtension)checked[i];
                if (groups == null) {
                    groups = new ArrayList();
                }
                groups.add(group.getIdentifier());
                ++i;
            }
            config.setAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, groups);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateLocalShared();
    }

    private boolean validateLocalShared() {
        if (this.isShared()) {
            String path = this.fSharedLocationText.getText().trim();
            IContainer container = this.getContainer(path);
            if (container == null || container.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                this.setErrorMessage(LaunchConfigurationsMessages.getString("CommonTab.Invalid_shared_configuration_location_14"));
                return false;
            }
            if (!container.getProject().isOpen()) {
                this.setErrorMessage(LaunchConfigurationsMessages.getString("CommonTab.Cannot_save_launch_configuration_in_a_closed_project._1"));
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
        config.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.updateConfigFromLocalShared(configuration);
        this.updateConfigFromFavorites(configuration);
        this.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, configuration, this.fLaunchInBackgroundButton.getSelection(), true);
    }

    public String getName() {
        return LaunchConfigurationsMessages.getString("CommonTab.&Common_15");
    }

    public boolean canSave() {
        return this.validateLocalShared();
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_OBJS_COMMON_TAB");
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    class FavoritesContentProvider
    implements IStructuredContentProvider {
        FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            LaunchGroupExtension[] groups = CommonTab.this.getLaunchConfigurationManager().getLaunchGroups();
            ArrayList<LaunchGroupExtension> possibleGroups = new ArrayList<LaunchGroupExtension>();
            ILaunchConfiguration configuration = (ILaunchConfiguration)inputElement;
            int i = 0;
            while (i < groups.length) {
                LaunchGroupExtension extension = groups[i];
                LaunchHistory history = CommonTab.this.getLaunchConfigurationManager().getLaunchHistory(extension.getIdentifier());
                if (history != null && history.accepts(configuration)) {
                    possibleGroups.add(extension);
                }
                ++i;
            }
            return possibleGroups.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class FavoritesLabelProvider
    implements ITableLabelProvider {
        private Map fImages = new HashMap();

        FavoritesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ImageDescriptor descriptor;
            Image image = (Image)this.fImages.get(element);
            if (image == null && (descriptor = ((LaunchGroupExtension)element).getImageDescriptor()) != null) {
                image = descriptor.createImage();
                this.fImages.put(element, image);
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String label = ((LaunchGroupExtension)element).getLabel();
            int index = label.indexOf(38);
            if (index == 0) {
                label = label.substring(1);
            } else if (index > 0 && index < label.length() - 1) {
                String first = label.substring(0, index);
                String last = label.substring(index + 1);
                label = String.valueOf(first) + last;
            }
            return label;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Iterator images = this.fImages.values().iterator();
            while (images.hasNext()) {
                Image image = (Image)images.next();
                image.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

